/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

/* ----------------------------------------------------------------- */
char *grapherrormsg(int errorcode)
{
  switch (errorcode) {
    case grOk             : return "No error";
    case grNoInitGraph    : return "graphics not initialized";
    case grNotDetected    : return "Graphics hardware not detected";
    case grFileNotFound   : return "Device driver file not found";
    case grInvalidDriver  : return "Invalid device driver file";
    case grNoLoadMem      : return "Not enough memory to load driver";
    case grNoScanMem      : return "Out of memory in scan fill";
    case grNoFloodMem     : return "Out of memory in flood fill";
    case grFontNotFound   : return "Font file not found";
    case grNoFontMem      : return "Not enough memory to load font";
    case grInvalidMode    : return "Invalid graphics mode";
    case grError          : return "Graphics error";
    case grIOerror        : return "Graphics I/O error";
    case grInvalidFont    : return "Invalid font file";
    case grInvalidFontNum : return "Invalid font number";
    case grInvalidVersion : return "Invalid File Version Number";
  }
  return "Unknown graphics error";
}
