/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

int __gr_setrgbcolor(int r, int g, int b) {
#ifdef GRX_VERSION
  COL = (int) GrBuildRGBcolorT(r,g,b);
  return COL;
#else
  switch (GrNumColors()) {
    case 1<<15 : return COL =  ((r&0xf8)<<7)
			     | ((g&0xf8)<<2)
			     | ((b&0xf8)>>3);
    case 1<<16 : return COL =   ((r&0xf8)<<8)
			     | ((g&0xfc)<<3)
			     | ((b&0xf8)>>3);
    case 1<<24 : return COL =  ((r&0xff)<<16)
			     | ((g&0xff)<< 8)
			     | ((b&0xff)    );
  }
  ERR = grError;
  return -1;
#endif
}
