/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include <setjmp.h>
#include "bccgrx00.h"

static int lx, ly, mx, my;
static int _border;
static int _color;
static int elements_in_line;
static jmp_buf error;

/* SAFTEY_LEVEL:  0 -> don't check recursion depth
		  1 -> Stop after MAX_RECUR step down's
		  2 -> DEBUG: writes all recursions to stdout */
#define SAFTEY_LEVEL 0

#if SAFTEY_LEVEL>0
  #define MAX_RECUR 2000
  static int chkrecur;
  #define SetupRecurCheck() do chkrecur = 0; while (0)
  #if SAFTEY_LEVEL==2
    #define EnterRecur(txt) do { \
			 ++chkrecur; \
			 printf(txt"(x=%d, y=%d, flg=%d, xl=%d, xr=%d);" \
				" recursion: %d\n", \
				  x,y,flg,xl,xr,chkrecur); \
			 if (chkrecur > MAX_RECUR) { \
			   printf("\nStoping floodfill in line %d\n",__LINE__); \
			   longjmp(error,1); \
			 } \
		       } while(0)
  #else
    #define EnterRecur(txt) do { \
			 if (++chkrecur > MAX_RECUR) \
			   longjmp(error,1); \
		       } while(0)
  #endif
  #define LeaveRecur() do --chkrecur; while(0)
#else
#  define SetupRecurCheck()
#  define EnterRecur(x)
#  define LeaveRecur()
#endif

typedef unsigned char element;
static element **done = NULL;
#define bits_per_element  (sizeof(element)*8)
#define offset_div        (bits_per_element)
#define calc_bit(x)       ( ((element)1) << ((x)&(bits_per_element-1)))
#define calc_high_bits(x) ( (~((element)0)) << ((x)&(bits_per_element-1)))
#define calc_ofs(x)       ((x) / offset_div)

static inline element *generate_line(int y) {
  if (done[y] == NULL)
    if ( (done[y] = calloc(sizeof(element),elements_in_line)) == NULL)
      longjmp(error,1);
  return done[y];
}

static inline void mark_line( int x1, int x2, int y) {
  element *l = generate_line(y);
  element *start, *stop;
  int start_bit, stop_bit;

  start = &l[calc_ofs(x1)];
  stop  = &l[calc_ofs(x2)];
  start_bit = calc_high_bits(x1);
  if (start != stop) {
    *(start++) |= start_bit;
    memset(start,~0,(stop-start)*sizeof(element));
    start_bit = ~0;
  }
  /* start_bit rejects all invalid low bits, let stop_bit discard
     all invalid high bits, but make sure stop_bit won't get zero */
  stop_bit = ~calc_high_bits(x2+1);
  *stop |= (start_bit & (stop_bit ? : ~0));
}

static inline void set_done(int x, int y) {
  element *l = generate_line(y);
  l[calc_ofs(x)] |= calc_bit(x);
}

static inline int test_done(int x, int y) {
  element *l = done[y];
  if (l != NULL)
    return (l[calc_ofs(x)] & calc_bit(x)) != 0;
  return FALSE;
}

static inline int test_screen(int x, int y) {
  return (GrPixelNC(x,y) == _border);
}

static inline int test_pixel(int x, int y) {
  if (test_done(x,y)) return TRUE;
  if (test_screen(x,y)) {
    set_done(x,y);
    return TRUE;
  }
  return FALSE;
}

#define UP   0x01
#define DOWN 0x02

#define NEXT_LINE(fct,test)  do {                       \
  switch (flg) {                                        \
    case UP  : if (y<my) {                              \
		 ++y;                                   \
		 for (xx=sx; xx <= x; ++xx)             \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,UP,sx,x);            \
		 --y;                                   \
	       }                                        \
	       if (y>ly) {                              \
		 --y;                                   \
		 for (xx=sx; xx <= xl; ++xx)            \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,DOWN,sx,x);          \
		 for (xx=xr; xx <= x; ++xx)             \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,DOWN,sx,x);          \
	       }                                        \
	       break;                                   \
    case DOWN: if (y>ly) {                              \
		 --y;                                   \
		 for (xx=sx; xx <= x; ++xx)             \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,DOWN,sx,x);          \
		 ++y;                                   \
	       }                                        \
	       if (y<my) {                              \
		 ++y;                                   \
		 for (xx=sx; xx <= xl; ++xx)            \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,UP,sx,x);            \
		 for (xx=xr; xx <= x; ++xx)             \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,UP,sx,x);            \
	       }                                        \
	       break;                                   \
    default  : if (y>ly) {                              \
		 --y;                                   \
		 for (xx=sx; xx <= x; ++xx)             \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,DOWN,sx,x);          \
		 ++y;                                   \
	       }                                        \
	       if (y<my) {                              \
		 ++y;                                   \
		 for (xx=sx; xx <= x; ++xx)             \
		   if (!test(xx,y))                     \
		     xx = fct(xx,y,UP,sx,x);            \
	       }                                        \
	       break;                                   \
  }                                                     \
} while(0)

static int easy_fill(int x, int y, int flg, int xl, int xr)
{
  int sx, xx;

  EnterRecur("easy_fill");
  sx = x;
  while ( sx > lx && !test_screen(sx-1,y))
    --sx;
  while ( x < mx && !test_screen(x+1,y))
    ++x;
  GrHLine(sx, x, y, _border);
  NEXT_LINE(easy_fill,test_screen);
  LeaveRecur();
  return x;
}

static int solid_fill(int x, int y, int flg, int xl, int xr)
{
  int sx, xx;

  EnterRecur("solid_fill");
  sx = x;
  while ( sx > lx && !test_pixel(sx-1,y))
    --sx;
  while ( x < mx && !test_pixel(x+1,y))
    ++x;
  GrHLine( sx, x, y, _color);
  mark_line(sx, x, y);
  NEXT_LINE(solid_fill,test_pixel);
  LeaveRecur();
  return x;
}

static int pattern_fill(int x, int y, int flg, int xl, int xr)
{
  int sx, xx;

  EnterRecur("pattern_fill");
  sx = x;
  while ( sx > lx && !test_pixel(sx-1,y))
    --sx;
  while ( x < mx && !test_pixel(x+1,y))
    ++x;
  GrPatternFilledLine( sx, y, x, y, &FILLP);
  mark_line(sx, x, y);
  NEXT_LINE(pattern_fill,test_pixel);
  LeaveRecur();
  return x;
}

void floodfill(int x, int y, int border)
{
  int i;

  _DO_INIT_CHECK;

  if (__gr_clip) {
    lx = VL; ly = VT;
    mx = VR; my = VB;
  } else {
    lx = 0; ly = 0;
    mx = getmaxx();
    my = getmaxy();
  }
  x += VL;
  y += VT;
  if ( x < lx || y < ly || x > mx || y > my || GrPixel(x,y) == border)
    return;

  _border = border;
  if (  (  (border == FILL  && FPATT == SOLID_FILL)
	 ||(border == COLBG && FPATT == EMPTY_FILL))
#ifdef __linux__
      && GrAdapterType() != GR_XWIN
#endif
     )
  {
    easy_fill(x,y,0,0,0);
    return;
  }

  done = calloc(sizeof(element *), getmaxy()+1);
  if (done==NULL) {
    ERR = grNoFloodMem;
    return;
  }
  if (setjmp(error) == 0) {
    /* We'll get here once only: no problems with variables x and y ! */
    elements_in_line = calc_ofs(getmaxx() + bits_per_element) + 1;

    SetupRecurCheck();
    if ( FPATT == SOLID_FILL) {
      _color = FILL;
      solid_fill(x,y,0,0,0);
    } else
    if ( FPATT == EMPTY_FILL) {
      _color = COLBG;
      solid_fill(x,y,0,0,0);
    } else {
      FILLP.gp_bmp_fgcolor = FILL;
      FILLP.gp_bmp_bgcolor = COLBG;
      pattern_fill(x,y,0,0,0);
    }
  } else {
    /* generate_line() called longjmp() : out of memory error */
    ERR = grNoFloodMem;
  }
  for (i=getmaxy(); i >= 0; --i)
    if (done[i] != NULL)
      free(done[i]);
  free(done);
}
