/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

void bar3d(int left,int top,int right,int bottom,int depth, int topflag)
{
  int yofs, l_d, r_d, t_y, fast, col;

  _DO_INIT_CHECK;
  __gr_bar(left,top,right,bottom);

  left   += VL;
  top    += VT;
  right  += VL;
  bottom += VT;
  if (left > right) SWAP(left,right);
  if (bottom < top) SWAP(bottom,top);

  fast = (__gr_lstyle == SOLID_LINE) && (LNE.lno_width == 1);
  LNE.lno_color = col = COL|WR;
  if (fast) GrBox( left, top, right, bottom, col);
       else GrCustomBox( left, top, right, bottom, &LNE);

  if (depth == 0) return;

  yofs = -depth * getmaxy() / getmaxx();
  r_d = right+depth;
  t_y = top + yofs;
  if (fast) {
    GrLine( right, bottom, r_d, bottom+yofs, col);
    GrVLine(r_d, bottom+yofs, t_y, col);
  } else {
    GrCustomLine( right, bottom, r_d, bottom+yofs, &LNE);
    GrCustomLine( r_d, bottom+yofs, r_d, t_y, &LNE);
  }
  if (topflag) {
    l_d = left+depth;
    if (fast) {
      GrHLine( r_d, l_d, t_y, col);
      GrLine( l_d, t_y, left, top, col);
      GrLine( r_d, t_y, right, top, col);
    } else {
      GrCustomLine( r_d, t_y, l_d, t_y, &LNE);
      GrCustomLine( l_d, t_y, left, top, &LNE);
      GrCustomLine( r_d, t_y, right, top, &LNE);
    }
  }
}
