/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include "bool.h"
#include <bios.h>
#include <fcntl.h>
#include <sys\types.h>  /* for Microsoft: always sys\types.h before sys\stat.h */
#include <sys\stat.h>
#include <errno.h>



static int diskError;


/* interrupt function pointer */
typedef void interrupt (*fptr)();

fptr oldHandler;


/* For interrupt */
#if defined(__TURBOC__)
# pragma warn -par
# pragma warn -rvl
#endif

int myHandler( int errval, int axp, int bpp, int sip )
{
 _enable();

#if 0
 if ( ax < 0 )   /*  not a disk error  */
    {
     _AX = ax;
     _DI = errval;
     _BP = bp;
     _SI = si;
     oldHandler();
     hardretn( _HARDERR_ABORT );
    }
#endif

 diskError = LOWBYTE( errval );

 hardretn( _HARDERR_FAIL );
}

#if defined(__TURBOC__)
# pragma warn .par
# pragma warn .rvl
#endif


/***
 *
 *  Function   :    test_drive
 *
 *  Topics     :    Test the availability of a drive.
 *
 *  Parameters :    in    int drive         0 = A:, 1 = B:, 2 = C:,...
 *
 *  Return code:    combination (bitwise OR) of
 *                  D_READABLE
 *                  D_WRITEABLE
 *                  D_NOFORMAT
 *                  D_INVALID
 *                  D_NOTINSERTED
 *                  D_REMOVABLE
 *                  D_SUBST
 *                  D_REMOTE
 *                  D_RAM
 *
 *  OS/Compiler :   MS-DOS version >= 3.10
 ***/

int test_drive( int drive )
{
 char fname[] = "x:\\t.t";
 int fhandle, status = 0;

#define INTR 0x24
 /* save the old Fatal Error Interrupt handler */
 oldHandler  = _dos_getvect( INTR );

 /* install new Fatal Error Interrupt handler */
 harderr( myHandler );

 diskError = -1;

 /* Open a file (write) */
 *fname = drive + 'A';
 fhandle = open( fname, O_CREAT, S_IREAD|S_IWRITE );

 /* restore the old Fatal Error Interrupt handler */
 _dos_setvect( INTR, oldHandler );

 if ( fhandle >= 0 )
    {
     close( fhandle );
     unlink( fname );
    }
 else if ( diskError < 0 ) diskError = _doserrno + 256;

 switch( diskError )
 {
  case -1: status |= D_WRITEABLE;

  case EACCES + 256:
  case  0: status |= D_READABLE; break;

  /*case EINVFMT + 256:*/
  case 0x07:
  case 0x0C: status |= D_NOFORMAT; break;

#if 0
  case ENMFILE + 256: /* No more files */
  case EMFILE  + 256: /* Too many open files */
  case ENOENT  + 256: /* No such file or directory*/
  case ENOPATH + 256: /* Path not found           */
#endif
  default: status = D_INVALID;
 }

 {
 union REGS regs;

 /*  Test if drive is remote, subst  */
 regs.h.ah = 0x44;    /* IOCTL function   */
 regs.h.al = 0x09;    /* subfunction  */
 regs.h.bl = drive + 1;
 intdos( &regs, &regs );
 if ( ! regs.x.cflag )
    {
     if ( regs.x.dx & 0x8000 ) status |= D_SUBST;
     if ( regs.x.dx & 0x1000 ) status |= D_REMOTE;
    }

/*  Test if drive is removable  */
 regs.h.ah = 0x44;    /* IOCTL function   */
 regs.h.al = 0x08;    /* subfunction  */
 regs.h.bl = drive + 1;
 intdos( &regs, &regs );
 if ( ! regs.x.cflag )
    if ( regs.x.ax == 0 ) status |= D_REMOVABLE;
 }

/*  Test if drive is a RAM disk  */
 if ( status & D_READABLE )
    {
     union REGS regs;
     struct SREGS sregs;
     unsigned char far *fat_nb;

     regs.h.ah = 0x32;    /* IOCTL function   */
     regs.h.dl = drive + 1;
     intdosx( &regs, &regs, &sregs );
//     if ( regs.h.al ) status |= D_INVALID;
     fat_nb = MK_FP( sregs.ds, regs.x.bx + 8 );
     if ( *fat_nb == 1 )
        status |= D_RAM;
    }

 /* Test if disk inserted */
 if ( (status & D_INVALID) && (status & D_REMOVABLE) )
    {
     status |= D_NOTINSERTED;
     status &= ~D_INVALID;
    }

 return status;
}
