/***
 *  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)
 *
 *  File	: protos.h
 *
 *  Description	: General macros to write a function declaration and 
 *                definition once for both types of system: with and 
 *                without prototypes.
 *
 *  OS/Compiler : All
 *
 *  Usage       : -  With a compiler that does not accept prototypes, 
 *                   the NO_PROTO has to be defined through a -D option 
 *                   to the compiler.
 *
 *                -  macro PROTO is intended to be used for prototyping
 *                   or declaring functions (usually inside header files)
 *                   ex:  
 *                       extern int PROTO( read_data, (char*, int) );
 *
 *                -  macros FUNCDEFx are intended to be used for defining 
 *                   functions (inside body files)
 *                   ex:  
 *                        int FUNCDEF2( read_data, char*, buffer, int, length );
 *
 ***/


#ifndef _PROTOS_H
#define _PROTOS_H

#if ! defined(NO_PROTO)
# define PROTO(fct,args)                       \
  				fct args

# define FUNCDEF0(f)                           \
				f(void)

# define FUNCDEF1(f,t1,a1)                     \
				f(t1 a1)

# define FUNCDEF2(f,t1,a1,t2,a2)               \
				f(t1 a1,t2 a2)

# define FUNCDEF3(f,t1,a1,t2,a2,t3,a3)         \
				f(t1 a1,t2 a2,t3 a3)

# define FUNCDEF4(f,t1,a1,t2,a2,t3,a3,t4,a4)   \
				f(t1 a1,t2 a2,t3 a3,t4 a4)

# define FUNCDEF5(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5)  \
				f(t1 a1,t2 a2,t3 a3,t4 a4,t5 a5)

# define FUNCDEF6(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6)  \
				f(t1 a1,t2 a2,t3 a3,t4 a4,t5 a5,t6 a6)

# define FUNCDEF7(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6,t7,a7)  \
				f(t1 a1,t2 a2,t3 a3,t4 a4,t5 a5,t6 a6,t7 a7)

# define FUNCDEF8(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6,t7,a7,t8,a8)  \
				f(t1 a1,t2 a2,t3 a3,t4 a4,t5 a5,t6 a6,t7 a7,t8 a8)
#else /* NO_PROTO */
# define PROTO(fct,args)                       \
				fct()

# define FUNCDEF0(f)                           \
				f()

# define FUNCDEF1(f,t1,a1)                     \
				f(a1) \
				t1 a1;

# define FUNCDEF2(f,t1,a1,t2,a2)               \
				f(a1,a2) \
				t1 a1;t2 a2;

# define FUNCDEF3(f,t1,a1,t2,a2,t3,a3)         \
				f(a1,a2,a3) \
				t1 a1;t2 a2;t3 a3;

# define FUNCDEF4(f,t1,a1,t2,a2,t3,a3,t4,a4)   \
				f(a1,a2,a3,a4) \
				t1 a1;t2 a2;t3 a3;t4 a4;

# define FUNCDEF5(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5)  \
				f(a1,a2,a3,a4,a5) \
				t1 a1;t2 a2;t3 a3;t4 a4;t5 a5;

# define FUNCDEF6(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6)  \
				f(a1,a2,a3,a4,a5,a6) \
		  		t1 a1;t2 a2;t3 a3;t4 a4;t5 a5;t6 a6;

# define FUNCDEF7(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6,t7,a7)  \
				f(a1,a2,a3,a4,a5,a6,a7) \
				t1 a1;t2 a2;t3 a3;t4 a4;t5 a5;t6 a6;t7 a7;
# define FUNCDEF8(f,t1,a1,t2,a2,t3,a3,t4,a4,t5,a5,t6,a6,t7,a7,t8,a8)  \
				f(a1,a2,a3,a4,a5,a6,a7) \
				t1 a1;t2 a2;t3 a3;t4 a4;t5 a5;t6 a6;t7 a7;t8 a8;
#endif /* NO_PROTO */

#endif /* _PROTOS_H */
