#include "bctools.h"
#include "strings.h"
#include "bool.h"
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>


void M_redraw( Menu *menu, int index )

{ int cursor;

  menu->redraw = 0;

  if ( menu->match ) { window( 1, 1, 80, 25 );
                       gotoxy( menu->x + 2, menu->y + menu->height + 4 );
                       cprintf( "%-*s", menu->width, menu->buffer );
                     }

  window( menu->x, menu->y + 3, menu->x + menu->width + 2, menu->y + menu->height + 2 );

  for ( cursor = 1; (cursor <= menu->height) && (index < menu->items); cursor ++, index ++ )
      {
        gotoxy( 3, cursor );
	cprintf( "%-*s", menu->width, menu->getentry(index) );
      }

  gotoxy( 1, menu->cursor ); cputs( "" );

}



static void M_init( Menu *menu )

{ int i;

  window( 1, 1, 80, 25 );

  if ( menu->width > 77 ) menu->width = 77;
  if ( menu->width < 1 )  menu->width = 1;

  if ( menu->height > 21 ) menu->height = 21;
  if ( menu->height < 1  ) menu->height = 1;

  if ( menu->x + menu->width > 77 ) menu->x = 78 - menu->width;
  if ( menu->y + menu->height > 21 ) menu->y = 22 - menu->height;


		     /***   Draw title   ***/
  border( menu->x, menu->y, menu->x + menu->width + 2, menu->y + 2 );
  gotoxy( menu->x + 1, menu->y + 1 );
  cprintf( "%-*s", menu->width + 1, menu->title );

		     /***   Draw empty border   ***/

  for ( i = menu->y + 3; i < menu->y + menu->height + 3; i ++ )
      {
	gotoxy( menu->x, i );
        cprintf( " %*s", menu->width, " " );
      }
  gotoxy( menu->x, menu->y + menu->height + 3 ); cputs( "" );
  for ( i = menu->width + 1; i; i-- ) cputs( "" );
  cputs( "" );

  if ( menu->match ) { gotoxy( menu->x, menu->y + menu->height + 4 );
                       cprintf( "%-*s", menu->width + 3, " " );
                     }

  M_redraw( menu, menu->index - menu->cursor + 1 );
}


static void M_clrbuf( Menu *menu )

{
  if ( ! menu->match ) return;

  *(menu->buffer) = '\0';
  window( 1, 1, 80, 25 );
  gotoxy( menu->x + 2, menu->y + menu->height + 4 );
  cprintf( "%-*s", menu->width, " " );
  window( menu->x, menu->y + 3, menu->x + menu->width + 2, menu->y + menu->height + 2 );
}


/***
 *
 *   M_get_item
 *
 *   Returns index of choice
 *           -1 if no key hitten
 *           -2 if none selected (ESC pressed)
 *           -3 if none selected (CTRL_C pressed)
 *
 ***/


int M_get_item( Menu *menu )

{ int i, car;
  int scroll = _wscroll;

  _wscroll = 0; _setcursortype(_NOCURSOR);

  if ( ! menu->cursor ) { menu->cursor = 1;
                          if ( (menu->index < 0) || (menu->index >= menu->items) ) menu->index = 0;
                          *(menu->buffer) = '\0';
                          M_init( menu );
                        }

  if ( menu->redraw ) M_init( menu );  /*  Redraw list display  */

  window( menu->x, menu->y + 3, menu->x + menu->width + 2, menu->y + menu->height + 2 );

  if ( menu->items <= menu->height )
     {
       gotoxy( 3, menu->items );
       cputs( menu->getentry(menu->items - 1) );
     }

  while ( kbhit() || menu->wait )
        {
          car = getkey();

          gotoxy( 1, menu->cursor ); cputs( "" );

          switch( car )
	        {
	          case RETURN : gotoxy( 1, menu->cursor ); cputs( "" );
                                window( 1, 1, 80, 25 );
                                if ( menu->match )
                                   {
                                     gotoxy( menu->x + 2, menu->y + menu->height + 4 );
                                     cprintf( "%-*s", menu->width, menu->getentry(menu->index) );
                                   }
                                return menu->index;

	          case ESC    : M_clrbuf( menu );
			        window( 1, 1, 80, 25 );
			        return -2;

	          case CTRL_C : M_clrbuf( menu );
			      	window( 1, 1, 80, 25 );
				return -3;

	          case UP     : if ( ! menu->index ) break;

			        menu->index --;
                                if ( menu->cursor == 1 )
                                   {
                                     insline();
                                     gotoxy( 1, 1 );
                                     cprintf( " %-*s", menu->width, menu->getentry(menu->index) );
                                   }
                                else menu->cursor --;
				M_clrbuf( menu );
				break;

	          case DOWN   : if ( menu->index == menu->items - 1 ) break;

			        menu->index ++;
                                if ( menu->cursor == menu->height )
                                   {
                                     cputs( "\n\r" );
                                     cprintf( " %-*s", menu->width, menu->getentry(menu->index) );
                                   }
                                else menu->cursor ++;
			        M_clrbuf( menu );
			        break;

	          case PGUP   : if ( menu->cursor != 1 ) menu->index -= menu->cursor - 1;
				                    else menu->index -= menu->height;
				if ( menu->index < 0 ) menu->index = 0;
                                menu->cursor = 1;
				M_redraw( menu, menu->index );
				M_clrbuf( menu );
                                break;

	          case PGDN   : menu->index += menu->height + 1 - menu->cursor;
                                menu->cursor = 1;
			        i = min( menu->index, menu->items - menu->height );
                                if ( i < 0 ) i = 0;
			        if ( i < menu->index ) { menu->index = menu->items - 1;
                                                         menu->cursor = min(menu->height, menu->items);
                                                       }
			        M_redraw( menu, i );
			        M_clrbuf( menu );
                                break;

	          case HOME   : if ( menu->index + 1 != menu->cursor ) menu->redraw = TRUE;
                                menu->index = 0; menu->cursor = 1;
			        if ( menu->redraw ) M_redraw( menu, 0 );
			        M_clrbuf( menu );
                                break;

	          case END    : menu->index = menu->items - 1;
			        menu->cursor = min( menu->items, menu->height );
                                M_redraw( menu, menu->items - menu->cursor );
			        M_clrbuf( menu );
                                break;

	       case BACKSPACE : { int buflen = strlen( menu->buffer );

                                  if ( ! buflen ) { beep();
				                    break;
						  }
				  menu->buffer[--buflen] = '\0';
				  menu->index = menu->match( menu->buffer, 0 );
                                  menu->cursor = 1;
				  M_redraw( menu, menu->index );
                                  break;
                                }

	          default : if ( menu->quickshot && (car >= F1) && (car <= F10) )
			       {
			         menu->index = menu->quickshot[(car - F1 + 1) % 10];
                                 menu->cursor = 1;
                                 M_redraw( menu, menu->index );
                                 window( 1, 1, 80, 25 );
                                 if ( menu->match )
                                    {
                                      gotoxy( menu->x + 2, menu->y + menu->height + 4 );
                                      cprintf( "%-*s", menu->width, menu->getentry(menu->index) );
                                    }
                                 return menu->index;
			       }

			    if ( car > 255 || ! menu->match ) { beep(); break; }

			    car = chcase( car, 1 );

                            { int buflen = strlen( menu->buffer );

			      menu->buffer[buflen] = car;
			      menu->buffer[++buflen] = '\0';

			      if ( buflen > 1 ) i = menu->index;
					   else i = 0;

			      if ( (i = menu->match(menu->buffer, i)) == -1 )
			         {
			           menu->buffer[--buflen] = '\0';
			           beep();
			           break;
			         }
                            }

			    menu->index = i;
                            menu->cursor = 1;
			    M_redraw( menu, menu->index );
			    break;
	        }

          gotoxy( 1, menu->cursor ); cputs( "" );

        }

  window( 1, 1, 80, 25 );
  _wscroll = scroll;
  return -1;
}
