;********************w*h*o**r*u*l*e*s**i*t**a*l*l*?*************************
;****                                                                   ****
;****              To assemble write tasm /ml asmdemo3                  ****
;****            C-program is compiled with bcc -c demo3.c              ****
;****            link with bcc -ms demo3.obj asmdemo3.obj               **** 
;****                   ( -ms means model small )                       ****
;****                                                                   ****
;****           To debug with td, build everything with:                ****
;****                   bcc -v demo3.c asmdemo3.asm                     ****
;****                   Then debug with:  td demo3                      ****
;****                                                                   ****
;****                       Albert Veli 96-01-12                        ****
;****                    mail: dat94avi@bilbo.mdh.se                    ****
;****                                                                   ****
;*********************s*m*a*l*l**s*m*a*l*l**s*m*a*l*l*********************** 

        P386N                   ;allow 386 instr. (movsd)
        IDEAL
        MODEL small
        
        DATASEG

        foo     dw      ?       ;foo & bar are temporary variables
        bar     dw      ?       ;they are used if the registers aint enough
        string  db      2000 dup (?)     ;used by outstr

        CODESEG
                                ;functions begins with _ then the name
        PUBLIC  _show32spr      ;call with   show32spr(x,y,sprite,dest);
        PUBLIC  _showtrans      ;   ' '      showtrans(x,y,sprite,dest);
        PUBLIC  _runnyspr       ;   ' '      runnyspr(x,y,sprite,dest);
        PUBLIC  _erase32bit     ;   ' '      erase32bit(x,y,width,height,dest);
        PUBLIC  _getback32      ;   ' '      getback32(x,y,width,height,source,dest);
        PUBLIC  _wtsync         ;   ' '      wtsync();
        PUBLIC  _setmode        ;   ' '      setmode(grafixmode);
        PUBLIC  _blackpal       ;   ' '      blackpal();
        PUBLIC  _setpal         ;   ' '      setpal(palett);
        PUBLIC  _putpixel       ;   ' '      putpixel(x,y,color,dest);
        PUBLIC  _getpixel       ;   ' '      color=getpixel(x,y,dest);
        PUBLIC  _getch          ;   ' '      getch();
        PUBLIC  _kbhit          ;   ' '      kbhit();
        PUBLIC  _loadpalett     ;   ' '      loadpalett("name", pal);
        PUBLIC  _loadsprite     ;   ' '      loadsprite("name", spr);
        PUBLIC  _showpic        ;   ' '      showpic("name",x,y);
        PUBLIC  _flip64k        ;   ' '      flip64k(source,dest);
        PUBLIC  _disflip64k     ;   ' '      disflip64k(source,dest);
        PUBLIC  _disflipblack   ;   ' '      disflipblack(source,dest);
        PUBLIC  _malloc         ;   ' '      virt=malloc(64000);
        PUBLIC  _free           ;   ' '      free(virt);
        PUBLIC  _outstr
        PUBLIC  _screenadr


PROC    _screenadr      NEAR
        xor     ax,ax
        mov     dx,0a000h
        ret
ENDP    _screenadr
        
;outstr prints a string on the screen using dos int 21h function 9
;The string ends with $ or 0 (if 0, it is changed to a $)
;void outstr(char far*str);
PROC    _outstr       NEAR
        ARG     str:Dword
        push    bp
        mov     bp,sp
        push    ds              ;save these registers
        push    si
        push    di
        lds     si,[str]        ;ds:si = str
        mov     di,OFFSET string
        mov     dx,di
        mov     ax,SEG string   ;es:di = string
        mov     es,ax
@@lp:   mov     al,[si]         ;copy str to local array string
        mov     [es:di],al
        cmp     al,0            ;copy until a 0 or a $ sign appears
        jz      @@ch
        cmp     al,'$'
        jz      @@print
        inc     si
        inc     di
        jmp     @@lp
@@ch:   mov     al,'$'          ;if it was 0 replace with $ in string
        mov     [es:di],al
@@print:push    es
        pop     ds              ;ds:dx = beginning of string
        mov     ah,9            ;call dos int 21 func 9, print string
        int     21h
        pop     di              ;restore di, si, ds & bp
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _outstr


;************************************************************************
;* void runnyspr(int x,int y,char far*sprite,char far*dest);            *
;* Register: ax,bx,cx,dx                                                *
;* width on dest must be 320 bytes                                      *
;* shows sprite with a "runny-effect"                                   *
;************************************************************************
PROC    _runnyspr       NEAR
        ARG     xpos:Word, ypos:Word, sprite:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        push    di
        lds     si,[sprite]     ;ds:si = sprite
        les     di,[dest]       ;es:di = destination
        mov     di,[xpos]
        lodsw                   ;height to ax
        mov     [foo],ax        ;height to foo
        cmp     ax,0
        jz      @@error         ;if height 0 draw nothing
        lodsw                   ;width to ax
        mov     cx,ax           ;save width in cx
        mul     [foo]           ;calculate size of sprite
        sub     ax,cx           ;minus one row
        add     si,ax           ;ds:si now points to the last row in sprite

        mov     bx,320          ;bx = pix/screenrow
        sub     bx,cx           ;bx = bytes to next row on the screen
        mov     ax,cx           ;ax = width of sprite
        
        mov     [bar],0FFFFh

;draw the sprite with each row falling from the top of the screen down to 
;it's final position, beginning with the last row
@@Lp1:  mov     di,[xpos]       ;begin at the top of the screen with each row in sprite
        mov     dx,[ypos]       ;dx = top position of sprite
        add     dx,[foo]        ;dx = final y-position of current row
@@Lp2:  dec     [bar]           ;throw in a pause every 32:nd time
        mov     cx,[bar]
        and     cx,31
        jnz     @@Skip          ;skip this row to study the effect in slow motion
        call    _wtsync         ;throw in a pause
@@Skip: mov     cx,ax           ;cx = number of pixels in one row (width)
        rep     movsb           ;draw one row
        sub     si,ax           ;point si back to the beginning of the row (in sprite)
        add     di,bx           ;di := next row on screen
        dec     dx
        jnz     @@Lp2           ;loop until the row reaches it's final 
                                ;position on the screen
        sub     si,ax           ;si = row above the one just drawn in sprite
        dec     [foo]
        jnz     @@Lp1           ;loop through all rows

@@error:
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _runnyspr



;**************************************************************************
;*** int loadpalett(char far*name,char far*pal);                        ***
;*** Destroys: ax,bx,cx,dx   return:1 OK 0:error                        ***
;**************************************************************************
PROC    _loadpalett     NEAR
        ARG     name:Dword, pal:Dword
        push    bp
        mov     bp,sp
        push    ds
        lds     dx,[name]       ;ds:dx points to the filename
        mov     ax,3d00h        ;open for reading only
        int     21h             ;open
        jc      @@errr          ;if error jump to errr
        mov     bx,ax           ;bx=filehandle
        lds     dx,[pal]        ;read to pal
        mov     cx,256*3        ;read the entire palette to pal
        mov     ah,3fh          ;dos read file
        int     21h
        jc      @@errr
        mov     ah,3eh          ;dos close file
        int     21h
        mov     ax,1            ;ax = 1, no error
        jmp     @@exit
@@errr: xor     ax,ax           ;ax = 0 error
@@exit: pop     ds
        pop     bp
        ret
ENDP    _loadpalett
        
;**************************************************************************
;*** int loadsprite(char far*name,char far*spr);                        ***
;*** Destroys: ax,bx,cx,dx   return:1 OK 0:error                        ***
;**************************************************************************
PROC    _loadsprite     NEAR
        ARG     name:Dword, spr:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        lds     dx,[name]       ;ds:dx points to the filename
        mov     ax,3d00h        ;open for reading
        int     21h             ;open
        jc      @@err           ;if error, jump to err
        mov     bx,ax           ;bx=filehandle
        lds     dx,[spr]        ;read to spr
        mov     cx,4            ;read the head of spr
        mov     ah,3fh          ;dos read file
        int     21h
        jc      @@err
        mov     si,dx
        mov     ax,[si]         ;height to ax
        inc     dx
        inc     dx
        mov     si,dx
        mov     cx,[si]
        xchg    ax,cx
        mul     cl              ;ax=height*width
        mov     cx,ax
        mov     ax,3f00h        ;dos readfile
        inc     dx
        inc     dx
        int     21h
        jc      @@err
        mov     ah,3eh          ;dos close file
        int     21h
        mov     ax,1            ;ax = 1, no error
        jmp     @@exit
@@err:  xor     ax,ax           ;ax = 0 error
@@exit: pop     si
        pop     ds
        pop     bp
        ret
ENDP    _loadsprite


;**************************************************************************
;*** void showpic( int x,int y, char far*name, char far*dest);          ***
;*** Destroys: ax,bx,cx,dx   return:1 OK 0:error                        ***
;*** Shows a pic from file on dest (screen or virt)                     ***
;*** !CAUTION width of dest is assumed to be 320 bytes CAUTION!         ***
;**************************************************************************
PROC    _showpic     NEAR
        ARG     xpos:Word, ypos:Word, name:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        push    di
        les     di,[dest]
        mov     bx,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     bx,ax           ;bx=256*y+x
        shr     ax,2            ;ax=64*y
        add     bx,ax           ;bx=320*y+x     offset to di
        add     di,bx           ;es:di = destination (screen or virt)
        lds     dx,[name]       ;ds:dx point to filename
        mov     ax,3d00h        ;open for reading
        int     21h             ;open
        jc      @@err           ;if error, jump to err
        mov     bx,ax           ;bx=filehandle
        mov     ax,es
        mov     ds,ax           ;ds=segment of destination
        mov     dx,di           ;read to destination
        mov     cx,4            ;read the head of pic
        mov     ah,3fh          ;dos read file
        int     21h
        jc      @@err
        mov     si,dx
        mov     ax,[si]         ;height to ax
        inc     dx
        inc     dx
        mov     si,dx
        mov     cx,[si]         ;width to cx
@@lop:  shl     eax,16          ;save height in high word of eax
        mov     ax,3f00h        ;dos readfile
        mov     dx,di
        int     21h
        jc      @@err
        add     di,320
        shr     eax,16          ;shift height back to ax
        dec     ax
        jnz     @@lop
        mov     ah,3eh          ;dos close file
        int     21h
        mov     ax,1            ;ax = 1, no error
        jmp     @@exit
@@err:  xor     ax,ax           ;ax = 0 error
@@exit: pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _showpic


;************************************************************************
;* void putpixel(int x, int y,char color,char far*dest);                *
;* Register: ax                                                         *
;************************************************************************
PROC    _putpixel     NEAR
        ARG xpos:Word, ypos:Word, color:Byte, dest:Dword
        push    bp
        mov     bp,sp
        push    di
        les     di,[dest]
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di
        mov     al,[color]
        mov     [es:di],al
        pop     di
        pop     bp
        ret
ENDP    _putpixel


;************************************************************************
;*** char getpixel(int x, int y,char far*src);                       ***
;*** Register: ax         return:color                                ***
;************************************************************************
PROC    _getpixel     NEAR
        ARG xpos:Word, ypos:Word ,src:Dword
        push    bp
        mov     bp,sp
        push    di
        les     di,[src]
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di
        mov     al,[es:di]      ;color to al
        pop     di
        pop     bp
        ret
ENDP    _getpixel


;************************************************************************
;* void show32spr( int xpos, int ypos, char far*sprite, char far*dest); *
;* Register: ax,bx,cx,dx                                                *
;* width of dest must be 320 bytes                                      *
;* draws sprite at dest at (xpos,ypos)                                  *
;************************************************************************
PROC    _show32spr     NEAR
        
        ARG xpos:Word, ypos:Word, sprite:Dword, dest:Dword
        
        push    bp
        mov     bp,sp
        push    ds    
        push    si
        push    di
        lds     si,[sprite]     ;ds:si = sprite
        les     di,[dest]       ;es:di = destination
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di

;get the proportions from the head
        lodsw                   ;height to ax
        mov     dx,ax           ;height to dx
        or      ax,ax
        jz      @@endspr        ;if height 0 draw nothing
        lodsw                   ;width to ax
        mov     bx,320          ;bx = pix/row
        sub     bx,ax           ;bx = incr (# of bytes to next row)
        shr     ax,2            ;ax = width/4

;draw the sprite
@@Loop32:
        mov     cx,ax           ;# of Dword per row to cx
        rep     movsd           ;move one spriterow from ds:si to es:di
        add     di,bx           ;di:=next row
        dec     dx
        jnz     @@Loop32        ;loopa through all rows
@@endspr:
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _show32spr

;************************************************************************
;* void showtrans(int xpos, int ypos, char far*sprite, char far*dest);  *
;* Register: ax,bx,cx,dx                                                *
;* width on dest must be 320 bytes                                      *
;* shows sprite with color 0 transparent, slower than show32spr         *
;************************************************************************
PROC    _showtrans      NEAR
        ARG     xpos:Word, ypos:Word, sprite:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds    
        push    si
        push    di
        lds     si,[sprite]     ;ds:si = sprite
        les     di,[dest]       ;es:di = destination
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di
        lodsw                   ;height to ax
        mov     dx,ax           ;height to dx
        or      ax,ax
        jz      @@error         ;if height 0 draw nothing
        lodsw                   ;width to ax
        mov     bx,320          ;bx = pix/screenrow
        sub     bx,ax           ;bx = incr (bytes to next row)
        shl     eax,16          ;save width in high word of eax
;draw sprite
@@Lp1:  shr     eax,16          ;width => ax
        mov     cx,ax           ;bytes/row => cx
        shl     eax,16          ;save in high word
@@Lp2:  mov     al,[ds:si]      ;load one byte
        or      al,al
        jz      @@itsz          ;if 0 jump to itsz
        mov     [es:di],al      ;if not 0 draw it
@@itsz: inc     di
        inc     si
        loop    @@Lp2           ;to next pixel
        
        add     di,bx           ;di:=next row
        dec     dx
        jnz     @@Lp1           ;loop through all rows
@@error:
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _showtrans


;************************************************************************
;* void erase32bit(int x, int y, int width, int height,char far*dest);  *
;* Register: eax, ebx, cx, dx,                                          *
;* erases (draws color 0) on a rectangle in dest                        *
;************************************************************************
PROC    _erase32bit     NEAR
        
        ARG xpos:Word, ypos:Word, width:Word, height:Word, dest:Dword
        
        push    bp
        mov     bp,sp
        push    di
        les     di,[dest]
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x 
        mov     ax,[width]
        mov     dx,[height]
        mov     bx,320
        sub     bx,ax
        shr     ax,2
        shl     ebx,16
        mov     bx,ax           ;ebx=offset to next row, width in Dword
        xor     eax,eax         ;eax = 0
@@sudda:
        mov     cx,bx           ;Dword/row to cx
        rep     stosd           ;erase one row at es:di
        ror     ebx,16          ;rotate offset to bx
        add     di,bx           ;di = next row
        rol     ebx,16          ;rotate back to high word
        dec     dx
        jnz     @@sudda         ;loopa through all rows
        pop     di
        pop     bp
        ret
ENDP    _erase32bit

;************************************************************************
;* void getback32(int xpos, int ypos, int width, int height,            *
;* char far*source, char far*spr);                                      *
;* Register: ax, bx, cx, dx,                                            *
;************************************************************************
; make a sprite out of source at x,y with width width and height height
PROC    _getback32      NEAR
        ARG     xpos:Word, ypos:Word, width:Word, height:Word, source:Dword, sprite:Dword
        push    bp
        mov     bp,sp
        push    di
        push    si
        push    ds
        lds     si,[source]     ;ds:si => source
        les     di,[sprite]     ;es:di => sprite
        mov     si,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           
        add     si,ax           
        shr     ax,2            
        add     si,ax           ;si=320*y+x
        mov     ax,[height]     ;save height and width
        stosw                   ;first height
        mov     dx,ax           ;dx height counter
        mov     ax,[width]
        stosw                   ;then width
        mov     bx,320
        sub     bx,ax           ;bx=bytes to next row
        shr     ax,2            ;ax = width/4
@@loop: mov     cx,ax           ;number of Dwords to cx per row
        rep     movsd           ;move one row to sprite
        add     si,bx           ;next row
        dec     dx              ;was it the last?
        jnz     @@loop          ;not, one more
        pop     ds
        pop     si
        pop     di
        pop     bp
        ret
ENDP    _getback32

;****************************************
;* void wtsync(void);     Reg: inga     *
;* waits for vertical retrace           *
;****************************************
PROC    _wtsync NEAR
        push    ax
        push    dx
        mov     dx,3DAh
@@wt1:  in      al,dx
        test    al,8
        jne     @@wt1
@@wt2:  in      al,dx
        test    al,8
        je      @@wt2
        pop     dx
        pop     ax
        ret
ENDP    _wtsync

;**************************************************
;*** void blackpal(void)   REG: al, cx, dx      ***
;*** sets all colors to black                   ***
;**************************************************
PROC    _blackpal        NEAR        
        xor     al,al
        mov     dx,3c8h
        out     dx,al
        inc     dx
        mov     cx,256*3
@@lp:   out     dx,al
        loop    @@lp
        ret
ENDP    _blackpal

;************************************************************
;*** void setpal(unsigned char far*pal) REG: none       *****
;*** sets the active palette to pal                     *****
;************************************************************
PROC    _setpal  NEAR
        ARG     pal:Dword
        push    bp
        mov     bp,sp
        push    ax
        push    cx
        push    dx
        push    ds
        push    si
        lds     si,[pal]
        xor     al,al
        mov     dx,3c8h
        out     dx,al
        inc     dx
        mov     cx,256*3
        rep     outsb
        pop     si
        pop     ds
        pop     dx
        pop     cx
        pop     ax
        pop     bp
        ret
ENDP    _setpal

;**************************************************************************
;*** char getch(void) Reg:ax                                            ***
;*** waits for keypress, returns the ascii-code of the pressed char     ***
;**************************************************************************
PROC    _getch  NEAR
        mov     ah,0            ;stops prog & waits for keypress
        int     16h             ;ascii-code in al, scan-code in ah
        ret
ENDP    _getch


;*** char kbhit(void) Reg:ax ***
;checks for keypress, no? return 0
;if keypress return the ascii-code of the pressed key
PROC    _kbhit  NEAR
        mov     ah,1
        int     16h
        jnz     @@99            ;if kb is hit jump
        xor     ax,ax           ;else return 0
        jmp     @@88
@@99:   mov     ah,0
        int     16h             ;remove keypress from keyboredbuffer
@@88:   ret
ENDP    _kbhit


;*** void setmode(int mode) ***
PROC    _setmode  NEAR
        ARG     mode:Word
        push    bp
        mov     bp,sp
        mov     ax,[mode]
        int     10h
        pop     bp
        ret
ENDP    _setmode


;***   void flip64k(char far*source, char far*dest)     ***
;***   register: cx                                     ***
;copies 64000 bytes from source to dest
PROC    _flip64k  NEAR
        ARG     source:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        push    di
        lds     si,[source]
        les     di,[dest]
        mov     cx,16000        ;64000/4
        rep     movsd
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _flip64k

;***   void disflip64k(char far*source, char far*dest)  ***
;***   register: cx,al,dx                               ***
;Makes a dissolveflip from source to dist
;Change the speed of the flip by changing the constant 900 (2 places)
PROC    _disflip64k  NEAR
        ARG     source:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        push    di
        lds     si,[source]
        les     di,[dest]
        mov     cx,0ffffh
        mov     di,1
        mov     dx,900
@@dis1: mov     al,[ds:di]      ;move 1 point from ds:di to es:di
        mov     [es:di],al
        shr     di,1
        jnc     @@noc           ;di is calculated with an algorithm from
        xor     di,0b400h       ;Graphic Gems I (Digital Dissolve effect)
@@noc:  dec     dx
        jnz     @@ndel
        mov     dx,900          ;every 900:th pixel make a delay by
        call    _wtsync         ;calling wtsync
@@ndel: loop    @@dis1          
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _disflip64k


;***   void disflipblack(char far*source, char far*dest)  ***
;***   register: cx,al,dx                                 ***
;Makes a dissolveflip from source to black areas of dist  ***
;Change the speed of the flip by changing the constant 900 (2 places)
PROC    _disflipblack   NEAR
        ARG     source:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        push    di
        lds     si,[source]
        les     di,[dest]
        mov     cx,0ffffh
        mov     di,1
        mov     dx,900
@@dis1: mov     al,[es:di]      ;investigate the point that shall be flipped
        cmp     al,0            ;if the screen is not black there
        jnz     @@skip          ;skip it (don't draw the point)
        mov     al,[ds:di]      ;move 1 point from ds:di to es:di
        mov     [es:di],al
@@skip: shr     di,1
        jnc     @@noc           ;di is calculated with an algorithm from
        xor     di,0b400h       ;Graphic Gems I (Digital Dissolve effect)
@@noc:  dec     dx
        jnz     @@ndel
        mov     dx,900          ;every 900:th pixel make a delay by
        call    _wtsync         ;calling wtsync
@@ndel: loop    @@dis1          
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _disflipblack


;*** char far* malloc(unsigned int bytes) ***
;allocates bytes bytes, returnes far char pointer to memoryblock
;ex:    char far* virt;
;       virt=malloc(64000);
;if out of memory, return 0
PROC    _malloc  NEAR
        ARG     bytes:Word
        push    bp
        mov     bp,sp
        mov     bx,[bytes]
        shr     bx,4
        inc     bx
        mov     ah,48h          ;funk 48 allocates ah number of paragraphs
        int     21h             ;1 paragraph = 16 bytes, segment in ax
        mov     dx,ax           ;move the segment to dx
        jnc     @@nerr          ;if no carry, no error
        xor     dx,dx           ;an error occured . . .
@@nerr: xor     ax,ax           ;offset always 0
        pop     bp
        ret
ENDP    _malloc


;*** int free(char far* block) ***
;frees memory allocated with malloc (routine above)
;send the pointer as parameter ex: free(virt);
PROC    _free  NEAR
        ARG     block:Dword
        push    bp
        mov     bp,sp
        les     ax,[block]
        mov     ah,49h
        int     21h
        jnc     @@nerr
        xor     ax,ax           ;an error occured . . .
@@nerr: pop     bp
        ret
ENDP    _free

        END                     ;Just END no label
