/**********************************************/
/* Sourcecode for part IV in Abe's Demoschool */
/*                                            */
/* 3D rotation with sprites & morfing         */
/* on the base objects.                       */
/* Try stopping the rotation with Return      */
/* And check the morph with keys 1,2,3        */
/*                                            */
/* 1996-02-07 Sir Abe                         */
/* mail: dat94avi@bilbo.mdh.se                */
/* s-mail: Albert Veli                        */
/*         Spisringsg. 9                      */
/*         724 76 Vsters                    */
/*         SWEDEN                             */
/**********************************************/

#include "demo4.h"      /* contains all extern declarations */

#define NO_OF_PTS 9    /* 9 points in each object */
#define NO_OF_OBJ 3     /* 3 different base objects to morph between */
#define SIZE 10

/* GLOBAL VARIABLES AND ARRAYS */
int bx[NO_OF_PTS]; /* the morphed base object will be copied here */
int by[NO_OF_PTS]; /* in the beginning of the main loop */
int bz[NO_OF_PTS];

int rx[NO_OF_PTS],ry[NO_OF_PTS],rz[NO_OF_PTS]; /* these arrays will be used */
int sx[NO_OF_PTS],sy[NO_OF_PTS];               /* by rotatepoints */
int addx=0,addy=0,addz=0;             /* these variables moves the object */

/* printbutt print's some text on the screen using outstr, which uses */
/* int 21 funtion 9 to print. The string must end with a 0 or a $ */
/* C automatically puts a 0 at the end of a "text" inside " " signs */
/* \n\r means new line and go back to the beginning of row */
/* \ at the end of the rows means that the string continues on the next row */
/* just make sure text is big enough to contain the all the text */
void printbutt(void)
{
char text[1000]="\n\r\
3D-rotation with morphing between the 3 base objects\n\r\n\r\
Controls:\n\r\n\r\
Morph to: object 1      object 2      object 3\n\r\
       Ŀ\n\r\
Button:     1             2             3      \n\r\
       \n\r\n\r\
Axis:   x-rotation     y-rotation     z-rotation\n\r\
Action: dec    inc     dec    inc     dec    inc\n\r\
       Ŀ\n\r\
Button: Z      X       C      V       B      N \n\r\
       \n\r\n\r\
Move:   left  right    up    down     out    in\n\r\
       Ŀ\n\r\
Button: Q      W       E      R       T      Y \n\r\
       \n\r\n\r\
Stop rotation: Return\n\r\
Exit: Escape\n\r\n\r\n\r\
Press a button to continue. . .";
outstr(text);   /* print the string text, defined above */
getch();        /* wait for a keypress */
}

void printerr(void) /* prints an error text if there isn't enough memory */
{
char text[200]="\n\r\n\r\
Couldn't allocate enough memory for the virtual screen :-(\n\r\
Reboot your computer and try again\n\r";
outstr(text);
}

void printabe(void)
{
char text[300]="\
            \n\r\
      \n\r\
             \n\r\
     \n\r\
     \n\r\
         \n\r\
      \n\r\
            \n\r\
	Ŀ    \n\r\
	 Ŀ    \n\r\
Wishes: ood uck\n\r";
outstr(text);
}

void main(void)
{
int i;
int per;
unsigned char ax,ay,az,incx,incy,incz,pal[256*3];
char far*scr;
char far*virt;
char sprite[4+20*20],ch;
int width,height,curr_obj;

/* Base coordinats of the objects */
/* change these to something cool */
/* right now it's the letters A, b and E (if you didn't notice that) */
int xt[NO_OF_OBJ][NO_OF_PTS]={{0,-4,4,-8,-3,3,8,-8,8},{-2,-2,-2,-2,-2,0,2,2,0},{3,-1,-4,-3,-2,-3,-4,-1,3}};
int yt[NO_OF_OBJ][NO_OF_PTS]={{-4,-2,-2,1,1,1,1,5,5},{-5,-3,-1,1,3,3,2,0,-1},{-6,-5,-4,-2,0,2,4,5,6}};
int zt[NO_OF_OBJ][NO_OF_PTS]={0};

float mx[NO_OF_PTS],my[NO_OF_PTS],mz[NO_OF_PTS]; /* the morphed coordinates */

virt=malloc(64000);     /* this is exactly like in part III, remember? */
if(virt!=0)
{
printbutt();            /* print the instructions on the screen */
scr=screenadr();        /* screenadr returns 0a000:0000, it's in graph.asm */
incx=1;      /* incx,incy,incz is the rotation speed in each direction */
incy=0;      /* it can be changed with keys z to n on the keyboard */
incz=0;
ax=0;        /* ax,ay,az are the angles the cube will be rotated with */
ay=0;
az=0;

setmode(0x0013);
flip64k(scr,virt);              /* clear virt */
loadsprite("blueb.spr",sprite); /* sprite stuff, similar to part III */
width=sprite[2]+sprite[3]*256;
height=sprite[0]+sprite[1]*256;
loadpalett("blueb.pal",pal);
setpal(pal);

curr_obj=0;     /* start with the first object */
for (i=0;i<NO_OF_PTS;i++)
{
xt[0][i]=xt[0][i]*SIZE*0.6; /* increase the size of the base objects */
xt[1][i]=xt[1][i]*SIZE*1.6;/* you could insert the final size into xt,yt,yz */
xt[2][i]=xt[2][i]*SIZE;   /* in the beginning and skip these lines */
yt[0][i]=yt[0][i]*SIZE;   /* but now it's easier to change the size */
yt[1][i]=yt[1][i]*SIZE*1.3;  /* just change the #define SIZE */
yt[2][i]=yt[2][i]*SIZE;
//zt[0][i]=zt[0][i]*SIZE;
//zt[1][i]=zt[1][i]*SIZE;
//zt[2][i]=zt[2][i]*SIZE;
mx[i]=0; /* initialize mx,my & mz */
my[i]=0;
mz[i]=0;
sx[i]=0; /* initialize sx,sy */
sy[i]=0;
}

runnyspr(160,100,sprite,scr); /* the runny effect from part III */


/* THE MAIN LOOP */
do{
	/* morph away */
	for(i=0;i<NO_OF_PTS;i++)
	{
	mx[i]+=((xt[curr_obj][i]-mx[i])*0.05); /* add distance/20 */
	my[i]+=((yt[curr_obj][i]-my[i])*0.05);
	mz[i]+=((zt[curr_obj][i]-mz[i])*0.05);
	bx[i]=mx[i];
	by[i]=my[i];
	bz[i]=mz[i];
	}

	/* erase the old sprites */
	for(i=0;i<NO_OF_PTS;i++) erase32bit(sx[i],sy[i],width,height,virt);
	RotatePoints(ax,ay,az,NO_OF_PTS); /* rotate, calculate new coordinates */

	qsort3d(0,NO_OF_PTS - 1);           /* sort sx,sy with respect to rz */

	/* draw the sprites to virt in back to front order (painters algorithm) */
	for(i=NO_OF_PTS-1;i>=0;i--) showtrans(sx[i],sy[i],sprite,virt);

	/* wait for the electron beam */
	wtsync(); /* (skip this row if you have a slower computer than 486 50Mhz) */
	flip64k(virt,scr); /* and flip virt over to the visible screen */

	ax+=incx;               /* change the angles */
	ay+=incy;
	az+=incz;

ch=kbhit();     /* check for keypress */
if(ch!=0)       /* if there's been a keypress */
{
switch(ch)      /* Check which key has been pressed and interact */
{
	case 'z':       /* z and Z decreases the x-rotation speed */
	case 'Z': incx--;
	break;
	case 'x': /* x and X increases the x-rotation speed */
	case 'X': incx++;
	break;
	case 'c': /* c and C decreases the y-rotation speed */
	case 'C': incy--;
	break;
	case 'v': /* v and V increases the y-rotation speed */
	case 'V': incy++;
	break;
	case 'b': /* b and B decreases the z-rotation speed */
	case 'B': incz--;
	break;
	case 'n': /* n and N increases the z-rotation speed */
	case 'N': incz++;
	break;
	case '\r': incx=0;incy=0;incz=0;ax=0;ay=0;az=0; /* return stops rotation */
	break;
	case 'q': /* q and Q, decrease x-position of all points */
	case 'Q': addx--;
	break;
	case 'w': /* w and W, increase x-position of all points */
	case 'W': addx++;
	break;
	case 'e': /* e, r change y-position */
	case 'E': addy--;
	break;
	case 'r':
	case 'R': addy++;
	break;
	case 't': /* t and T decreases addz, makes the object come closer */
	case 'T': if(addz>0) addz-=5;
	break;
	case 'y': /* y and Y increases addz, makes the object go away, get smaller*/
	case 'Y': addz+=5;
	break;
	case '1': curr_obj=0;
	break;
	case '2': curr_obj=1;
	break;
	case '3': curr_obj=2;
	break;
}
}
}while(ch!='\x1b');
free(virt);
}
else printerr();   /* if there wasn't enough memory, print the error text */
setmode(3);        /* get back into textmode */
printabe();        /* print a little message */
}
