/**********************************************/
/* Sourcecode for part IV in Abe's Demoschool */
/*                                            */
/* 3D rotation with sprites                   */
/*                                            */
/* 1996-02-07 Sir Abe                         */
/* mail: dat94avi@bilbo.mdh.se                */
/* s-mail: Albert Veli                        */
/*         Spisringsg. 9                      */
/*         724 76 Vsters                    */
/*         SWEDEN                             */
/**********************************************/

#include "demo4.h"      /* contains all extern declarations */

#define NO_OF_PTS 8     /* 8 points, the corners of the cube */
#define SZ 40           /* change SZ to change the size of the cube */

/* GLOBAL VARIABLES AND ARRAYS */
int bx[NO_OF_PTS]={-SZ,SZ,SZ,-SZ,-SZ,SZ,SZ,-SZ};  /* The base object */
int by[NO_OF_PTS]={SZ,SZ,-SZ,-SZ,SZ,SZ,-SZ,-SZ};  /* Now It's a cube */
int bz[NO_OF_PTS]={SZ,SZ,SZ,SZ,-SZ,-SZ,-SZ,-SZ};  /* but it's easy to change */

int rx[NO_OF_PTS],ry[NO_OF_PTS],rz[NO_OF_PTS]; /* these arrays will be used */
int sx[NO_OF_PTS],sy[NO_OF_PTS];               /* by rotatepoints */
int addx=0,addy=0,addz=0;             /* these variables moves the object */

 
/* printbutt print's some text on the screen using outstr, which uses */
/* int 21 funtion 9 to print. The string must end with a 0 or a $ */
/* C automatically puts a 0 at the end of a "text" inside " " signs */
/* \n\r means new line and go back to the beginning of row */
/* \ at the end of the rows means that the string continues on the next row */
/* just make sure text is big enough to contain the all the text */
void printbutt(void)
{
char text[1000]="\n\r\
Basic 3d-rotation, 8 sprites on the corners of a rotating cube\n\r\n\r\
Controls:\n\r\n\r\
Axis:   x-rotation     y-rotation     z-rotation\n\r\
Action: dec    inc     dec    inc     dec    inc\n\r\
       Ŀ\n\r\
Button: Z      X       C      V       B      N \n\r\
       \n\r\n\r\
Move:   left  right    up    down     out    in\n\r\
       Ŀ\n\r\
Button: Q      W       E      R       T      Y \n\r\
       \n\r\n\r\
Stop rotation: Return\n\r\
Exit: Escape\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\
Press a button to continue. . .";
outstr(text);   /* print the string text, defined above */
getch();        /* wait for a keypress */
}
 
void printerr(void) /* prints an error text if there isn't enough memory */
{
char text[200]="\n\r\n\r\
Couldn't allocate enough memory for the virtual screen :-(\n\r\
Reboot your computer and try again\n\r";
outstr(text);
}

void printabe(void)
{
char text[300]="\
            \n\r\
      \n\r\
             \n\r\
     \n\r\
     \n\r\
         \n\r\
      \n\r\
            \n\r\
	Ŀ    \n\r\
	 Ŀ    \n\r\
Wishes: ood uck\n\r";
outstr(text);
}

void main(void)
{
int i;
int per;
unsigned char ax,ay,az,incx,incy,incz,pal[256*3];
char far*scr;
char far*virt;
char sprite[4+20*20],ch;
int width,height;

virt=malloc(64000);     /* this is exactly like in part III, remember? */
if(virt!=0)
{
printbutt();            /* print the instructions on the screen */
scr=screenadr();        /* screenadr returns 0a000:0000, it's in graph.asm */
incx=1;         /* incx,incy,incz is the rotation speed in each direction */
incy=-1;        /* it can be changed with keys z to n on the keyboard */
incz=0;
ax=0;           /* ax,ay,az are the angles the cube will be rotated with */
ay=0;
az=0;

setmode(0x0013);
flip64k(scr,virt);              /* clear virt */
loadsprite("blueb.spr",sprite); /* sprite stuff, similar to part III */
width=sprite[2]+sprite[3]*256;
height=sprite[0]+sprite[1]*256;
loadpalett("blueb.pal",pal);
setpal(pal);

RotatePoints(0,0,0,NO_OF_PTS);/* rotate the object so sx,sy get's initialized */
for(i=4;i<8;i++) runnyspr(sx[i],sy[i],sprite,scr); /* the runny effect from part III */


/* THE MAIN LOOP */
do{
	/* first erase the old sprites */
	for(i=0;i<NO_OF_PTS;i++) erase32bit(sx[i],sy[i],width,height,virt);

	RotatePoints(ax,ay,az,NO_OF_PTS); /* rotate, calculate new coordinates */

	qsort3d(0,NO_OF_PTS - 1); /* sort sx,sy with respect to rz */

	/* draw the sprites to virt in back to front order (painters algorithm) */
	for(i=NO_OF_PTS-1;i>=0;i--) showtrans(sx[i],sy[i],sprite,virt);
	wtsync();               /* wait for the electron beam, (skip this row if it's slow) */
	flip64k(virt,scr); /* and flip virt over to the visible screen */

	ax+=incx; /* change the angles */
	ay+=incy;
	az+=incz;

ch=kbhit();     /* check for keypress */
if(ch!=0)       /* if there's been a keypress */
{
switch(ch)      /* Check which key has been pressed and interact */
{
	case 'z':    /* z and Z decreases the x-rotation speed */
	case 'Z': incx--;
	break;
	case 'x': /* x and X increases the x-rotation speed */
	case 'X': incx++;
	break;
	case 'c': /* c and C decreases the y-rotation speed */
	case 'C': incy--;
	break;
	case 'v': /* v and V increases the y-rotation speed */
	case 'V': incy++;
	break;
	case 'b': /* b and B decreases the z-rotation speed */
	case 'B': incz--;
	break;
	case 'n': /* n and N increases the z-rotation speed */
	case 'N': incz++;
	break;
	case '\r': incx=0;incy=0;incz=0;ax=0;ay=0;az=0; /* return stops rotation */
	break;
	case 'q': /* q, Q, w & W changes the x-position of the object */
	case 'Q': addx--;
	break;
	case 'w':
	case 'W': addx++;
	break;
	case 'e': /* e, E, r & R changes the y-position of the object */
	case 'E': addy--;
	break;
	case 'r':
	case 'R': addy++;
	break;
	case 't': /* t and T decreases addz, makes the object come closer */
	case 'T': if(addz>0) addz-=5;
	break;
	case 'y': /* y and Y increases addz, makes the object go away, get smaller*/
	case 'Y': addz+=5;
	break;
}
}
}while(ch!='\x1b');
free(virt);
}
else printerr();   /* if there wasn't enough memory, print the error text */
setmode(3);        /* get back into textmode */
printabe();        /* print a little message */
}

/***************************************************************/                          
/* This is an attempt to make this file 6 666 bytes muahaha    */                        
/***************************************************************/             
