/************************************************************************/
/*                                                                      */
/*       C-file to part 3 of Abe's Demoschool, picture & sprite         */
/*                                                                      */
/* The program allocates a virtual screen, then a picture  is read from */
/* disk to the virtual screen. The picture is flipped over to the       */
/* visible screen using a dissolve effekt.                              */
/*                                                                      */
/* All drawing is made to the virtual screen, when the drawing is       */
/* finished the virtual screen is flipped to the                        */
/* visible screen and appears.                                          */
/*                                                                      */
/*      The main loop does the following:                               */
/*                                                                      */
/* 1    save the background where the sprite will be drawn              */
/*                                                                      */
/* 2    Draw the sprite with color 0 transparent                        */
/*                                                                      */
/* 3    Waits for the vertical retrace and flips the virtual screen     */
/*      over to the visible screen                                      */ 
/*                                                                      */
/* 4    Checks if the sprite has hit a wall and calculates new          */
/*      coordinates (X & Y Values)                                      */
/*                                                                      */
/* 5    If no button has been pressed, jump to one                      */
/*                                                                      */
/*      1996-01-17                                                      */
/*      Sir Abe                                                         */
/*      electronic mail:        dat94avi@bilbo.mdh.se                   */
/*      snail mail:             Albert Veli                             */
/*                              Spisringsg. 9                           */
/*                              724 76 Vsters                         */
/*                                                                      */                                
/************************************************************************/


/* char far* means an array that can be outside of the current segment  */
/* the program includes no libraries like stdio.h or stdlib.h           */
/* they only make the .exe unnecessary big                              */
/* the code for these functions is in asmdemo3.asm                      */
/* You could keep these extern-declarations in a separate .h file       */
/* I don't because It's enough files already in this part of the demoschool */
extern int loadpalett(char far*name,char far*pal);
extern int loadsprite(char far*name,char far*sprite);
extern int showpic(int x,int y,char far*name,char far*dest);
extern void show32spr(int x,int y,char far*sprite,char far*dest);
extern void showtrans(int x,int y,char far*sprite,char far*dest);
extern void runnyspr(int x,int y,char far*sprite,char far*dest);
extern void erase32bit(int x, int y, int width, int height, char far*dest);
extern void getback32(int x,int y,int width,int height,char far*source,char far*dest);
extern char getch(void);
extern void setmode(int mode);
extern void setpal(char far*pal);
extern void flip64k(char far*source, char far*dest);
extern void disflip64k(char far*source, char far*dest);
extern void disflipblack(char far*source, char far*dest);
extern char far*malloc(unsigned int nr_of_bytes);
extern int free(char far*memoryblock);
extern void wtsync(void);
extern char kbhit(void);


void main(void)
{
char far*virt;
char far*screen;
char pal[3*256],sprite[2+64*64],back[2+64*64];
int x,y,dx,dy,width,height;

screen=0x0a0000000;             //this gives a warning but it works (on my compiler :-))

x=120;                          /* startcoordinates for the sprite */
y=80;
dx=2;dy=1;                      /* dx & dy = the velocity of the sprite */


virt=malloc(64000);             //allocate 64000 bytes for a virtual screen
if(virt!=0)                     //if it worked, go on
{
	erase32bit(0,0,320,200,virt);   /* clear virt */
	showpic(0,0,"evildead.pic",virt);    /* show a picture on virt */
	setmode(0x0013);                /* enter mode 13h */
	loadpalett("palett.col",pal);   /* load the palette */
	setpal(pal);                    /* set the palette */
	loadsprite("ball.spr",sprite);  /* load the sprite */
	height=sprite[0] + sprite[1]*256; /* get the dimensions of the sprite */
	width=sprite[2] + sprite[3]*256;

	runnyspr(x,y,sprite,screen);    /* show the sprite with a runny effect */
	disflipblack(virt,screen);      /* draw the picture with a dissolve effect */
	/* the first time (only flips to the black parts of the screen) */
	do
	{

		getback32(x,y,width,height,virt,back); /* save the background */
		showtrans(x,y,sprite,virt);     /* show the sprite with color 0 transparent */

		wtsync();                       /* wait for vertical retrace */
		flip64k(virt,screen);           /* flip virt to screen */

		show32spr(x,y,back,virt);       /* erase the sprite with the background */


	/* if the sprite hits a wall, reverse the direction */
		if( (x+dx>319-width) || (x+dx<0)) dx = -dx;
		if( (y+dy>199-height) || (y+dy<0)) dy = -dy;
		x+=dx;          /* update x & y coordinates */
		y+=dy;

	}while(!kbhit());

	erase32bit(0,0,320,200,virt);   /* erase virt (make it black) */
	disflip64k(virt,screen);        /* dissolveflip black virt over to the screen */
	setmode(3);                     /* get back into textmode */
	free(virt);                     /* return the allocated memory for virt */
}
else ; //print an error message here (out of memory or something like that)
//I didn't because I haven't written any text-functions for this part of the demoschool
// There's enough functions as it is now . . .
}
