/************************************************************************/
/*                                                                      */
/*              Sourcecode for part 2 in Abe's demoschool               */
/*                      (Only the flag, no text)                        */
/*                                                                      */
/*      This program draws a flag on the screen and moves it using a    */
/*      precalculated sinus-table.                                      */
/*                                                                      */
/*      The program is pretty messy in main with lots of inline         */
/*                            assembly.                                 */
/*                                                                      */
/*      The theory behind it all is found in demo2.txt                  */
/*      Compile onlyflag.c whith:                                       */
/*                                                                      */
/*              bcc -1 onlyflag.c               Borland c               */
/*              tcc -1 onlyflag.c               Turbo c                 */
/*                                                                      */
/*      -1 means that 286-instructions is allowed.                      */
/*      If you use another compiler remember to allow 286-instructions. */
/*                                                                      */
/*              1996-01-04      VSTERS                                */
/*              Albert Veli                                             */
/*              mail: dat94avi@idt.mdh.se                               */
/*                                                                      */
/*                                                                      */
/*      PS      If the flag suffers from severe slowness, try           */
/*              decreasing the width & height of the flag       DS      */
/*                                                                      */
/************************************************************************/

#include<conio.h>
#include<math.h>

//Try to change the first 5 #define values and see what happens

#define WIDTH 180       //Change to acceptable size (less if slow computer)
#define HEIGHT 100      //The height should be about half of the width
#define FASE 2          //change between        1..6
#define WAVEX 2         //                      1..4
#define WAVEY 3         //                      1..4

#define PI 3.14159      // Don't change these
#define KX FASE*2*PI/WIDTH
#define BLUE 127-20
#define GULT 63-20
#define VITT 255-20
#define RED 191-20

//Waits for the electron beam to finish current screen (vertical retrace)
void wtsync(void)
{
asm     mov     dx,3DAh
WaitVR1:
asm     in      al,dx
asm     test    al,8
asm     jne     WaitVR1
WaitVR2:
asm     in      al,dx
asm     test    al,8
asm     je      WaitVR2
}

//makes the palette pal the active palette
void setpal(unsigned char*pal)
{
int i;
outp(0x3c8,0);
for(i=0;i<256*3;i++)
outp(0x3c9,pal[i]);
}

//sets all colors to black
void blackpal(void)
{
int i;
outp(0x3c8,0);
for(i=0;i<256*3;i++) outp(0x3c9,0);
}

//fades the palette in from black
void fade_in(unsigned char*palett)
{
int i,j;
unsigned char pal[256*3];

for(i=0;i<256*3;i++) pal[i]=0;
for(j=0;j<64;j++)
{
outp(0x3c8,0);

wtsync();
wtsync();

	for(i=0;i<256*3;i++)
	{
		outp(0x3c9,pal[i]);
		if(pal[i]<palett[i]) pal[i]++;
	}
}
}

//fades the palette out to black
void fade_to_black(char*pal)
{
int i,j;

for(j=0;j<64;j++)
{
	outp(0x3c8,0);
	wtsync();
	for(i=0;i<256*3;i++)
	{
		outp(0x3c9,pal[i]);
		if(pal[i]>0) pal[i]--;
	}
}
} // (fade to black is btw a great song by Metallica)

//fades the palette to white
//both fade_to_black and fade_to_white destroys the array pal
//if you want to save pal just make a local copy of it in the function
//and leave the original alone
void fade_to_white(char*pal)
{
int i,j;

for(j=0;j<64;j++)
{
	outp(0x3c8,0);
	if(i%2==0)wtsync();     //let the fade to white be pretty fast
				//only wait everyother frame
	for(i=0;i<256*3;i++)
	{
		outp(0x3c9,pal[i]);
		if(pal[i]<63) pal[i]++;
	}
}
}

//calculates a palette and puts it in the array pal
void coolpal(char*pal)
{
int i,r=0,g=0,b=0,col=0;

	for(i=0;i<64;i++)      // BLACK - YELLOW
	{
	pal[col++]=r;
	pal[col++]=g;
	pal[col++]=b;
	if(r<63)r++;
	if(g<63)g++;
	}

	r=0;
	g=0;
	for(i=0;i<64;i++)      // BLACK - BLUE
	{
	pal[col++]=r;
	pal[col++]=g;
	pal[col++]=b;
	if(b<63)b++;
	}

	b=0;
	for(i=0;i<64;i++)      // BLACK - RED
	{
	pal[col++]=r;
	pal[col++]=g;
	pal[col++]=b;
	if(r<63)r++;
	}

	r=0;
	for(i=0;i<64;i++)      // BLACK - WHITE
	{
	pal[col++]=r;
	pal[col++]=g;
	pal[col++]=b;
	if(r<63)r++;
	if(g<63)g++;
	if(b<63)b++;
	}

	setpal(pal);                // activate the palette pal
}

//puts a pixel at (x,y) with color col
void putpixel(int x, int y, char col)
{
asm     mov     ax,0a000h
asm     mov     es,ax
asm     mov     bx,y      //bx = y
asm     mov     di,bx     //di = y
asm     xchg    bh,bl     //bx = 256*y
asm     shl     di,6      //di = 64*y
asm     add     di,bx     //di = (256 + 64)*y = 320*y
asm     add     di,x      //di = 320*y + x
asm     mov  al, col      //now es:di points where the pixel shall be drawn
asm     mov     [es:di],al //draw the pixel
}

//Draws the flag on the screen, very slow but it doesn't matter
//because it will only be done once in the beginning of the program
//(px,py) is the upper left corner of the screen where the flag will be drawn
void drawflag(char*flag,int px,int py)
{
int x,y;
for(x=0;x<WIDTH;x++)
{
	for(y=0;y<HEIGHT;y++) putpixel(px+x,py+y,flag[WIDTH*y+x]);
}
}
//sets a graphic mode, the mode is sent as parameter to the function
void setmode(int mode)
{
asm     mov ax,mode
asm     int 10h
}

//creates a tricolor, like the french flag
void trikolor(char*flag)
{
int x,y;
for(x=0;x<WIDTH;x++)
{
	for(y=0;y<HEIGHT/3;y++) flag[WIDTH*y+x]=BLUE;
}

for(x=0;x<WIDTH;x++)
{
	for(y=HEIGHT/3;y<HEIGHT;y++) flag[WIDTH*y+x]=VITT;
}

for(x=0;x<WIDTH;x++)
{
	for(y=2*HEIGHT/3;y<HEIGHT;y++) flag[WIDTH*y+x]=RED;
}
}

//Creates a swedish flag (Blue with yellow cross)
//To change to finnish (White with Blue cross) or some other cross flag
//you only have to change the colors
//(svenskflag means swedish flag in swedish)
void svenskflag(char*flag)
{
int x,y;
for(x=0;x<WIDTH/4+WIDTH/40;x++)
{
	for(y=0;y<HEIGHT;y++) flag[WIDTH*y+x]=BLUE;
}
for(x=WIDTH/4+WIDTH/40;x<WIDTH/3+WIDTH/15;x++)
{
	for(y=0;y<HEIGHT;y++) flag[WIDTH*y+x]=GULT;
}
for(x=WIDTH/3+WIDTH/15;x<WIDTH;x++)
{
	for(y=0;y<HEIGHT;y++) flag[WIDTH*y+x]=BLUE;
}

for(x=0;x<WIDTH;x++)
{
	for(y=HEIGHT/2-HEIGHT/9;y<HEIGHT/2+HEIGHT/9;y++) flag[WIDTH*y+x]=GULT;
}
}


/*
All three-colored flags like the french and all cross flags like the swedish
is very easy to create with small changes.
It will be more difficult to create an English or American flag because of
their geometries. But it is possible since none of them has more than four
colors and this program copes with ANY picture that consists of four colors
or less, the problem is to define the pattern of the flag. It could be done
in a separate file. . .
The palette is divided into four parts (0-63) (64-127) (128-191) (192-255).
(Watch the defines at the top of this code).
Each part has their own run from black to the color itself.
The color varies +20 to -20 colors, that means that 
	
	color 1 should be 63 - 20  = 43
	color 2 should be 127 - 20 = 107
	color 3 should be 191 - 20 = 171
	color 4 should be 255 - 20 = 235

Then color 1 will vary between 23 and 63. This leaves colors 0-22 unused
in each interval.
But with all our knowledge we could easy use them too but I don't think it's
urgent. For now we have enough colors.
*/

/* 
Main is pretty badly written, I know that I should have divided it
up into several smaller functions but I didn't because It's workin fine 
right now and I'm very, very sleepy (yaaawwn).
*/

void main(void)
{
int x,y,px,py,py1,foo,bar,doo,index,adrflag;
int sinlist[4*WIDTH];
char pal[256*3];
char flag[(WIDTH)*HEIGHT];
char virt[(WIDTH+40)*(HEIGHT+40)];

asm     lea     ax,flag         //this isn't really necessary but I couldn't
asm     mov     adrflag,ax      //make it compile any other way
//the offset to the array flag is saved in the int adrflag

setmode(0x0013);        //get into mode 13h

//calculate the sinus values and save them in the array sinlist
//this way we don't have to calculate any sines in the main loop
for(x=0;x<WIDTH;x++)
{
	sinlist[x]=0;   //let the flag be still at first
	sinlist[WIDTH+x]=sin(KX*x)*20;//then let it vary in sine waves
	sinlist[2*WIDTH+x]=sinlist[WIDTH+x];
	sinlist[3*WIDTH+x]=sinlist[WIDTH+x];
}

coolpal(pal);           //setup a palette with smooth colorruns
svenskflag(flag);       //draw a swedish flag
//trikolor(flag);       //or a french flag, you choose

blackpal();             //set all colors to black
drawflag(flag,(320-WIDTH)/2,(200-HEIGHT)/2);//draw the flag the first time
fade_in(pal);                   //fade it in (Ooooh)
//You can comment out the blackpal and fade_in rows if you get tired of
//waiting for the fades everytime you run the program

index=0;        //index to the sinlist
//by changing the index you get the flag moving

//This is the main loop it contains some inline assembly
//If you want you could cut out the inline assembly stuff and put
//it in separate functions.
do
{

//first erase the whole virt array
asm{    push    ds
	pop     es      //es = ds = datasegment
	lea     di,virt
	mov     cx,((WIDTH+40)*(HEIGHT+40))/2
	xor     ax,ax
	rep     stosw

	lea     si,flag //point ds:si to the array flag
	mov     doo,si  //doo is the offset to the array flag
	lea     di,virt //es:di points to virt
	add     di,(WIDTH+40)*20+20 //start at 20,20 in virt (leave room for movement)
	mov     bar,di  //bar = the offset to virt
}       //foo and bar are temporary variables that points to the arrays
	//flag and virt
	//it's common to call temporary variables foo, bar and doo
	//(already on the ZX-Spectrum time they did so)


//Copy the data from virt over to flag, at the same time move the vertical
//rows of the flag foo pixels in the y-direction.
//foo, py and py1 are calculated from the sinlist.
//foo depends on index and the x-position during the loop
//changing index makes the flag move from frame to frame
//at the same time I change the color also depending on the index and x-position
//making the color change with the waves in the x-direction
//which enhances the feeling of waveiness
for(x=0;x<WIDTH;x++)
{
 py=sinlist[index+x];   //py=value to add to the color
 py1=sinlist[index+x+WIDTH/(2*FASE)]; //make the y-waves move in fase with the colorwaves
 foo=(WIDTH+40)*(py1>>WAVEY); //foo = the change in the y-direction
 _DI=bar+x+foo;               //di = the position in virt
 _SI=doo+x;                   //si = the position in flag

 asm    mov     cx,HEIGHT       //cx = the number of pixels to move
 asm    mov     bx,py           //bx = the change in color
ape:
 asm    lodsb
 asm    add     ax,bx           //ax = color + change in color
 asm    stosb
 asm    add     si,(WIDTH-1)
 asm    add     di,(WIDTH+40-1)
 asm    loop    ape
}


//Now the flag and color is in waves in the y-direction
//Now we'll make it wavey in the x-direction too
//That's done completely in virt
//When it's done virt is flipped over to the visible screen
asm     lea     si,virt //let es:di & ds:si point to virt
asm     add     si,20
asm     push    ds
asm     pop     es
asm     mov     di,si

for(y=0;y<HEIGHT+40;y++) //loop trough all rows
{
px=sinlist[index+y]>>WAVEX;     //px = number of pixels to move the row
				//px can be positive or negative
if(px<0)                        //if px is negative
{
	asm     cld             //move from left to right
	asm     add     di,px   //px is negative so make si go first
	asm     mov     cx,(WIDTH+10)/2 //and di follow
	asm     rep     movsw
	asm     add     si,30
	asm     mov     di,si
}
if(px>0)      //if px is positive move from right to left
{
	asm     std
	asm     add     si,WIDTH //si first and di follow
	asm     mov     di,si   //the pixels will be copied from ds:si
	asm     add     di,px   //to es:di so si must be first or the
	asm     mov     cx,(WIDTH+10)/2 //flag will be destroyed
	asm     rep     movsw      //move one complete row two pixels at a time
	asm     add     si,WIDTH+50     //move to next row
	asm     mov     di,si
	asm     cld
}
if(px==0) 
{
	asm     add     si,WIDTH+40     //if px is 0 dont move anything
	asm     mov     di,si           //just go on to the next row
}
}

index++;                //changing index makes the flag move

if(index==2*WIDTH) index=WIDTH; //if index is at the end of the sinlist
				//move it to the beginning of the waves
				//in the sinlist
				//the waves begin at sinlist[WIDTH]
				//the absolute beginning of sinlist
				//was all 0 remember?

wtsync();       //syncronize with the electronbeam before flipping
		//virt over to the visible screen

//Flip the contents of virt over to the visible screen
//di = upper left corner on the screen where the flag will be drawn

asm{ mov ax,0a000h
	mov es,ax
	mov di,(320-WIDTH-40)/2+160*(200-HEIGHT-40)
		//This formula is supposed to work
		//on different sizes of the flag 
		//you could also write a constant value directly to di here
	lea si,virt
	mov dx,HEIGHT+40
}
ldsf:           //don't you like the names of my labels?
asm{
    mov cx,(WIDTH+40)/2
	rep movsw
	add di,320-WIDTH-40
	dec dx
	jnz ldsf
}

}while(!kbhit());        //continue until someone hits the keybored

fade_to_white(pal);     //fade the screen up to white
fade_to_black(pal);     //the fade it out to black
setmode(3);             //finally get back into textmode
}
