#ifndef _ENGINE_H_
#define _ENGINE_H_

/** 3DGPL *************************************************\
 *  ()                                                    *
 *  Header for the 3D engine.                             *
 *                                                        *
 *  eng-base.c               polymorphic polygon.         *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

/**********************************************************\
 * Polygon:                                               *
 *                                                        *
 *  +--------------------+                                *
 *  | m_id               | M_AMBIENT|M_SHADED|M_TEXTURED  *
 *  |                    |                                *
 *  | m_colour           |        +-------------+         *
 *  | m_texture- - - - - - - - -> |texture bytes|         *
 *  | m_log_texure_size  |        |             |         *
 *  | m_log_texture_scale|        +-------------+         *
 *  |                    |                                *
 *  | m_u_index          |                                *
 *  | m_v_index          |                                *
 *  |                    |                                *
 *  | m_no_edges         |                                *
 *  | m_edges    +------------+                           *
 *  |            |   vertex   |                           *
 *  |            |   numbers  |                           *
 *  |            |& attributes|                           *
 *  |            |    ...     |                           *
 *  |            +------------+                           *
 *  +--------------------+                                *
\**********************************************************/

#define M_AMBIENT              0x3          /* constant colour polygon */
#define M_SHADED               0x4          /* Gouraud shaded polygon */
#define M_TEXTURED             0x5          /* texture mapped polygon */
#define M_POLYGON_LENGTH_LIMIT  50          /* length of tmp arrays */

#define M_SIZE_EDGE_ARRAY       15          /* coordinates + colours + etc */

struct M_polygon                            /* describes one polygon */
{
 int m_id;                                  /* M_AMBIENT|M_SHADED|M_TEXTURED */

 int m_colour;                              /* only for M_AMBIENT */
 unsigned char *m_texture;                  /* only for M_TEXTURED */
 int m_log_texture_size;                    /* log base 2 of texture size */
 int m_log_texture_scale;                   /* log base 2 texture scaling */

 int m_u_index;                             /* indexes of texture */
 int m_v_index;                             /* orientation vectors */

 int m_no_edges;                            /* number of edges in the polygn */
 int m_edges[M_SIZE_EDGE_ARRAY];            /* numbers/attributes */
};

void M_render_polygon(struct M_polygon *polygon,int *vertexes,int *vectors);

/**********************************************************/

#endif
