#ifndef _HARDWARE_H_
#define _HARDWARE_H_

/** 3DGPL *************************************************\
 *  (MSDOS, i386+, VGA, WATCOM C)                         * 
 *  Header for hardware specific stuff.                   *
 *                                                        *
 *  hardware.c               hardware specific stuff.     *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

typedef short signed_16_bit;                /* compiler/mashine dependent */
typedef int   signed_32_bit;                
typedef unsigned short unsigned_16_bit;       
typedef unsigned int   unsigned_32_bit;

void HW_set_int(int *dst,int lng,int val);  /* fast memory operations */
#pragma aux HW_set_int=   \
 "cld"                    \
 "rep stosd"              \
 parm [edi] [ecx] [eax];

void HW_set_char(char *dst,int lng,char val);
#pragma aux HW_set_char=  \
 "cld"                    \
 "rep stosb"              \
 parm [edi] [ecx] [al];

void HW_copy_int(int *src,int *dst,int lng);
#pragma aux HW_copy_int=  \
 "cld"                    \
 "rep movsd"              \
 parm [esi] [edi] [ecx];

void HW_copy_char(char *src,char *dst,int lng);
#pragma aux HW_copy_char= \
 "cld"                    \
 "rep movsb"              \
 parm [esi] [edi] [ecx];

#define HW_SCREEN_X_SIZE         320             
#define HW_SCREEN_Y_SIZE         200        /* number of pixels total */

#define HW_SCREEN_X_MAX          319
#define HW_SCREEN_Y_MAX          199        /* number of maximum pixel */

#define HW_SCREEN_X_CENTRE       160 
#define HW_SCREEN_Y_CENTRE       100        /* middle of the screen */

#define HW_COLOURMAP_SIZE_CHAR 64000        /* bytes in the colourmap */
#define HW_COLOURMAP_SIZE_INT  16000        /* ints in the colourmap */

struct HW_colour                            /* describes colour */
{
 int hw_r;
 int hw_g;
 int hw_b;                                  /* intensity components */
};

int HW_open_screen(char *display_name,
                   char *screen_name, 
                   struct HW_colour palette[256],
                   unsigned char *colourmap
                  );
void HW_blit(void);
void HW_close_screen(void);

#define HW_KEY_ARROW_LEFT  75
#define HW_KEY_ARROW_RIGHT 77
#define HW_KEY_ARROW_UP    72
#define HW_KEY_ARROW_DOWN  80

#define HW_KEY_PLUS        43
#define HW_KEY_MINUS       45

#define HW_KEY_ENTER       13
#define HW_KEY_SPACE       32
#define HW_KEY_TAB          9               /* all i can think of */ 

void HW_run_event_loop(void (*application_main)(void),
                       void (*application_key_handler)(int key_code)
                      );
void HW_quit_event_loop(void);

/**********************************************************/

#endif
