'Source Code for Yankovic 4.1
'Written by John Richter
'Assisted by Walter E. Manning

'Initialize defaults for variables
zoom = 200
detail = .001
Xpos = 0
Ypos = 0
factor = 2

'Draws cursor for zooming
DIM Cursor(22)
CLS
SCREEN 12
CIRCLE (5, 5), 5
LINE (5, 0)-(5, 10)
LINE (0, 5)-(10, 5)
GET (0, 0)-(10, 10), Cursor

'Initialize Function Keys
KEY(1) ON: KEY(10) ON: KEY(11) ON: KEY(14) ON

'Point Program to Function Key Subroutines
ON KEY(1) GOSUB ZoomIn
ON KEY(10) GOSUB fin
ON KEY(11) GOSUB HighRes
ON KEY(14) GOSUB LowRes

restart:

'Reinitialize function keys, in case user aborts Mandelbrot
KEY(1) ON: KEY(2) ON: KEY(10) ON: KEY(11) ON: KEY(14) ON

'Initialize error handler
ON ERROR GOTO UhOh

'Initialize Screen
SCREEN 12: CLS
COLOR 1
PRINT "ͻ"
PRINT "                                                                             "
PRINT "                                                                             "
PRINT "                                                                             "
PRINT "ͼ"
COLOR 5
LOCATE 2, 4: PRINT "Welcome to version 4.1 of Yankovic, the program designed to display the"
LOCATE 3, 4: PRINT "   Yankovic Set. This is the first updated shareware version, in all"
LOCATE 4, 4: PRINT "               its pompous glory. Distribute at will!"
PRINT
COLOR 2
PRINT
PRINT "1 - Draw a new set"
PRINT "2 - See an example of a Mandlebrot set"
PRINT "3 - Edit the program's options"
PRINT "4 - Help (Strongly recommended, if you've never used this program before)."
PRINT "5 - About the program"
PRINT "6 - Quit to the grueling land of DOS"
PRINT
COLOR 7
PRINT "Enter number of choice: "
PressMenu:
        choice$ = INKEY$
        IF choice$ = "" THEN GOTO PressMenu ELSE choice = VAL(choice$)
        IF choice > 6 THEN GOTO idiot
        ON choice GOTO ZoomFlag, MandelBrot, EditOptions, Help, About, GoodBye

ZoomFlag:
        GOSUB CoolSound

'Initialize other variables
threshold = 80

'Initialize Temp Variables
i2 = 1.02: n2 = -.94: i = 0: n = 0

'Clear Screen
CLS

'Start Main Body of Program
begin:

'Apply change after each pass
i = 0: n = 0: i2 = i2 - detail: n2 = n2 + detail

'Starts calculation loop
FOR calc = 1 TO 300

'Squares complex numbers and adds constants (QBasic cannot do imaginary math without help from the programmer)
        temp = -1 * (i ^ 2)
        i = i * n * 2 + i2
        n = n ^ 2 + temp + n2

'Breaks off loop when numbers become too high
        IF (ABS(i) > threshold) OR (ABS(n) > threshold) THEN GOTO begin
 
'Initialize color variable
        c = calc

'Infinite color emulator
colorchoose:
        IF c > 16 THEN c = c - 16: GOTO colorchoose
  
'Graph points
        PSET (zoom * n - Xpos + 320, zoom * i - Ypos + 240), c

'Go through calculations again
NEXT calc

'When calculations are done, starts main body of program again
'to calculate next point
GOTO begin

'Restarts program if F10 is pressed
fin:
GOTO restart

'Raises resolution & displays new stats if up arrow is pressed
HighRes:
        detail = detail / 10
        LOCATE 27, 1: PRINT SPC(12); : LOCATE 27, 1: PRINT detail
RETURN

'Lowers resolution & displays new stats if down arrow is pressed
LowRes:
        detail = detail * 10
        LOCATE 27, 1: PRINT SPC(12); : LOCATE 27, 1: PRINT detail
RETURN
'----------------------------------------------------------------------------
ZoomIn:
        CursorRate = 3
        ThumbsUp = 0
        CursorPosX = 315
        CursorPosY = 235

CenterCursor:
        PUT (CursorPosX, CursorPosY), Cursor

Positioner:
        Modx = 0: Mody = 0

WaitForInput:
        FromUser$ = INKEY$
        IF FromUser$ <> "" THEN
                IF FromUser$ = "w" THEN Mody = -CursorRate
                IF FromUser$ = "a" THEN Modx = -CursorRate
                IF FromUser$ = "s" THEN Modx = CursorRate
                IF FromUser$ = "z" THEN Mody = CursorRate
                IF FromUser$ = CHR$(13) THEN GOTO Init
                IF FromUser$ = CHR$(27) THEN RETURN
                IF (CursorPosX + Modx + 5 >= 639) OR (CursorPosX + Modx - 5 <= 0) THEN Modx = 0
                IF (CursorPosY + Mody + 5 >= 479) OR (CursorPosY + Mody - 5 <= 0) THEN Mody = 0
                PUT (CursorPosX, CursorPosY), Cursor
                PUT (CursorPosX + Modx, CursorPosY + Mody), Cursor
                CursorPosX = CursorPosX + Modx
                CursorPosY = CursorPosY + Mody
        END IF
GOTO Positioner

Init:
        zoom = zoom * factor
        Xpos = Xpos + (CursorPosX - 320)
        Ypos = Ypos + (CursorPosY - 240)
        Xpos = Xpos * factor
        Ypos = Ypos * factor

GOTO ZoomFlag

'_____________________________________________________________________________
EditOptions:
        CLS
'Allow input of Zoom, Detail, X-Coordinates, and Y-Coordinates or apply defaults
        INPUT "Zoom factor     : ", zoom$
        IF zoom$ = "" THEN zoom = 200 ELSE zoom = VAL(zoom$)
        INPUT "*Detail Level   : ", detail$
        IF detail$ = "" THEN detail = .001 ELSE detail = VAL(detail$)
        INPUT "X-coordinate    : ", Xpos$
        IF Xpos$ = "" THEN Xpos = 0 ELSE Xpos = VAL(Xpos$)
        INPUT "Y-coordinate    : ", Ypos$
        IF Ypos$ = "" THEN Ypos = 0 ELSE Ypos = VAL(Ypos$)
        INPUT "Zoom Multiplier : ", factor$
        IF factor$ = "" THEN factor = 2 ELSE factor = VAL(factor$)
GOTO restart

'_____________________________________________________________________________
idiot:
        CLS
        SOUND 7000, 40

        PRINT "Are there more than six items in the list? Do you see any item in that list"
        PRINT "with a number higher than six? I didn't think so. Don't be silly."
        PRINT
        PRINT "(Press any key to continue)"
PressKey2:
        IF INKEY$ = "" THEN GOTO PressKey2

GOTO restart
'____________________________________________________________________________
About:
        RANDOMIZE VAL(LEFT$(TIME$, 2))
        SCREEN 13: CLS
        y = 0
        ColorConstant = 40
        c = ColorConstant

FOR DataEntry = 1 TO 2 STEP 0
        FOR x = Size TO 0 STEP -2
                FOR hes = 1 TO 900: NEXT hes
                LINE (XCenter, YCenter + y)-(XCenter + x, YCenter), c
                LINE (XCenter, YCenter - y)-(XCenter - x, YCenter), c
                LINE (XCenter, YCenter - y)-(XCenter + x, YCenter), c
                LINE (XCenter, YCenter + y)-(XCenter - x, YCenter), c
                y = y + 2: c = c + 1
        NEXT x
        XCenter = 320 * RND
        YCenter = 240 * RND
        Size = RND * 50 + 50
        y = 0
        c = ColorConstant
        LOCATE 1, 15: PRINT "Yankovic 4.1"
        LOCATE 3, 12: PRINT "Yankovic Set Viewer"
        LOCATE 4, 10: PRINT "created by: John Richter"
        LOCATE 22, 4: PRINT "(Press any key to return to menu)"
        IF INKEY$ <> "" THEN GOTO restart
NEXT DataEntry
'____________________________________________________________________________

CoolSound:
        FOR Warble = 1 TO 10
        SOUND (1000 * Warble), 1
        NEXT Warble
RETURN
'----------------------------------------------------------------------------
UhOh:
        PRINT "Terribly sorry, an unrecoverable error has occured. Please run the program"
        PRINT "again. If the error persists, call me immediately at (809) 773-8631 so"
        PRINT "I may personally correct the problem!"
END
'----------------------------------------------------------------------------
MandelBrot:

'Disable unusable keys     
KEY(1) STOP: KEY(11) STOP: KEY(14) STOP
       
        MandelZoom = 1
        x = 0
        y = 0

SCREEN 12
CLS

FOR Xpos = 0 TO 240
        RealMod = (-2 + (Xpos + x) / 60)
        FOR Ypos = 0 TO 240
                ImageMod = (2 - (Ypos + y) / 60)
                RealConstant = 0
                ImageConstant = 0
                FOR iteration = 1 TO 20
                        zreal = RealConstant ^ 2 - ImageConstant ^ 2 + RealMod
                        zreal = zreal / MandelZoom
                        zimage = 2 * RealConstant * ImageConstant + ImageMod
                        zimage = zimage / MandelZoom
                        IF zreal ^ 2 + zimage ^ 2 > 4 THEN clr = iteration: GOTO SkipPlot
                        RealConstant = zreal
                        ImageConstant = zimage
                NEXT iteration
ResumeFlag:
        NEXT Ypos
NEXT Xpos

PressKey3:
        IF INKEY$ = "" THEN GOTO PressKey3
        GOTO restart

SkipPlot:
        IF clr > 16 THEN clr = clr - 16: GOTO SkipPlot
        PSET (Xpos, Ypos), clr
        GOTO ResumeFlag
'----------------------------------------------------------------------------
Help:

CLS
COLOR 12
PRINT "Welcome to the new, improved and much easier to use help system!"
PRINT
COLOR 14
PRINT "Press 1 for information about runtime program operation, and 2 to"
PRINT "learn about how to edit program options. Any other key returns you to"
PRINT "the main menu."

KeyWait:
        StrikeKey$ = INKEY$
        IF StrikeKey$ = "1" THEN GOSUB HelpProg
        IF StrikeKey$ = "2" THEN GOSUB HelpEdit
        IF StrikeKey$ = "" THEN GOTO KeyWait
        GOTO restart

HelpProg:
CLS
COLOR 9
PRINT "In operation, the program works through the use of Hot-Keys."
PRINT
PRINT
COLOR 14
PRINT "F10        - Returns you to the Main Menu, no matter where you are"
PRINT
COLOR 12
PRINT "Up Arrow   - Raises the resolution of the fractal 'on the fly'"
PRINT
COLOR 14
PRINT "Down Arrow - Lowers the resolution of the fractal 'on the fly'"
PRINT
COLOR 12
PRINT "F1         - Puts you in zoom mode while the fractal is iterating."
PRINT
COLOR 14
PRINT "Esc        - Backs out of zoom mode"
PRINT
COLOR 12
PRINT "W          - Moves the zoom mode cursor up"
PRINT
COLOR 14
PRINT "A          - Moves the zoom mode cursor left"
PRINT
COLOR 12
PRINT "S          - Moves the zoom mode cursor right"
PRINT
COLOR 14
PRINT "Z          - Moves the zoom mode cursor down"
PRINT
COLOR 12
PRINT "Enter      - Zooms in 2x to whatever part of the fractal the cursor is on"
PRINT
COLOR 15
PRINT "Press any key to continue"

AnyKey:
        IF INKEY$ = "" THEN GOTO AnyKey
        GOTO Help

HelpEdit:

CLS
COLOR 9
PRINT "The variables in the Edit Options section are..."
PRINT
PRINT
COLOR 10
PRINT "Zoom factor  - How far you are zoomed in when the fractal starts (default: 200)"
PRINT
COLOR 11
PRINT "Detail       - How high the detail is when the program starts (default: .001)"
PRINT
COLOR 10
PRINT "X-Coordinate - How far to the left or right the fractal starts (default: 0)"
PRINT
COLOR 11
PRINT "Y-Coordinate - How far up or down the fractal is when it starts (default: 0)"
PRINT
COLOR 10
PRINT "Zoom Multiplier - How much zoom mode zooms in when enter is pressed (default: 2)"
PRINT
PRINT
COLOR 14
PRINT "The defaults can be entered automatically by simply pressing enter when"
PRINT "prompted for a value. The program will skip to the next and give the"
PRINT "variable you skipped the default value."
PRINT
COLOR 15
PRINT "Press any key to continue"

AnyKey2:
        IF INKEY$ = "" THEN GOTO AnyKey2
        GOTO Help
'____________________________________________________________________________
GoodBye:
END




