'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        PBClone  Copyright (c) 1990-1993  Thomas G. Hanlin III        |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE SUB FClose1 (BYVAL FileHandle%)
   DECLARE SUB FOpen1 (FileName$, BYVAL ReadWrite%, BYVAL Sharing%, FileHandle%, ErrCode%)
   DECLARE SUB SFRead (BYVAL FileHandle%, St$, BytesRead%, ErrCode%)

SUB IdentifyFile (FileName$, Description$, DescriptionLen%)

   File$ = UCASE$(FileName$)
   IF RIGHT$(File$, 1) = CHR$(0) THEN
      File$ = LEFT$(File$, LEN(File$) - 1)
   END IF

   Tmp% = INSTR(File$, ".")
   IF Tmp% THEN
      Extension$ = MID$(File$, Tmp% + 1)
   ELSE
      Extension$ = ""
   END IF

   D$ = ""
   DetailedCheck% = 0

   SELECT CASE Extension$
      CASE "$$$": D$ = "temporary pipe file"
      CASE "@@@": D$ = "backup ID file"
      CASE "$$$": D$ = "temporary or backup file"
      CASE "ACT": D$ = "program source code (Actor) or comm account data (BITCOM)"
      CASE "AIO": D$ = "APL file transfer format file"
      CASE "AMG": D$ = "system image file (Actor)"
      CASE "ANS": D$ = "text file containing IBM ANSI display codes"
      CASE "APL": D$ = "APL work space format file"
      CASE "APP": D$ = "application file (SQLWindows)"
      CASE "ARC": DetailedCheck% = -1
      CASE "ARF": D$ = "response file created by a Microsoft compiler"
      CASE "ARJ": D$ = "compressed library of files (ARJ)"
      CASE "ASC": D$ = "ASCII (text) file"
      CASE "ASM": D$ = "assembly language source code"
      CASE "BAK": D$ = "backup copy of a file"
      CASE "BAS": DetailedCheck% = -1
      CASE "BAT": D$ = "executable code (DOS batch language)"
      CASE "BI" : D$ = "includeable source code for compiled BASIC"
      CASE "BIN": D$ = "binary data file"
      CASE "BLK": D$ = "block info file (Show Partner)"
      CASE "BMP": D$ = "picture file (MS Windows)"
      CASE "C"  : D$ = "C source code"
      CASE "CAL": D$ = "calendar data (MS Windows) or spreadsheet file (SuperCalc)"
      CASE "CAP": D$ = "captions (Ventura Publisher)"
      CASE "CCL": D$ = "comm command language file (Intalk)"
      CASE "CDR": D$ = "picture (Corel Draw)"
      CASE "CFG": D$ = "configuration, initialization or setup file"
      CASE "CGM": D$ = "picture"
      CASE "CHK": D$ = "file recovered by CHKDSK"
      CASE "CHP": D$ = "chapter (Ventura Publisher)"
      CASE "CIF": D$ = "chapter information (Ventura Publisher)"
      CASE "CLR": D$ = "color palette (Show Partner)"
      CASE "CLS": D$ = "class library file (Actor)"
      CASE "CMD": D$ = "executable code (CP/M-86 or OS/2) or program (dBASE)"
      CASE "CMP": D$ = "word comparison file (MS Word)"
      CASE "CNF": D$ = "configuration, initialization or setup file"
      CASE "COB": D$ = "COBOL source code"
      CASE "COD": D$ = "FORTRAN compiled code"
      CASE "COM": DetailedCheck% = -1
      CASE "COL": D$ = "spreadsheet (MS Multiplan)"
      CASE "CPL": D$ = "control panel applet (MS Windows)"
      CASE "CPP": D$ = "C++ source code"
      CASE "CRD": D$ = "index card file (MS Windows)"
      CASE "CRF": D$ = "cross-reference listing"
      CASE "CRS": D$ = "golf course data file (World Tour Golf)"
      CASE "CTX": D$ = "course text file for a tutorial (Microsoft)"
      CASE "CUR": D$ = "cursor definition (MS Windows)"
      CASE "DAT": D$ = "data file"
      CASE "DB" : D$ = "database file (Paradox)"
      CASE "DBD": D$ = "demonstration data (Norton)"
      CASE "DBF": D$ = "database file (dBASE)"
      CASE "DBS": D$ = "database file (SQLWindows)"
      CASE "DBT": D$ = "text file (dBASE)"
      CASE "DCA": D$ = "text file (IBM)"
      CASE "DCT": D$ = "spelling dictionary"
      CASE "DEF": D$ = "definitions or defaults file"
      CASE "DEV": D$ = "device driver"
      CASE "DFM": D$ = "data entry form (Palantir Filer)"
      CASE "DGI": D$ = "picture (Digi-Pic)"
      CASE "DGS": D$ = "diagnostics file (PC-DOS)"
      CASE "DIB": D$ = "device-independent bitmap (MS Windows)"
      CASE "DIC": D$ = "spelling dictionary"
      CASE "DIF": D$ = "data interchange format file"
      CASE "DIR": D$ = "dialing directory (phone book)"
      CASE "DIS": D$ = "start-up file (Q&A)"
      CASE "DLL": D$ = "dynamic link library (MS Windows)"
      CASE "DOC": D$ = "document, documentation or a manual (text file)"
      CASE "DOT": D$ = "tutorial (Microsoft)"
      CASE "DOX": D$ = "document (MultiMate)"
      CASE "DRV": D$ = "device driver"
      CASE "DRW": D$ = "picture (Micrografx)"
      CASE "DTA": D$ = "data file"
      CASE "DTF": D$ = "database (PFS or Q&A)"
      CASE "DWC": D$ = "compressed library of files (DWC)"
      CASE "EMU": D$ = "terminal emulation data (BITCOM)"
      CASE "EPS": D$ = "picture (Encapsulated PostScript)"
      CASE "ERR": D$ = "error code data"
      CASE "EXE": DetailedCheck% = -1
      CASE "FAC": D$ = "character font (LePrint)"
      CASE "FLI": D$ = "animation file (Animator)"
      CASE "FMT": D$ = "screen format (dBASE)"
      CASE "FNT": D$ = "character font"
      CASE "FON": D$ = "character font or phone book"
      CASE "FOO": D$ = "temporary or miscellaneous file"
      CASE "FOR": D$ = "FORTRAN source code"
      CASE "FRM": D$ = "report layout (dBASE)"
      CASE "GEM": D$ = "picture (GEM draw)"
      CASE "GIF": D$ = "picture (CompuServe format)"
      CASE "GRB": D$ = "snapshot or 'grab file' (MS Windows)"
      CASE "GRF": D$ = "graph (Micrografx)"
      CASE "GRP": D$ = "group definition (MS Windows)"
      CASE "GUI": D$ = "guide document (Guide)"
      CASE "GX1": D$ = "picture (Show Partner)"
      CASE "H"  : D$ = "C header file"
      CASE "HEX": D$ = "hex dump file (DEBUG)"
      CASE "HLP": D$ = "help file"
      CASE "HP" : D$ = "graphics (Hewlett-Packard)"
      CASE "HPP": D$ = "C++ header file"
      CASE "HXX": D$ = "C++ header file"
      CASE "ICO": D$ = "icon definition (MS Windows)"
      CASE "IDX": D$ = "index file"
      CASE "IMG": D$ = "picture (GEM paint, ISF, WPS, et al)"
      CASE "IMP": D$ = "implementation file (IBM Pascal)"
      CASE "INC": D$ = "includeable source code"
      CASE "INI": D$ = "configuration, initialization or setup file"
      CASE "INF": D$ = "library definition file (LibWiz)"
      CASE "INT": D$ = "implementation file (IBM Pascal) or command file (XyWrite)"
      CASE "ION": D$ = "description of files"
      CASE "IT" : D$ = "settings file (Intalk)"
      CASE "JOR": D$ = "journal (SQLWindows)"
      CASE "KBD": D$ = "keyboard configuration (XyWrite)"
      CASE "KEX": D$ = "Kexx/Rexx source code (KEDIT)"
      CASE "KEY": D$ = "keyboard definition file"
      CASE "LAY": D$ = "keyboard configuration (SuperKey)"
      CASE "LBL": D$ = "label description (dBASE)"
      CASE "LBR": D$ = "library of files"
      CASE "LIB": D$ = "linkable code library"
      CASE "LST": D$ = "listing"
      CASE "LZH": D$ = "compressed library of files"
      CASE "MAC": D$ = "picture (MacIntosh) or keyboard macro (ProKey, SuperKey)"
      CASE "MAN": D$ = "documentation or a manual"
      CASE "MAP": D$ = "memory map (LINK)"
      CASE "MDM": D$ = "modem information (Access)"
      CASE "MEM": D$ = "memory file (dBASE)"
      CASE "MID": D$ = "sound data in MIDI format (MS Windows)"
      CASE "MNU": D$ = "menu definition (Access)"
      CASE "MOD": D$ = "modifications list, Modula-2 source code, or music file"
      CASE "MSG": D$ = "message file (MS Multiplan, Sidekick)"
      CASE "MSP": D$ = "picture (MS Windows)"
      CASE "NDX": D$ = "index file"
      CASE "NET": D$ = "network configuration (Paradox)"
      CASE "NEW": D$ = "new information (text)"
      CASE "NOT": D$ = "notice (text)"
      CASE "OBJ": D$ = "object code"
      CASE "O"  : D$ = "object code (non-standard form)"
      CASE "OLD": D$ = "backup file (Microsoft)"
      CASE "OVD": D$ = "executable file (overlay for Paradox)"
      CASE "OVL": D$ = "executable file (overlay)"
      CASE "OVR": D$ = "executable file (overlay)"
      CASE "PAK": DetailedCheck% = -1
      CASE "PAL": D$ = "color palette (PC Paintbrush)"
      CASE "PAS": D$ = "source code (Pascal)"
      CASE "PCC": D$ = "picture (PC Paintbrush)"
      CASE "PCT": D$ = "picture (MacIntosh)"
      CASE "PCX": D$ = "picture (PC Paintbrush)"
      CASE "PDF": D$ = "printer definitions (WordStar)"
      CASE "PDV": D$ = "printer definitions (PC Paintbrush)"
      CASE "PFM": D$ = "printer font metric (MS Windows)"
      CASE "PGM": D$ = "executable file (overlay)"
      CASE "PIC": D$ = "picture (Micrografx, Lotus 1-2-3)"
      CASE "PIF": D$ = "program information (MS Windows)"
      CASE "PIX": D$ = "picture(s)"
      CASE "PJ" : D$ = "scheduling project (SuperProject)"
      CASE "PM" : D$ = "picture (PageMaker)"
      CASE "PM3": D$ = "picture (PageMaker v3.0)"
      CASE "PRD": D$ = "printer definitions (MS Word)"
      CASE "PRF": D$ = "spreadsheet printed to disk (VisiCalc)"
      CASE "PRG": D$ = "dBASE source code"
      CASE "PRJ": D$ = "project data (Harvard TPM)"
      CASE "PRN": D$ = "printer definitions or print-format file"
      CASE "PRO": D$ = "Prolog source code"
      CASE "PRS": D$ = "printer definitions (WordPerfect)"
      CASE "PS" : D$ = "page description (PostScript)"
      CASE "PUB": D$ = "publication file (PageMaker)"
      CASE "PX" : D$ = "primary index (Paradox)"
      CASE "QLB": D$ = "MS Quick code library"
      CASE "RC" : D$ = "resource script (MS Windows)"
      CASE "REF": D$ = "cross-reference listing"
      CASE "REX": D$ = "Rexx source code"
      CASE "RTF": D$ = "Rich Text Format file (Microsoft)"
      CASE "SC" : D$ = "Paradox source code"
      CASE "SCN": D$ = "screen image"
      CASE "SCP": D$ = "script file (BITCOM)"
      CASE "SCR": D$ = "screen image, script language code, or high scores"
      CASE "SET": D$ = "configuration, initialization or setup file"
      CASE "SLD": D$ = "picture (AutoCAD)"
      CASE "SLK": D$ = "Symbolic Link Format file"
      CASE "STY": D$ = "style sheet (Ventura Publisher)"
      CASE "SYM": D$ = "symbolic debugging definitions (MS Windows)"
      CASE "SYN": D$ = "synonym file (Word Finder)"
      CASE "SYS": D$ = "device driver"
      CASE "TBK": D$ = "book file (ToolBook)"
      CASE "TIF": D$ = "picture"
      CASE "TMP": D$ = "temporary file"
      CASE "TRM": D$ = "terminal program data (MS Windows)"
      CASE "TXT": D$ = "text file"
      CASE "VAL": D$ = "validity check file (Paradox)"
      CASE "VC" : D$ = "spreadsheet (VisiCalc)"
      CASE "VGR": D$ = "chapter information (Ventura Publisher)"
      CASE "VOC": D$ = "sound file (SoundBlaster)"
      CASE "VUE": D$ = "relational view (dBASE)"
      CASE "WAV": D$ = "sound file (MS Windows)"
      CASE "WCM": D$ = "communication file (MS Works)"
      CASE "WDB": D$ = "database (MS Works)"
      CASE "WK1": D$ = "spreadsheet (Lotus 1-2-3 v2)"
      CASE "WKS": D$ = "spreadsheet (Lotus 1-2-3 v1a or MS Works)"
      CASE "WMF": D$ = "picture (MS Windows)"
      CASE "WPS": D$ = "text file (MS Works)"
      CASE "WRI": D$ = "text file (MS Windows)"
      CASE "XLC": D$ = "chart (Excel)"
      CASE "XLS": D$ = "spreadsheet (Excel)"
      CASE "XRF": D$ = "cross-reference listing"
      CASE "ZIP": D$ = "compressed library of files (PKZIP)"
      CASE "ZOO": D$ = "compressed library of files (ZOO)"
      CASE ELSE
   END SELECT


CheckFile:
   IF DetailedCheck% THEN
      FOpen1 File$, 0, 2, Handle%, ErrCode%
      IF ErrCode% THEN GOTO Done
      SELECT CASE Extension$
         CASE "ARC", "PAK"
            St$ = SPACE$(1)
            SFRead Handle%, St$, BR%, ErrCode%
            FClose1 Handle%
            IF ErrCode% THEN GOTO Done
            IF ASC(St$) = 26 THEN D$ = "compressed library of files"
         CASE "BAS"
            D$ = "BASIC source code"
            St$ = SPACE$(4)
            SFRead Handle%, St$, BR%, ErrCode%
            FClose1 Handle%
            IF ErrCode% THEN GOTO Done
            SELECT CASE ASC(St$)
               CASE 255: D$ = "BASIC source code (interpreted, tokenized)"
               CASE 254: D$ = "BASIC source code (interpreted, 'protected')"
               CASE 253
                  SELECT CASE CVI(RIGHT$(St$, 2))
                     CASE &HA000: D$ = "picture (BASIC, EGA/VGA)"
                     CASE &HB000: D$ = "picture (BASIC, MDA/Herc)"
                     CASE &HB800: D$ = "picture (BASIC, CGA/Herc)"
                     CASE ELSE: D$ = "binary memory image (BASIC)"
                  END SELECT
               CASE 252: D$ = "BASIC source code (QuickBASIC 4.x, tokenized)"
               CASE 32 TO 126: D$ = "BASIC source code (text format)"
               CASE ELSE
            END SELECT
         CASE "COM"
            D$ = "executable code, COM-format"
            St$ = SPACE$(15)
            SFRead Handle%, St$, BR%, ErrCode%
            FClose1 Handle%
            IF ErrCode% THEN GOTO Done
            IF LEFT$(St$, 2) = "MZ" THEN
               Extension$ = "EXE"
               GOTO CheckFile
            END IF
         CASE "EXE"
            D$ = "executable code"
            St$ = SPACE$(2)
            SFRead Handle%, St$, BR%, ErrCode%
            FClose1 Handle%
            IF ErrCode% THEN GOTO Done
            IF St$ = "MZ" THEN
               D$ = "executable code, EXE-format"
            ELSE
               Extension$ = "COM"
               GOTO CheckFile
            END IF
      END SELECT
   END IF

Done:
   Description$ = D$
   DescriptionLen% = LEN(Description$)

END SUB
