'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        PBClone  Copyright (c) 1990-1993  Thomas G. Hanlin III        |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE FUNCTION GetDrive$ ()
   DECLARE FUNCTION GetSub2$ (Drive$)
   DECLARE FUNCTION SubExist2% (SubDir$)
   DECLARE SUB SetDrv (Drive$)

SUB ExtendFSpec (OFile$, OExt$, FullFile$, ErrCode%)
   File$ = UCASE$(OFile$)
   Ext$ = UCASE$(OExt$)
   FullFile$ = ""
   ErrCode% = 0

   IF LEN(File$) = 0 THEN ErrCode% = -1

   IF LEFT$(Ext$, 1) = "." THEN
      Ext$ = MID$(Ext$, 2, 3)
   ELSE
      Ext$ = LEFT$(Ext$, 3)
   END IF

' ----- Junk Screen ---------------------------------------------------------
' Here we check for characters that can't legally be part of a file name.
' Note that we pass most graphics characters and even spaces through, since
' they are legal (although not usually advised).  If a Unix-style forward
' slash is found, it's converted into a DOS-style backslash.

   FOR tmp% = 1 TO LEN(File$)
      ch$ = MID$(File$, tmp%, 1)
      ch% = ASC(ch$)
      IF ch% < 32 OR ch% = 127 THEN
         ErrCode% = -1
      ELSEIF INSTR("+,;<=>[]|", ch$) > 0 OR ch% = 34 THEN
         ErrCode% = -1
      ELSEIF ch$ = "/" THEN
         ch$ = "\"
      END IF
      MID$(File$, tmp%, 1) = ch$
   NEXT

   IF ErrCode% < 0 THEN EXIT SUB

' ----- Get Drive -----------------------------------------------------------
' Here we get the drive specification.  If they gave us one, we check it to
' see if it seems reasonable.  Otherwise, we get the default drive.

   tmp% = INSTR(File$, ":")
   IF tmp% = 0 THEN
      Drive$ = GetDrive$
   ELSEIF tmp% = 2 THEN
      Drive$ = LEFT$(File$, 1)
      File$ = MID$(File$, 3)
      tmp$ = GetDrive$
      IF tmp$ <> Drive$ THEN
         SetDrv Drive$
         IF Drive$ <> GetDrive$ THEN ErrCode% = 1
         SetDrv tmp$
      END IF
   ELSE
      ErrCode% = -1
   END IF
   IF INSTR(File$, ":") THEN ErrCode% = -1
   FullFile$ = Drive$ + ":\"

   IF ErrCode% < 0 THEN EXIT SUB

' ----- Absolute Path -------------------------------------------------------
' If they gave us a relative path, we need to fill it out, so we get the
' default subdirectory on the specified drive.

   IF LEFT$(File$, 1) = "\" THEN
      File$ = MID$(File$, 2)
   ELSEIF ErrCode = 0 THEN
      tmp$ = MID$(GetSub2$(Drive$), 2)
      IF LEN(tmp$) THEN FullFile$ = FullFile$ + tmp$ + "\"
   END IF

' ----- Path Check ----------------------------------------------------------
' Here we do the final validity checking on the subdirectory specification.
' While we're at it, we trim each part of the subdirectory to its maximum
' length (8 characters, plus an optional 3-character extension).  Shorthand
' descriptions (like "..") are also processed here.

   DO
      IF File$ = "." OR File$ = ".." THEN
         File$ = File$ + "\"
      END IF
      tmp% = INSTR(File$, "\")
      IF tmp% = 1 THEN
         ErrCode% = -1
      ELSEIF tmp% THEN
         tmp$ = LEFT$(File$, tmp% - 1)
         File$ = MID$(File$, tmp% + 1)
         IF tmp$ = ".." THEN
            IF LEN(FullFile$) > 3 THEN
               DO
                  FullFile$ = LEFT$(FullFile$, LEN(FullFile$) - 1)
               LOOP UNTIL RIGHT$(FullFile$, 1) = "\"
            ELSE
               ErrCode% = -1
            END IF
         ELSEIF tmp$ <> "." THEN
            t% = INSTR(tmp$, ".")
            IF t% THEN
               tmp1$ = LEFT$(LEFT$(tmp$, t% - 1), 8)
               tmp$ = MID$(tmp$, t% + 1, 3)
               IF INSTR(tmp1$, ".") THEN ErrCode% = -1
               FullFile$ = FullFile$ + tmp1$ + "." + tmp$ + "\"
            ELSE
               FullFile$ = FullFile$ + LEFT$(tmp$, 8) + "\"
            END IF
         END IF
      END IF
   LOOP WHILE tmp% > 0 AND ErrCode% = 0

   IF ErrCode% < 0 THEN EXIT SUB

' ----- Fix Last and Decide -------------------------------------------------
' All we have left is a final piece, which might be either a file name or a
' subdirectory with an assumed "\*.*".  First we trim it, then we try to
' figure out whether it's a file or subdirectory.  If we got an invalid drive
' earlier, there's no way to tell the difference, so we'll assume it's a
' file name.

   t% = INSTR(File$, ".")
   IF t% THEN
      tmp1$ = LEFT$(LEFT$(File$, t% - 1), 8)
      tmp$ = MID$(File$, t% + 1, 3)
      IF INSTR(tmp1$, ".") OR INSTR(tmp$, ".") THEN
         ErrCode% = -1
      END IF
      File$ = tmp1$ + "." + tmp$
   ELSE
      File$ = LEFT$(File$, 8)
   END IF

   IF LEN(File$) THEN
      IF ErrCode% THEN
         FullFile$ = FullFile$ + File$
         IF t% = 0 THEN FullFile$ = FullFile$ + "." + Ext$
      ELSE
         IF SubExist2%(FullFile$ + File$) THEN
            FullFile$ = FullFile$ + File$ + "\*.*"
         ELSE
            IF LEN(FullFile$) > 3 THEN
               IF SubExist2%(LEFT$(FullFile$, LEN(FullFile$) - 1)) = 0 THEN
                  ErrCode% = 2
               END IF
            END IF
            FullFile$ = FullFile$ + File$
            IF t% = 0 THEN FullFile$ = FullFile$ + "." + Ext$
         END IF
      END IF
   ELSE
      IF LEN(FullFile$) > 3 THEN
         IF SubExist2%(LEFT$(FullFile$, LEN(FullFile$) - 1)) = 0 THEN
            ErrCode% = 2
         END IF
      END IF
      FullFile$ = FullFile$ + "*.*"
   END IF
END SUB
