program VirtualScreenExample;

uses col256,crt;

const xVRes=400; { resolution of the virtual screen                 }
      yVRes=300;

      xRes =320; { resolution of the CRT display (displayed screen) }
      yRes =240;
      ModeID=M320x240;

var x,y,xm,ym,i :integer;
    xVis,yVis   :integer;

begin
 EnterGraphMode(ModeID);
 SetVirtualScreen(xVRes,yVRes);

 { draw some stuff on the screen (page 0) }
 xm:=xMax div 2; ym:=yMax div 2;
 for x:=xMin to xMax do begin line_(xm,ym,x,yMin,i); inc(i); end;
 for y:=yMin to yMax do begin line_(xm,ym,xMax,y,i); inc(i); end;
 for x:=xMax downto xMin do begin line_(xm,ym,x,yMax,i); inc(i); end;
 for y:=yMax downto yMin do begin line_(xm,ym,xMin,y,i); inc(i); end;

 { draw some stuff on the screen (page 1) }
 SetActivePage(1); SetVisualPage(1);
 for i:=0 to xm do rectangle(xm-i,ym-i,xm+i,ym+i,i);
 SetActivePage(0);

 { pan around }
 i:=1;
 repeat
  case readkey of
   '4': dec(xVis,i);    { emulate cursor on numeric keypad }
   '6': inc(xVis,i);
   '8': dec(yVis,i);
   '2': inc(yVis,i);

   '7': begin dec(xVis,i); dec(yVis,i); end;
   '1': begin dec(xVis,i); inc(yVis,i); end;
   '3': begin inc(xVis,i); inc(yVis,i); end;
   '9': begin inc(xVis,i); dec(yVis,i); end;

   '0': SwitchPages;

   '+': inc(i);                              { 'accelerate' }
   '-': begin dec(i); if i<1 then i:=1; end; { 'decelerate' }

   #27: break;        { press ESC to exit program }
  end;
  if xVis>(xVRes-xRes) then xVis:=(xVRes-xRes); { do some clipping }
  if xVis<0            then xVis:=0;
  if yVis>(yVRes-yRes) then yVis:=(yVRes-yRes); { but it's not necessary }
  if yVis<0            then yVis:=0;

  SetVisualScreen(xVis,yVis);
 until false;

 ExitGraphMode;
end.