'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |   BASWIZ  (C) Copyright 1996 Charon Software, All Rights Reserved    |
'   |                                                                      |
'   |                      The BASIC Wizard's Library                      |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE SUB FOpen (File$, FMode$, BufferLen%, Handle%, ErrCode%)
   DECLARE FUNCTION FGetError% (BYVAL Handle%)
   DECLARE FUNCTION FGetSize& (BYVAL Handle%)
   DECLARE SUB FLocate (BYVAL Handle%, Posn&)
   DECLARE SUB FBlockRead (BYVAL Handle%, BYVAL Segm%, BYVAL Ofs%, BYVAL Bytes%)
   DECLARE FUNCTION FRead$ (BYVAL Handle%, BYVAL Bytes%)
   DECLARE SUB FClose (Handle%)
   DECLARE SUB GN0Color (BYVAL Foreground%, BYVAL Background%)
   DECLARE SUB GN0Plot (BYVAL X%, BYVAL Y%)

   DECLARE SUB PalBlk0 (BYVAL DSeg%, BYVAL DOfs%, BYVAL Colors%)

SUB GN0ShowBMP (File$, OrigX%, OrigY%, ErrCode%)
   ErrCode% = 0
   FOpen File$, "R", 0, Handle%, ErrCode%
   IF ErrCode% = 0 THEN
      Header$ = FRead$(Handle%, 54)
      ErrCode% = FGetError%(Handle%)
      IF ErrCode% = 0 THEN
         PWide& = CVL(MID$(Header$, 19, 4))
         PHigh& = CVL(MID$(Header$, 23, 4))
         BitPlanes% = CVI(MID$(Header$, 27, 2))
         ColorBits% = CVI(MID$(Header$, 29, 2))
         IF LEFT$(Header$, 2) <> "BM" THEN
            ErrCode% = -1    ' invalid BMP
         ELSEIF NOT (BitPlanes% = 1 AND ColorBits% = 8) THEN
            ErrCode% = -2    ' color format not supported
         ELSEIF CVL(MID$(Header$, 31, 4)) <> 0& THEN
            ErrCode% = -3    ' compression not supported
         ELSEIF CVL(MID$(Header$, 3, 4)) <> FGetSize&(Handle%) THEN
            ErrCode% = -4    ' incorrect file size
         ELSEIF PWide& < 1& OR PWide& > 360& OR PHigh& < 1& OR PHigh& > 480& THEN
            ErrCode% = -5    ' ludicrous image size
         END IF
         IF ErrCode% = 0 THEN
            PicWidth% = PWide&
            PicHeight% = PHigh&
            IF OrigX% + PicWidth% > 360 OR OrigY% + PicHeight% > 480 THEN
               ErrCode% = -6      ' invalid (X,Y) origin specified
            END IF
         END IF
      END IF

      '----- set the palette -----
      IF ErrCode% = 0 THEN
         DIM Pal&(0 TO 255)
         DSeg% = VARSEG(Pal&(0))
         DOfs% = VARPTR(Pal&(0))
         Bytes% = 1024            ' 256 * 4 is size of palette block
         FBlockRead Handle%, DSeg%, DOfs%, Bytes%
         ErrCode% = FGetError%(Handle%)
         IF ErrCode% = 0 THEN
            DSeg% = VARSEG(Pal&(0))
            DOfs% = VARPTR(Pal&(0))
            PalBlk0 DSeg%, DOfs%, 256
         END IF
      END IF

      '----- draw the picture -----
      IF ErrCode% = 0 THEN
         FLocate Handle%, CVL(MID$(Header$, 11, 4)) + 1&
         Bytes% = ((PicWidth% + 3) \ 4) * 4
         FOR y% = 0 TO PicHeight% - 1
            st$ = FRead$(Handle%, Bytes%)
            ErrCode% = FGetError%(Handle%)
            IF ErrCode% THEN EXIT FOR
            CurrY% = (PicHeight% - y%) + OrigY%
            FOR x% = 0 TO PicWidth% - 1
               GN0Color ASC(MID$(st$, x% + 1, 1)), 0
               GN0Plot x% + OrigX%, CurrY%
            NEXT
         NEXT
      END IF

      FClose Handle%
   END IF
END SUB
