'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |   BASWIZ  (C) Copyright 1996 Charon Software, All Rights Reserved    |
'   |                                                                      |
'   |                       The BASIC Wizard's Library                     |
'   |                                                                      |
'   +----------------------------------------------------------------------+
'
'  This demo provides a quick example for the BasWiz FAR STRING routines.
'  It is for use with QuickBasic only-- PDS and VB/DOS have their own far
'  string capabilities built into the language.

   DECLARE SUB FSDone ()
   DECLARE FUNCTION FSGet$ (BYVAL Handle%)
   DECLARE SUB FSInit (BYVAL UseEMS%)
   DECLARE SUB FSSet (Handle%, St$)

   DEFINT A-Z
   DIM HandleList(1 TO 100)

   UseEMS = (INSTR(COMMAND$, "/EMS") > 0)
   UseMain = (INSTR(COMMAND$, "/MAIN") > 0)

   IF NOT (UseMain OR UseEMS) THEN
      PRINT "FDEMO demonstrates the BasWiz far string handler by reading WDEMO.DAT into"
      PRINT "memory and then displaying it.  You may specify far memory or EMS:"
      PRINT "   FDEMO /MAIN      use main memory outside DGROUP"
      PRINT "   FDEMO /EMS       use EMS memory (if available)"
      END
   END IF

   CLS
   COLOR 0, 7
   PRINT "FDEMO reads WDEMO.DAT into ";
   IF UseEMS THEN PRINT "EMS"; ELSE PRINT "main";
   PRINT " memory and then displays it, as a"
   PRINT "demonstration of the BasWiz far string routines."
   PRINT
   COLOR 7, 0

   FSInit UseEMS                            ' initialize far string handler

   OPEN "WDEMO.DAT" FOR INPUT AS #1
   DO UNTIL EOF(1) OR ErrCode
      LINE INPUT#1, Text$
      Handle = 0
      FSSet Handle, Text$                   ' set far string
      IF Handle = 0 THEN
         ErrCode = -1                       ' set error code if out of memory
      ELSE
         MaxHandle = MaxHandle + 1          ' otherwise, save far str. handle
         HandleList(MaxHandle) = Handle
      END IF
   LOOP
   CLOSE

   IF ErrCode THEN
      PRINT "Sorry, there wasn't enough memory available."
      IF UseEMS THEN
         PRINT "Try using main memory instead of EMS."
      ELSE
         PRINT "Try using EMS instead of main memory."
      END IF
   ELSE
      FOR HandleNr = 1 TO MaxHandle
         PRINT FSGet(HandleList(HandleNr))
      NEXT
   END IF
