'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |   BASWIZ  (C) Copyright 1996 Charon Software, All Rights Reserved    |
'   |                                                                      |
'   |                      The BASIC Wizard's Library                      |
'   |                                                                      |
'   +----------------------------------------------------------------------+

' this routine is based on the midpoint ellipse algorithm as expressed in the
' book "Programmer's Guide to PC & PS/2 Video Displays", by Richard Wilton,
' Microsoft Press.

   DECLARE SUB GGVGetRes (MaxX%, MaxY%)
   DECLARE SUB GGVLine (BYVAL X1%, BYVAL Y1%, BYVAL X2%, BYVAL Y2%)
   DECLARE SUB GGVPlot (BYVAL X%, BYVAL Y%)

   DEFINT A-Z

SUB GGVEllipse (CenterX, CenterY, XRad, YRadius)
   GGVGetRes MaxX, MaxY
   XRadius = XRad * ((MaxX * 3!) / (MaxY * 4!))
   IF XRadius = 0 THEN
      GGVLine CenterX, CenterY - YRadius, CenterX, CenterY + YRadius
   ELSEIF YRadius = 0 THEN
      GGVLine CenterX - XRadius, CenterY, CenterX + XRadius, CenterY
   ELSE
      X = 0
      Y = YRadius
      A& = XRadius
      B& = YRadius
      D& = B& * B& - A& * A& * B& + (A& * A&) \ 4&
      DX& = 0&
      DY& = 2 * A& * A& * B&
      DO WHILE DX& < DY&
         GGVPlot CenterX + X, CenterY + Y
         GGVPlot CenterX + X, CenterY - Y
         GGVPlot CenterX - X, CenterY + Y
         GGVPlot CenterX - X, CenterY - Y
         IF D& > 0& THEN
            Y = Y - 1
            DY& = DY& - 2& * A& * A&
            D& = D& - DY&
         END IF
         X = X + 1
         DX& = DX& + 2& * B& * B&
         D& = D& + B& * B& + DX&
      LOOP
      D& = D& + (3& * (A& * A& - B& * B&) \ 2& - (DX& + DY&)) \ 2&
      DO WHILE Y >= 0
         GGVPlot CenterX + X, CenterY + Y
         GGVPlot CenterX + X, CenterY - Y
         GGVPlot CenterX - X, CenterY + Y
         GGVPlot CenterX - X, CenterY - Y
         IF D& < 0& THEN
            X = X + 1
            DX& = DX& + B& * B& * 2&
            D& = D& + DX&
         END IF
         Y = Y - 1
         DY& = DY& - A& * A& * 2&
         D& = D& + A& * A& - DY&
      LOOP
   END IF
END SUB
