
comment #
Ŀ
 MagniBrot ver 1.00                                                     
 Coded by Antti Niskanen of Wack-O Productions                          
 (C) 1995                                                               
                                                                        
 This program calculates a Mandelbrot fractal of dimensions 960x600     
 with 256 colors into memory and then displays the fractal in           
 MCGA (320x200x256) graphics shrinking the picture to one third in      
 both horizontal and vertical directions. A lens is then drawn on       
 the picture. Through the lens the fractal can be seen unshrinken,      
 thus creating an effect of 3x linear magnification for the lens.       
 The lens can be moved on the screen by moving the mouse, allowing      
 interesting areas of the fractal to be viewed more closely. I've       
 never seen this kind of approach before... I think it's rather c00l.   
                                                                        
 All complex values are stored whith the real and imaginary parts in    
 separate memory locations. 32 bits of memory are reserved for each     
 real part and each imaginary part. Since negative values are needed,   
 all numbers are stored as two's complements. All values are in fact    
 multiplied by 2^23 before storing into memory, so sufficient precision 
 is achieved. This gives MSB to the sign of the value, the 8 next bits  
 to the whole part, and the rest (23 bits) to the fractional part. This 
 means that when a number stored this way is squared, it must be then   
 divided by 2^23 so that the result is multiplied by 2^23 and not 2^46. 

#

        locals
        .model small
        .386
        .stack 1024

; 
;                           BUFFER SEGMENTS                           
; 

; Ŀ
;  Video buffer 
; 
f1      segment byte
frame1  db      64000 dup (?)
        ends

; Ŀ
;  Buffer to hold normal sized fractal 
; 
f2      segment byte
frame2  db      64000 dup (?)
        ends

; Ŀ
;  Buffers to hold oversized fractal - total 288000 bytes 
; 
bufs1   segment byte
buf1    db      57600 dup (?)
        ends

bufs2   segment byte
buf2    db      57600 dup (?)
        ends

bufs3   segment byte
buf3    db      57600 dup (?)
        ends

bufs4   segment byte
buf4    db      57600 dup (?)
        ends

bufs5   segment byte
buf5    db      57600 dup (?)
        ends

.data

; 
;                                 DATA                                
; 

; Ŀ
;  Messages 
; 
err_no_386      db 'Sorry, a 386 processor or better$'
err_no_VGA      db 'Sorry, a VGA graphics card$'
err_no_mouse    db 'Sorry, a mouse$'
err_is_needed   db ' is needed to run this program.'
                db 13d,10d
                db '$'
bye             db 'This program was coded by Antti Niskanen of '
                db 'Wack-O Productions.',13d,10d
                db '(C) 1995',13d,10d
                db 13d,10d
                db 'This program is freeware.',13d,10d
                db 13d,10d
                db 'If you want to contact the author, refer to the '
                db 'documentation',13d,10d
                db 'for my address.',13d,10d
                db 13d,10d
                db '$'
comp0           db 13d,10d
                db 'MagniBrot ver 1.00',13d,10d
                db 'Calculating fractal into memory. This may take '
                db 'several minutes.',13d,10d
                db 'Once complete, use your mouse to move the lens.',13d,10d
                db 'To return to DOS, press the ESC-key.',13d,10d,13d,10d
                db 'Completion 0%$'
comp20          db 08d,08d,'20%$'               ; 08d is a backspace!
comp40          db 08d,08d,08d,'40%$'
comp60          db 08d,08d,08d,'60%$'
comp80          db 08d,08d,08d,'80%$'

; Ŀ
;  Lens shape - how many pixels on each line. Height 70 lines. 
; 
halfheight      dw 35d     ; Height div. by 2. Must be word-size value.
lens    db      5d,10d,12d,15d,17d,18d,20d,21d,22d,23d,24d,25d,26d,27d
        db      28d,29d,29d,30d,30d,31d,31d,32d,32d,33d,33d,33d,33d,34d
        db      34d,34d,34d,34d,34d,34d,34d     ; top half
        db      34d,34d,34d,34d,34d,34d,34d,34d,33d,33d,33d,33d,32d,32d
        db      31d,31d,30d,30d,29d,29d,28d,27d,26d,25d,24d,23d,22d,21d
        db      20d,18d,17d,15d,12d,10d,5d     ; bottom half
        db      00      ; end signal

; Ŀ
;  Values for calculation of 'brot 
; 
zr      dd      ?       ; Re(Z)
zi      dd      ?       ; Im(Z)
cr      dd      ?       ; Re(C)
ci      dd      ?       ; Im(C)
maxiter dd      ?       ; Maximum number of iterations
xmin    dd      ?       ; \
xmax    dd      ?       ;  \ Coordinates of
ymin    dd      ?       ;  / whole picture
ymax    dd      ?       ; /
xstep   dd      ?       ; Coordinate step per pixel X-direction
ystep   dd      ?       ; Coordinate step per pixel Y-direction
xcount  dw      ?       ; Counter used by Mandelbrot routine
ycount  dw      ?       ; Counter used by Mandelbrot routine
xsize   dd      ?       ; Size of whole picture in pixels X-direction
ysize   dd      ?       ; Size of whole picture in pixels Y-direction
lines   dw      ?       ; How many lines should Mandelbrot routine calculate
points  dw      ?       ; How many points per line should be calculated
ystart  dd      ?       ; Where Y-coordinate should start in calculation

; Ŀ
;  Other values needed by program 
; 
vmode   db      ?       ; Video mode before execution
mx      dw      ?       ; Mouse X-coord
my      dw      ?       ; Mouse Y-coord

vgaseg  equ     0a000h

.code

; 
;                            MAIN PROGRAM                             
; 

main    proc

        mov     ax,@data
        mov     ds,ax

; Ŀ
;  Check system requirements: 386, VGA, mouse 
; 
        pushf                           ; Check processor is 386+.
        xor     ah,ah                   ; I don't know _how_ this works...
        push    ax
        popf
        pushf
        pop     ax
        and     ah,0f0h
        cmp     ah,0f0h
        je      no_386
        popf
        jmp     ye_386
no_386: popf
        mov     dx,offset err_no_386
        jmp     err_quit
ye_386: mov     ax,01a00h               ; Check graphics is VGA.
        int     10h                     ; I'm not sure if this works.
        cmp     al,1ah
        je      ye_VGA
        mov     dx,offset err_no_VGA
        jmp     err_quit
ye_VGA: xor     ax,ax                   ; Check mouse driver exists.
        int     33h                     ; This works.
        cmp     ax,0ffffh
        je      ye_mse
        mov     dx,offset err_no_mouse
        jmp     err_quit
ye_mse:

; Ŀ
;  Set up initial fractal parameters 
; 
        mov     eax,0ffh                ; Maximum iterations 255d
        mov     maxiter,eax
        mov     eax,0fee66667h          ; Coord. Left: -2.2 converted
        mov     xmin,eax
        mov     eax,00666666h           ; Coord. Right: 0.8 converted
        mov     xmax,eax
        mov     eax,0ff666667h          ; Coord. Top: -1.2 converted
        mov     ymin,eax
        mov     ystart,eax              ; Start Y at what coordinate
        mov     eax,00000000h           ; Coord. Bottom: 0.0 converted
        mov     ymax,eax
        mov     eax,960d                ; Size of picture in pixels, X
        mov     xsize,eax
        mov     eax,300d                ; Size of picture in pixels, Y
        mov     ysize,eax
        mov     ax,60d                  ; How many lines should be calculated
        mov     lines,ax
        mov     ax,960d                 ; How many points per line
        mov     points,ax

; Ŀ
;  Calculate oversized Mandelbrot fractal into memory 
; 
        cld
        mov     dx,offset comp0
        mov     ah,09h
        int     21h
        mov     ax,bufs1                ; Calculate first buffer
        call    DrawMandel

        mov     dx,offset comp20
        mov     ah,09h
        int     21h
        mov     ax,bufs2                ; Calculate second buffer
        call    DrawMandel

        mov     dx,offset comp40
        mov     ah,09h
        int     21h
        mov     ax,bufs3                ; And so on...
        call    DrawMandel

        mov     dx,offset comp60        ; Displaying status whenever
        mov     ah,09h                  ; it is convenient to do.
        int     21h
        mov     ax,bufs4
        call    DrawMandel

        mov     dx,offset comp80
        mov     ah,09h
        int     21h
        mov     ax,bufs5
        call    DrawMandel

; Ŀ
;  Shrink oversized Mandelbrot fractal into reserved buffer 
; 
        mov     ax,f2                   ; Pointer to destination buffer
        mov     es,ax
        xor     di,di
        mov     ax,bufs1                ; Shrink first buffer
        call    ShrinkBuffer
        mov     ax,bufs2                ; Shrink second buffer
        call    ShrinkBuffer
        mov     ax,bufs3                ; And so on.
        call    ShrinkBuffer
        mov     ax,bufs4
        call    ShrinkBuffer
        mov     ax,bufs5
        call    ShrinkBuffer

; Ŀ
;  Mirror top half of image in buffer into bottom half 
; 
        mov     ax,f2
        mov     ds,ax
        mov     es,ax
        xor     si,si                   ; Beginning of first line
        mov     di,63680d               ; Beginning of last line
        mov     cx,100d                 ; 100 lines to mirror
mirror: push    cx
        mov     cx,80d
        rep     movsd
        sub     di,640d                 ; Now at end of line. Back up 2 lines
        pop     cx
        loop    mirror

; Ŀ
;  Change video mode for 320x200x256 graphics, reset mouse 
; 
        mov     ax,@data                ; Store current video mode
        mov     ds,ax
        mov     ah,0fh
        int     10h
        mov     vmode,al
        xor     ah,ah                   ; New mode VGA 320x200x256
        mov     al,13h
        int     10h
        xor     ax,ax                   ; Reset mouse
        int     33h

; Ŀ
;  Display loop                       ; Surprisingly short...?
; 
again:  call    MagniGlass              ; Guess what this does
        mov     ah,01                   ; Check for keystroke
        int     16h
        jz      again
        xor     ah,ah                   ; Get the keystroke
        int     16h
        cmp     al,27d                  ; Is it ESC?
        jnz     again

; Ŀ
;  Clean up, say good-bye and quit to DOS 
; 
        mov     ax,@data                ; Return old video mode
        mov     ds,ax
        mov     ah,00h
        mov     al,vmode
        int     10h
        mov     dx,offset bye           ; End text
        mov     ah,09h
        int     21h
        mov     ah,4ch                  ; Quit to DOS
        int     21h

; Ŀ
;  Complete the error message and quit. 
; 
err_quit:
        mov     ah,09h
        int     21h
        mov     dx,offset err_is_needed
        mov     ah,09h
        int     21h
        mov     ah,4ch
        int     21h

endp


; 
;                        MANDELBROT ROUTINE                           
; 
; Edge coordinates of whole should be in xmin, xmax, ymin & ymax.
; Size in pixels of whole should be xsize & ysize.
; Size of area to be calculated now should be in lines & points.
; Segment to store picture into should be in AX.
; When drawing directly to screen, xsize and points should be 320d,
; while ysize and lines should be 200d. AX should point to the
; beginning of video memory (A000h:0000h).
; NOTE: ES-register will not be returned to original state after
;       procedure is finished.
DrawMandel proc near
        mov     es,ax                   ; Nothing interesting here.
        xor     di,di
        mov     eax,xmax                ; Calculate xstep
        sub     eax,xmin
        xor     edx,edx
        mov     ebx,xsize
        idiv    ebx
        mov     xstep,eax
        mov     eax,ymax                ; Calculate ystep
        sub     eax,ymin
        xor     edx,edx
        mov     ebx,ysize
        idiv    ebx
        mov     ystep,eax
        mov     ax,lines
        mov     ycount,ax
        mov     eax,ystart
        mov     ci,eax
loopy:  mov     ax,points
        mov     xcount,ax
        mov     eax,xmin
        mov     cr,eax
loopx:  xor     ecx,ecx                 ; Initialize counter and Z-value
        mov     zr,ecx
        mov     zi,ecx
top:    push    ecx                     ; Here begins the interesting part!
        push    zr
        mov     eax,zi                  ; Im(Z)^2
        imul    eax
        push    edx
        push    eax
        mov     ecx,edx
        mov     ebx,eax
        mov     eax,zr                  ; Re(Z)^2
        imul    eax
        push    edx
        push    eax
        add     eax,ebx                 ; Is Re(Z)^2+Im(Z)^2 > 4 ?
        adc     edx,ecx
        shrd    eax,edx,23d             ; Adjust (div. by 2^23)
        cmp     eax,2000000h
        ja      bail
        pop     eax                     ; Re(Z)^2-Im(Z)^2+Re(C) --> Re(Z)
        pop     edx
        pop     ebx
        pop     ecx
        sub     eax,ebx
        sbb     edx,ecx
        shrd    eax,edx,23d             ; Adjust
        add     eax,cr
        mov     zr,eax
        pop     eax                     ; 2*Re(Z)*Im(Z)+Im(C) --> Im(Z)
        imul    zi
        shrd    eax,edx,22d             ; Adjust and multiply by 2
        add     eax,ci
        mov     zi,eax
        pop     ecx
        inc     ecx
        cmp     ecx,maxiter
        jae     endung
        jmp     top
endung: xor     eax,eax
        jmp     slut
bail:   pop     eax                     ; Bailout. Stack must be balanced.
        pop     eax                     ; Arrrrrrrgh!
        pop     eax
        pop     eax
        pop     eax
        pop     eax                     ; Last item in stack was the counter
slut:   stosb
        mov     eax,xstep
        add     cr,eax
        dec     xcount
        jnz     loopx
        mov     eax,ystep
        add     ci,eax
        dec     ycount
        jnz     loopy
        mov     eax,ci                  ; Store Y end value in ystart
        mov     ystart,eax              ; for continuing next buffer where
        ret                             ; this one left off
endp


; 
;                      SHRINK PICTURE ROUTINE                         
; 
; Segment of buffer to shrink should be in AX. ES:DI should
; point to where the new image will be stored.
; NOTE: ES will not be returned to original state after routine
;       has finished.
ShrinkBuffer proc near
        mov     ds,ax                   ; Nothing interesting here.
        xor     si,si
        mov     cx,20d
shrnk1: push    cx
        add     si,960d
        mov     cx,320d
shrnk2: inc     si
        movsb
        inc     si
        loop    shrnk2
        add     si,960d
        pop     cx
        loop    shrnk1
        ret
endp


; 
;               DRAW MAGNIFYING GLASS AND SHOW FRACTAL                
; 
MagniGlass proc near
; Ŀ
;  Copy fractal in buffer into video buffer 
; 
        cld
        mov     ax,f2                   ; Yep, the small fractal.
        mov     ds,ax
        mov     ax,f1                   ; Video buffer
        mov     es,ax
        xor     si,si
        xor     di,di
        mov     cx,16000d
        rep     movsd

; Ŀ
;  Get and adjust mouse position 
; 
        mov     ax,@data
        mov     ds,ax
        mov     ax,03h
        int     33h
        mov     my,dx
        shr     cx,1            ; For some reason the mouse x-coord is
        mov     mx,cx           ; multiplied by two in 320x200 graph mode.

; Ŀ
;  Now copy unshrinken pixels from BIG picture to form lens 
; 
        mov     bx,offset lens
        xor     si,si
NextLine:
        mov     cl,[bx+si]
        xor     ch,ch
        cmp     cl,00                   ; Finish signal?
        je      LensFinished
        mov     ax,my
        sub     ax,halfheight
        add     ax,si                   ; Now AX contains row (0-199)
        cmp     ax,1000d                ; If it's negative, then it's
        jbe     NotOverTop              ; certainly over 1000d (2's compl.)
        inc     si
        jmp     NextLine
NotOverTop:
        cmp     ax,199d                 ; Reached screen bottom yet?
        ja      LensFinished
        mov     dx,320d
        mul     dx                      ; AX has offset of start of row
        mov     dx,cx                   ; Somhow figure out if over left edge
        dec     dx
        cmp     dx,mx
        jbe     NoLeftTruncate
        mov     cx,mx                   ; Do this if it is
        inc     cx
        jmp     DoLensLeft
NoLeftTruncate:
        add     ax,mx                   ; Do this if not
        inc     ax
        sub     ax,cx
DoLensLeft:
        mov     di,ax
; Ŀ
;  This is the entiety that calulates FROM WHERE in the big fractal 
;  buffers the pixels to be copied into the lens must come from.    
;                                                                   
        mov     ax,my
        add     ax,ax
        add     ax,my                   ; AX=mouse y-coord * 3
        sub     ax,halfheight
        add     ax,si                   ; Offset from mouse hot spot * 1 only!
        cmp     ax,299d                 ; Mirror if in bottom half of screen.
        jbe     InTopHalf
        neg     ax
        add     ax,599d
InTopHalf:
        mov     dl,60d                  ; Which buffer segment is this
        div     dl                      ; part of the BIG fractal in?
        mov     dx,bufs1                ; Each buffer segment contains
        cmp     al,0                    ; 60 lines (unshrinken).
        jz      segfound
        mov     dx,bufs2
        cmp     al,1
        jz      segfound
        mov     dx,bufs3
        cmp     al,2
        jz      segfound
        mov     dx,bufs4
        cmp     al,3
        jz      segfound
        mov     dx,bufs5
segfound:                               ; Ok, got that.
        push    ds                      ; These segments are needed later.
        push    dx
        push    ds
        push    dx
        mov     al,ah
        xor     ah,ah
        mov     dx,960d                 ; Now for the offset of the beginning
        mul     dx                      ; of the line of the lens being drawn.
        add     ax,mx                   ; Mouse x-coord * 3.
        add     ax,mx
        add     ax,mx
        inc     ax
        sub     ax,cx                   ; Offset from mouse hot spot * 1 only!
        mov     dx,si                   ; Old SI must be restored later on
        mov     si,ax
        pop     ds
        rep     movsb
        xchg    si,dx                   ; ...but new SI must not be lost either
        pop     ds
;                                                                   
; 
DoLensRight:
        mov     cl,[bx+si]              ; Same for right edge
        xor     ch,ch
        mov     ax,mx
        add     ax,cx
        cmp     ax,319d
        jbe     NoRightTruncate
        mov     cx,319d                 ; Just simpler to accomplish
        sub     cx,mx
NoRightTruncate:
; Ŀ
;  This is also part of it. DX must not change between this part    
;  and the previous part of this magic entiety. (else new SI lost.) 
;                                                                   
        xchg    si,dx
        pop     ds
        rep     movsb
        xchg    si,dx
        pop     ds
;                                                                   
; 
        inc     si
        jmp     NextLine
LensFinished:
; Was there really no simpler way to do this...?

; Ŀ
;  Lens is finished. Copy whole thing into video memory and return 
; 
        cld
        mov     ax,f1
        mov     ds,ax
        mov     ax,vgaseg
        mov     es,ax
        xor     si,si
        xor     di,di
        mov     cx,16000d
        rep     movsd
        mov     ax,@data
        mov     ds,ax
        ret
endp

end

