//
//===========================================================================
//
// SoundSystem4 small player example
//
// Written for Borland C 3.1 & Tasm 3.1
//
// (pd)1995 by the Frontman of Crew242
//
//
// .model MEDIUM
//
//===========================================================================
//
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
typedef struct pblock
{	int baseport;
	char dma_number;
	char irq_number;
	unsigned int samplerate;
	char intern_type;
	char irq_type;
	char start_pos;
	char loop_pos;
	char song_mod;
	unsigned char master_vol;
	unsigned char music_vol;
	unsigned char fx_vol;
};
//
//
// MOD Function library
//
extern int far autodetect(struct pblock *paramblock);
//
// Return: player = 0 nothing found
//		    1 SB/SBPro   (selection within SS3.CFG or param-block)
//                  2 SB16/AWE32 (no difference in this version)
//                  3 PAS+/16
//                  4 GUS/GUS MAX
//
//         paramblock filled
//
extern int far config_init(int player, int code, struct pblock *paramblock);
//
// Input: player = 1 SB/SBPro   (selection within SS3.CFG or param-block)
//                 2 SB16/AWE32 (no difference in this version)
//                 3 PAS+/16
//                 4 GUS/GUS MAX
//
//        code  <> 0xc242
//
//        paramblock = any pointer to a pblock
//
// Return: carry-flag = 0 function completed properly
//                      1 function aborted after error
//
//
// If you prefer a parameter block instead of SS3.CFG,
//
// set code = 0xc242 and paramblock pointing to a struct like:
/*
; pblock:+ 0 int 		BASE PORT	  210H-280H, 388H, ETC.
;        + 2 char		DMA NUMBER	  0-7
;        + 3 char		IRQ NUMBER	  0-15
;	 + 4 unsigned int	SAMPLE RATE	  10000-44100
;        + 6 char		INTERNAL TYPE     0,1,2,3,... (if necessary)
;	 + 7 char		INTERRUPT TYPE   +0,1 (realtime clock,timer)
;                               INTERRUPT CHAIN  +0,2 (don't chain,chain irq)
;        + 8 char		STARTING POSITION 	0-127
;        + 9 char 		LOOP POSITION		0-127,128
;        +10 char		SONG MODUS		0-3
;        +11 unsigned char	START MASTER VOLUME 	0-255
;	 +12 unsigned char	START MUSIC VOLUME	0-255
;        +13 unsigned char	START FX VOLUME     	0-255
*/
//
extern int far load_mod(int player, char *filename);
//
// Input: filename = pointer to path/filename,0 as required for dos
//
// (only new inputs and returns, repeated params same like above)
//
extern int far play_music(int player);
extern int far stop_music(int player);
extern int far end_music(int player);
extern int far load_sample(int player, char *filename, int amiga_pc, int *handle);
//
// Input: amiga_pc = 0x00 sample is in signed format (Amiga, -128 to 127)
//                   0x80 sample is in unsigned format (PC, 0 to 255)
//
// Return: handle = handle of the sample for use with play_sample
//                  similar to the DOS handle for files
//
extern int far play_sample(int player, int handle, int freq_in_hz, int panning);
//
// Input: freq_in_hz = play rate of the sample in Hertz (1/s)
//
//        panning = balance from left (0) to right (255)
//
extern int far end_sample(int player);
extern int far set_samplerate(int player, int freq_in_hz);
//
// Input: freq_in_hz = 10000-22222 for SB/SBPro
//                     10000-44100 for SB16/AWE32
//                     10000-44100 for PAS+/16
//                     no effect   on  GUS
//
extern int far get_volume(int player, int *master_vol, int *music_vol, int *fx_vol);
//
// Return: master_vol = master volume from low (0) to high (255)
//
//         music_vol = music volume from low (0) to high (255)
//
//         fx_vol = fx volume from low (0) to high (255)
//
extern int far set_volume(int player, int master_vol, int music_vol, int fx_vol);
//
// Input: same as above but as input
//
extern int far set_songloop(int player, int loop_position);
//
// Input: loop_position = 0-127 pattern position for song restart
//                        128   no restart
//
extern int far get_songposition(int player, int *song_position);
//
// Return: song_position = 0-127 actual song position
//
extern int far set_songposition(int player, int song_position);
//
// Input: song_position = 0-127 immediate position change and pattern restart
//                        takes only effect after song start because
//                        play_music starts always at position 0
//
extern int far get_songmod(int player, int *song_modus);
//
// Return: song_modus = 0 music and fx
//                      1 music only
//                      2 fx only
//                      3 no sound
//
extern int far set_songmod(int player, int song_modus);
//
// Input: same as above but as input
//
//===========================================================================
//
//
// CD Function library
//
extern int far cd_device_init(void);
//
// Return: carry-flag = 0 function completed properly
//                      1 function aborted after error
//
extern int far cd_get_toc(void);
//
// Gets table of contents for a new CD
//
extern int far cd_play_track(int track, int repeat, int irq, int chain);
//
// Input: track = 0-99 CD track to play
//        repeat = 0 no repeat
//		   1 repeat
//        irq   = 0/1 real time clock irq/timer irq
//        chain = 0/1 don't chain/chain IRQ
//
extern int far cd_stop_track(void);
extern int far cd_pause_track(void);
extern int far cd_resume_track(void);
extern int far cd_seek_track(int seek);
//
// Input: seek = -128 to 127 seconds to seek back- or forward
//
extern int far cd_info_track(void);
//
// Return: carry-flag = 0 function completed properly
//                      1 function aborted after error
//
extern int far cd_get_devstat(void);
//
// No function yet
//
extern int far cd_get_medchange(void);
//
// No function yet
//
//===========================================================================
//
//
// FLC Function library
//
extern int far flc_device_init(int player, int *fxlist, int video);
//
//        player  = number of player that should be used for sound fx
//        *fxlist = pointer to an int list that holds sound fx informations
//                  like (frame number),(fx handle),(frequence in Hz),....,-1
//									3 of the described ints are for one sound fx in the
//                  animation and a -1 determines the end of the list
//        video   = 0/1 don't change/change video mode
//
extern int far flc_device_end(int video);
//
//        video = 0/1 don't change/change video mode
//
extern int far flc_play(char *filename, int speed, int loops, int fx, int irq, int chain);
//
// Input: filename = pointer to path/filename,0 as required for dos
//        speed    = 1-255 1 is fastest (70 Hz), 2 is slower (35 Hz), etc.
//        loops    = 1-255 number of repeat loops
//        fx       = 0/1 without/with sound fx
//        irq      = 0/1 real time clock irq/timer irq
//        chain    = 0/1 don't chain/chain IRQ
//
//===========================================================================
//
// Very small sample of use
//
main(int argc, char *argv[])
{	int a,b= 1,code= 0, player= 0, speed= 4, fxlist[31]={-1};
	struct pblock pb;
	printf("\nSoundSystemSource4 (pd)1995 by the Frontman of Crew242\n\n");
	printf("Usage: CPLAY <# of player> <filename.mod | track # | filename.fl?> [flc speed]\n");
	printf("              0 Autodetect\n");
	printf("              1 SB/SBPro\n");
	printf("              2 SB16\n");
	printf("              3 PAS+/16\n");
	printf("              4 GUS\n");
	printf("              8 CD-Player\n");
	printf("              9 FLC-Player\n\n");
	printf("Look out for the game 'Future Dimension'!\n");
	printf("The greatest shoot'em up ever on PC.\n");
	printf("Of course another high quality product of Crew242.\n\n");
	if ((argc==2) || (argc>=3 && argv[1][0]>='0' && argv[1][0]<='9'))
	{	if (argc>=3)
		{	player= (unsigned)(int)(argv[1][0]) & 15;
			b= 2;
		}
		if (player==0)
		{	player= autodetect(&pb);
			code= 0xc242;
		}
		if (player>0 && player<5)
		{	a= config_init(player,code,&pb);
			a= load_mod(player, argv[b]);
			if (a==0)
			{	a= play_music(player);
				if (a==0)
				{	printf("Hit a key to stop\n");
					while(!kbhit());
					getch();
					stop_music(player);
					end_music(player);
				}
			}
		}
		if (player==8)
		{	a= cd_device_init();
			if (a==0)
			{	cd_play_track(atoi(argv[2]),1,0,0);
				printf("Hit a key to stop\n");
				while(!kbhit());
				getch();
				cd_stop_track();
			}
		}
		if (player==9)
		{	if (argc>3) speed=atoi(argv[3]);
			flc_device_init(0,fxlist,1);
			flc_play(argv[2], speed, 1, 0, 0, 0);
			flc_device_end(1);
		}
	}
	else a=0;
	return a;
}
//
//===========================================================================
//