; PMODE example program #0.
; Load up a mouse driver, uncomment the mouse calls, compile, and run.
; When run, use the left mouse button to draw. Any key exits.

        .386p
        jumps
code16  segment para public use16
        assume cs:code16, ds:code16

;
rmr:                                    ; real mode mouse callback
        nop
        mov byte ptr rmr,0cbh           ; NOP to RETF, dont want reentry here
                                        ;  this is real mode, CS write allowed
        push ds edx
        push cs
        pop ds
        push ds:v86r_bx                 ; save these, remember this is an IRQ
                                        ;  callback
        push ds:v86r_ecx
        push ds:v86r_edx
        mov ds:v86r_bx,bx
        mov ds:v86r_cx,cx
        mov ds:v86r_dx,dx
        mov edx,offset pmr              ; call protected mode mouse handler
        int 32h
        pop ds:v86r_edx
        pop ds:v86r_ecx
        pop ds:v86r_bx
        pop edx ds
        mov byte ptr cs:rmr,90h         ; RETF back to NOP
        retf

code16  ends

code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include file.inc

public  _main

;
; DATA
;
systypestr      db      'raw ','XMS ','VCPI','DPMI'
filename        db      'pmode.asm',0

;
; CODE
;

;
pmr:                                    ; protected mode mouse handler
        test bx,1                       ; skip if left button not pressed
        jz _ret
        push ax                         ; save this, (V86_AX wasn't saved in
                                        ;  real mode)
        mov al,33h
        mov v86r_ax,2                   ; don't have to save this since it is
                                        ;  already stored in AX on the stack,
                                        ;  and will be restored to that on RET
        int 33h                         ; hide mouse cursor
        movzx ecx,cx                    ; calculate and plot box
        shr ecx,3
        movzx edx,dx
        shr edx,3
        lea edx,[edx*4+edx]
        shl edx,5
        lea edx,[edx+ecx*2]
        mov word ptr gs:[0b8000h+edx],7dbh
        mov al,33h                      ; restore mouse
        mov v86r_ax,1
        int 33h
        pop ax
        ret                             ; back to real mode
;
setupmouse:                             ; mouse on, and setup callback
        mov al,33h
        mov v86r_ax,0
        int 33h
        mov v86r_ax,1
        int 33h
        mov v86r_ax,0ch
        mov v86r_cx,3
        mov v86r_dx,offset rmr
        mov v86r_es,code16
        int 33h
        ret
;
resetmouse:                             ; bye-bye mousey
        mov al,33h
        mov v86r_ax,0
        int 33h
        ret
;
putcrap:                                ; put some crap to screen with attr AH
        lodsb
        stosw
        loop putcrap
        ret

;
_main:
        sti
        @rlp edi,0b8000h                ; get relative pointer to text screen
        mov ecx,(80*25)/2               ;  and fill with something
        mov eax,8b008b0h
        rep stosd

        @rlp edi,0b8000h+162            ; put type of system
        movzx esi,_sysbyte0
        and esi,3                       ; all the other bits will be 0, but
        lea esi,[esi*4+systypestr]      ;  what the hell
        mov ecx,4
        mov ah,7
        call putcrap

        mov eax,12*80                   ; allocate low mem buffer for l8r
        call _getlomem
        jc filedone                     ; skip if not enough mem for buffer
        mov ebp,eax
        mov esi,eax
        mov eax,offset filename         ; convert filename offset to seg:off
        add eax,_code32a                ;  for DOS
        shld ebx,eax,28
        and ax,0fh
        mov v86r_ds,bx
        mov v86r_dx,ax
        mov v86r_ax,3d00h               ; open file
        mov al,21h
        int 33h
        jc filedone                     ; skip if error
        mov ax,v86r_ax                  ; transfer handle for read
        mov v86r_bx,ax
        add ebp,_code32a                ; adjust 32bit offset to real addx
        shld ebx,ebp,28                 ; buffer to real mode seg:off
        and bp,0fh
        mov v86r_ds,bx
        mov v86r_dx,bp
        mov v86r_cx,12*80
        mov v86r_ah,3fh                 ; read into low mem buffer
        mov al,21h
        int 33h
        mov v86r_ah,3eh                 ; close file
        int 33h
        @rlp edi,0b8000h+(13*160)
        mov ecx,12*80
        mov ah,8                        ; put to low half of screen
        call putcrap
filedone:

;       call setupmouse                 ; uncomment this if you want mousey

        mov v86r_ah,0                   ; wait for a key using BIOS
        mov al,16h
        int 33h

;       call resetmouse                 ; uncomment this if you want mousey

        jmp _exit


code32  ends
        end

