 
    /* ===== SCREEN RESOLUTIONS ===== */
 
#DEFINE Mode_320x200  0
#DEFINE Mode_320x400  1
#DEFINE Mode_360x200  2
#DEFINE Mode_360x400  3
#DEFINE Mode_320x240  4
#DEFINE Mode_320x480  5
#DEFINE Mode_360x240  6
#DEFINE Mode_360x480  7
 
    /* ===== MODE X SETUP ROUTINES ===== */
 
int far pascal SET_VGA_MODEX (int Mode, int MaxXpos, int MaxYpos, int Pages);
int far pascal SET_MODEX (int Mode);
 
    /* ===== BASIC GRAPHICS PRIMITIVES ===== */
 
void far pascal CLEAR_VGA_SCREEN (int Color);
void far pascal SET_POINT (int Xpos, int Ypos, int Color);
int  far pascal READ_POINT (int Xpos, int Ypos);
void far pascal FILL_BLOCK (int Xpos1, int Ypos1, int Xpos2, int Ypos2,
                            int Color);
void far pascal DRAW_LINE (int Xpos1, int Ypos1, int Xpos2, int Ypos2,
                           int Color);
 
    /* ===== DAC COLOR REGISTER ROUTINES ===== */
 
void far pascal SET_DAC_REGISTER (int RegNo, int Red, int Green, int Blue);
void far pascal GET_DAC_REGISTER (int RegNo, int* Red, int* Green, int* Blue);
 
    /* ===== PAGE FLIPPING AND SCROLLING ROUTINES ===== */
 
void far pascal SET_ACTIVE_PAGE (int PageNo);
int  far pascal GET_ACTIVE_PAGE ();
void far pascal SET_DISPLAY_PAGE (int PageNo);
int  far pascal GET_DISPLAY_PAGE ();
void far pascal SET_WINDOW (int DisplayPage, int XOffset, int YOffset);
int  far pascal GET_X_OFFSET ();
int  far pascal GET_Y_OFFSET ();
void far pascal SYNC_DISPLAY ();
 
    /* ===== TEXT DISPLAY ROUTINES ===== */
 
void far pascal GPRINTC (int CharNum, int Xpos, int Ypos, int ColorF,
                         int ColorB);
void far pascal TGPRINTC (int CharNum, int Xpos, int Ypos, int ColorF);
void far pascal PRINT_STR (far char* Text, int MaxLen, int Xpos, int Ypos,
                           int ColorF, int ColorB);
void far pascal TPRINT_STR (far char* Text, int MaxLen, int Xpos, int Ypos,
                            int ColorF);
void far pascal SET_DISPLAY_FONT (far char* FontData, int FontNumber);
 
    /* ===== BITMAP (SPRITE) DISPLAY ROUTINES ===== */
 
void far pascal DRAW_BITMAP (far char* Image, int Xpos, int Ypos,
                             int Width, int Height);
void far pascal TDRAW_BITMAP (far char* Image, int Xpos, int Ypos,
                              int Width, int Height);
 
    /* ==== VIDEO MEMORY to VIDEO MEMORY COPY ROUTINES ===== */
 
void far pascal COPY_PAGE (int SourcePage, int DestPage);
void far pascal COPY_BITMAP (int SourcePage, int X1, int Y1, int X2, int Y2,
                             int DestPage, int DestX1, int DestY1);
 
