; Unsigned multiply of two 64-bit numbers
;
; Tim Victor, January 5, 1993
;
; Callable from C as follows:
; int ExtMul(src, dest);
;   always return 0
;
        .model  small
        .code
        public _ExtMul
_ExtMul proc near

        push bp         ; save caller's stack frame
        mov  bp,sp      ; address stack frame of this call
        sub  sp,8       ; store temp result on stack
        push si
        push di

        mov  si,[bp+4]          ; source address
        mov  di,[bp+6]          ; dest address

; multiply dest[0] * src
        mov  ax,[si]
        mul  word ptr [di]
        mov  [bp-8],ax
        mov  bx,dx

        mov  ax,[si+2]
        mul  word ptr [di]
        add  ax,bx
        adc  dx,0
        mov  [bp-6],ax
        mov  bx,dx

        mov  ax,[si+4]
        mul  word ptr [di]
        add  ax,bx
        adc  dx,0
        mov  [bp-4],ax
        mov  bx,dx

        mov  ax,[si+6]
        mul  word ptr [di]
        add  ax,bx
        adc  dx,0
        mov  [bp-2],ax

; result += dest[1] * src
        mov  ax,[si]
        mul  word ptr [di+2]
        add  ax,[bp-6]
        adc  dx,0
        mov  [bp-6],ax
        mov  bx,dx

        mov  ax,[si+2]
        mul  word ptr [di+2]
        add  ax,bx
        adc  dx,0
        add  ax,[bp-4]
        adc  dx,0
        mov  [bp-4],ax
        mov  bx,dx

        mov  ax,[si+4]
        mul  word ptr [di+2]
        add  ax,bx
        adc  dx,0
        add  ax,[bp-2]
        adc  dx,0
        mov  [bp-2],ax

; result += dest[2] * src
        mov  ax,[si]
        mul  word ptr [di+4]
        add  ax,[bp-4]
        adc  dx,0
        mov  [bp-4],ax
        mov  bx,dx

        mov  ax,[si+2]
        mul  word ptr [di+4]
        add  ax,bx
        adc  dx,0
        add  ax,[bp-2]
        adc  dx,0
        mov  [bp-2],ax

; result += dest[3] * src
        mov  ax,[si]
        mul  word ptr [di+6]
        add  ax,[bp-2]
        adc  dx,0
        mov  [bp-2],ax

; copy result to dest
        mov  ax,[bp-8]
        mov  [di],ax
        mov  ax,[bp-6]
        mov  [di+2],ax
        mov  ax,[bp-4]
        mov  [di+4],ax
        mov  ax,[bp-2]
        mov  [di+6],ax

        sub  ax,ax      ; return 0

        pop  di
        pop  si
        mov  sp,bp
        pop  bp

        ret

_ExtMul endp
        end

