/*
    divtest.c: time and test 64-bit extended precision arithmetic library

    This program generates 1024 64-bit unsigned numbers, then uses them to
    compare two different divide algorithms. On a generic 12MHz 286 clone,
    the results are:

    ExtDivB: average time = 4.292582e-04 seconds
    ExtDiv: average time = 4.829155e-05 seconds

    Note: If preprocessor symbol CHECK_RES is uncommented, the results of
    the division ops will be checked with a multiply, an add, and a compare.
    It should be commented out for time tests.

    Written and tested with Borland Turbo C++ 1.0, small model. Link with
    "extmath.lib".

    Tim Victor, January 7, 1993
*/


#include <time.h>
#include "extmath.h"

extnum_t dividend[1024], divisor[1024];

#define ITERATIONS 10240
//#define CHECK_RES

main()
{
    int i, j, x, res;
    extnum_t quotient, remainder;
    clock_t start, end;

    /* initialize values */
    for (j=0; j<1024; ++j) {
        for (i=0; i<4; ++i) {
            dividend[j][i] = rand();
            divisor[j][i] = rand();
        }
    }

    /* do ops w/ obvious (slow) divide algorithm */
    start = clock();
    x = 0;
    for (j=0; j<ITERATIONS; ++j) {
#ifdef CHECK_RES
        res = ExtDivB(dividend[x], divisor[x], quotient, remainder);
        if (res)
            printf("%d, Divide By Zero error\n", j);
        else {
            ExtMul(divisor[x], quotient);
            ExtAdd(remainder, quotient);
            if (ExtCmp(dividend[x], quotient))
                printf("%d, Unequal result\n", j);
        }
#else
        ExtDivB(dividend[x], divisor[x], quotient, remainder);
#endif
        if (++x >= 1024)
            x = 0;
    }
    end = clock();
    printf("ExtDivB: average time = %e seconds\n",
        (end-start)/(ITERATIONS*CLK_TCK));


    /* do ops w/ bit-matching divide algorithm */
    start = clock();
    x = 0;
    for (j=0; j<ITERATIONS; ++j) {
#ifdef CHECK_RES
        res = ExtDiv(dividend[x], divisor[x], quotient, remainder);
        if (res)
            printf("%d, Divide By Zero error\n", j);
        else {
            ExtMul(divisor[x], quotient);
            ExtAdd(remainder, quotient);
            if (ExtCmp(dividend[x], quotient))
                printf("%d, Unequal result\n", j);
        }
#else
        ExtDiv(dividend[x], divisor[x], quotient, remainder);
#endif
        if (++x >= 1024)
            x = 0;
    }
    end = clock();
    printf("ExtDiv: average time = %e seconds\n",
        (end-start)/(ITERATIONS*CLK_TCK));

    return(0);
}
