January 7, 1993

This is a library of C-callable assembler subroutines to do 64-bit
unsigned math. The header file, extmath.h, typedef's an 8-byte data
type, "extnum_t", which the functions all use. All the functions are
two-operand operations, leaving the result in the second ("dest")
argument, excepting ExtNeg(), which is a unary operation; ExtCmp(),
which returns a signed integer as its result; and the two divide
routines, ExtDiv() and ExtDivB(), which take four arguments (divisor,
dividend, quotient, remainder).

All the code has been assembled and tested with Borland Turbo Assembler
and Turbo C++ 1.0, small memory model, on a 12MHz 286 AT-clone. Only
8088-compatible opcodes are used.

The routines are all original code, and are released to the public
domain. You may use them however you wish. If you use them and you
feel moved to credit the author, I'll appreciate it.

I'm pretty new to Intel assembler programming, so if you have any
comments, corrections or improvements, I'd love to see them.

Tim Victor                              Compuserve: 766366,2527
                                        Internet: timv@well.sf.ca.us


You should have these files:

readme.pls      This file.

divtest.c       Programming example, comparing the speed of the two
                divide algorithms on an array of random numbers.

divtest.exe     Executable version of example.

divtest.rsp     Turbo Link response file for divtest.c. (tlink @divtest.rsp)
                It's probably specific to Turbo C++ version 1.0, but using it
                with later versions should just mean changing some pathnames.

extmath.h       C header file. Defines 64-bit int type (extnum_t), declares
                all the assembler functions.

extmath.lib     Object library containing 64-bit math routines.

extadd.s        Assembler source for ExtAdd(), 64-bit unsigned add.

extcmp.s        Assembler source for ExtCmp(), 64-bit unsigned compare.

extdiva.s       Assembler source for ExtDiv(), 64-bit unsigned divide.

extdivb.s       Assembler source for ExtDivB(), a simpler, shorter, 64-bit
                unsigned divide. About an order of magnitude slower than
                ExtDiv() for the data set in divtest.c.

extdup.s        Assembler source for ExtDup(), 64-bit unsigned copy.

extmul.s        Assembler source for ExtMul(), 64-bit unsigned multiply.

extneg.s        Assembler source for ExtNeg(), 64-bit unsigned 2's complement.

extsub.s        Assembler source for ExtSub(), 64-bit unsigned subtract.
    
