;****************************************************************************
; Filename: PORTS.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.02.09
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int outp(unsigned portid, int value);
;    Input: Eax = port address
;               Edx = value
;   Output: value send to port.
;  Comment: Sends a byte value to I/O port.
;****************************************************************************
; Function: unsigned outpw(unsigned portid, unsigned value);
;    Input: Eax = port address
;               Edx = value
;   Output: value send to port.
;  Comment: Sends a word value to I/O port.
;****************************************************************************
; Function: int inp(unsigned portid);
;    Input: Eax = port address
;   Output: value returned from port.
;  Comment: reads a byte value from I/O port.
;****************************************************************************
; Function: unsigned inpw(unsigned portid);
;    Input: Eax = port address
;   Output: value returned from port.
;  Comment: reads a word value from I/O port.
;****************************************************************************

        Include STDDEF.INC

        Codeseg


Proc    outp ,2
        xchg Eax,Edx
        out Dx,Al
        ret
Endp

Proc    outpw ,2
        xchg Eax,Edx
        out Dx,Ax
        ret
Endp

Proc    inp ,1
        Mov Edx,Eax
        Xor Eax,Eax
        in Al,Dx
        ret
Endp

Proc    inpw ,1
        Mov Edx,Eax
        Xor Eax,Eax
        in Ax,Dx
        ret
Endp


        End
