;**************************************************************************
;  EG4.ASM
;
;  This example program will display all files in the current directory
;
;
; DOS32 assembly language example program
;**************************************************************************
.386
.model  flat
.stack 200h
.code

ASCIIZ_path     db  '*.*',0         ; String for search path
PSP_Address     DD  0


Start:                            ; program entry point

  ;
  ;  Call the DOS's "Find first" service
  ;
        mov     edx,offset ASCIIZ_path
        mov     cx,00000b
        mov     ah,4Eh
        int     21h
        jc exit
  ;
  ; The file info is put in the DTA buffer which is initally located
  ; at offset 80h in the PSP segment
  ;

        mov     ax,0EE02h            ; Get DOS32 address information
        int     31h
        mov     PSP_Address,esi      ; Save the PSP pointer.



;----- file display loop --------
Find_next_loop:

   ;
   ; Load EDI with pointer to the DTA buffer
   ;
        mov     edi,PSP_Address
        add     edi,80h


   ;
   ; Print ASCIIZ string that was stored at offset 1E of the DTA buffer.
   ;

str_loop:
      mov al,[edi+1Eh]              ; get file name character from DTA
      cmp al,0                      ; if zero the string has ended
      jz string_end
      call Print_Char               ; plot it
      inc edi                       ; get next char
      jmp str_loop                  ; loop around

string_end:
 ;
 ; Finished printing the ASCIIZ file name.   Now to carrage return
 ;

       mov al,13
       call Print_Char
       mov al,10
       call Print_Char

;
;    Loop around and keep on calling DOS's "Find Next" service until there
; are no more files to find.
;
       mov  ah,4Fh
       int  21h
       jnc Find_next_loop

exit:
        mov     ax,4c00h                    ; Exit program
        int     21h




 ;
 ; A procedure to send character to the standard output.
 ;
Print_Char PROC
        mov     ah,02h
        mov     dl,al
        int     21h
        ret
Print_Char ENDP


END Start
