DEFINT A-Z

CONST SpacesPerTab = 4

'****************************************************************************'
'***    Initialization                                                    ***'
'****************************************************************************'
CONST True = -1, False = 0
'$INCLUDE: 'QB.BI'
DECLARE FUNCTION FileExists% (FileName$)
DIM SHARED InRegX AS RegTypeX, OutRegX AS RegTypeX
TYPE DTAtype
	Reserved AS STRING * 21
	Attrib AS STRING * 1
	FileTime AS INTEGER
	FileDate AS INTEGER
	FileSize AS LONG
	FileName AS STRING * 13
END TYPE


'****************************************************************************'
'***    Start of program                                                  ***'
'****************************************************************************'
IF LEN(COMMAND$) <> 0 THEN
	SourceFile$ = COMMAND$
	TargetFile$ = "TEMPFILE.$$$"
	Switch = True
ELSE
	INPUT "Source filename:  ", SourceFile$
	INPUT "Target filename:  ", TargetFile$
	IF TargetFile$ = "" OR TargetFile$ = SourceFile$ THEN
		TargetFile$ = "TEMPFILE.$$$"
		Switch = True
	END IF
END IF

IF NOT FileExists(SourceFile$) THEN PRINT "File not found.": END

OPEN SourceFile$ FOR INPUT AS #1
OPEN TargetFile$ FOR OUTPUT AS #2

DO
	LINE INPUT #1, A$
	DO
		IF INSTR(A$, CHR$(9)) > 0 THEN
			A$ = LEFT$(A$, INSTR(A$, CHR$(9)) - 1) + SPACE$(SpacesPerTab) + MID$(A$, INSTR(A$, CHR$(9)) + 1)
		ELSE
			EXIT DO
		END IF
	LOOP
	PRINT #2, RTRIM$(A$)
LOOP UNTIL EOF(1)
CLOSE

IF Switch THEN
	KILL SourceFile$
	NAME TargetFile$ AS SourceFile$
END IF

FUNCTION FileExists (FileName$)
	DIM DTA AS DTAtype
	InRegX.AX = &H1A00
	InRegX.DX = VARPTR(DTA)
	InRegX.DS = VARSEG(DTA)
	CALL INTERRUPTX(&H21, InRegX, OutRegX)

	Temp$ = FileName$ + CHR$(0)
	InRegX.AX = &H4E00
	InRegX.CX = 0
	InRegX.DS = VARSEG(Temp$)
	InRegX.DX = SADD(Temp$)
	CALL INTERRUPTX(&H21, InRegX, OutRegX)
	FileExists = ((OutRegX.FLAGS AND 1) = 0)
END FUNCTION

