#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include "xlib_all.h"

struct PCXHEAD {
    char manufacturer;
    char version;
    char encoding;
    char bits_per_pixel;
    int xmin,ymin;
    int xmax,ymax;
    int hres;
    int vres;
    char palette[48];
    char reserved;
    char colour_planes;
    int bytes_per_line;
    int palette_type;
    char filler[58];
} header;

unsigned int width, depth, bytes;
unsigned char palette[768], *pbm;
char pcxfile[20],pbmfile[20],palfile[20];
FILE *fp, *fp2, *fp3;

/**/
void Read_PCX_Line(unsigned int vidrow)
{
    unsigned char c, run;
    unsigned int n = 0, vidcol = 0;

    do {
        c = fgetc(fp) & 0xff;       /* if it's a run of bytes field */
        if ((c & 0xC0) == 0xC0) {
            run = c & 0x3F;         /* and off the high bits */
            c = fgetc(fp);          /* get the run byte */
            while (run > 0 && n < bytes) {
                x_put_pix(vidcol, vidrow, 0, c);
                vidcol++;
                run--;
                n++;
            }
        } else {
            n++;
            x_put_pix(vidcol, vidrow, 0, c);
            vidcol++;
        }
    } while (n < bytes);
}
/**/
void Unpack_PCX_File(void)
{
    int i;

    for (i = 0; i < 768; i++) palette[i] = palette[i] >> 2;
    x_put_pal_raw(palette, 256, 0);

    for (i = 0; i < depth; i++) Read_PCX_Line(i);
}
/**/
int main(int argc, char *argv[])
{
    printf("PCX2PBM.EXE -- PCX file to planar bitmap (PBM) with palette (PAL)\n");
    printf("    by JL Enterprises, 1993\n\n");
    printf("syntax:   PCX2PBM filename\n\n");

    if (argc == 2) {
        if (strstr(argv[1], ".")) *strstr(argv[1], ".") = 0;
        strupr(strcat(strcpy(pcxfile,argv[1]),".PCX"));
        strupr(strcat(strcpy(pbmfile,argv[1]),".PBM"));
        strupr(strcat(strcpy(palfile,argv[1]),".PAL"));
    } else {
        printf("Filename not specified.\n"); exit(0);
    }
    if ((fp = fopen(pcxfile,"rb")) == NULL) {
        printf("Error opening %s for input\n",pcxfile); exit(0); }
    if (fread(&header,1,sizeof(struct PCXHEAD),fp) != sizeof(struct PCXHEAD)) {
        printf("Error reading %s\n",pcxfile); exit(0); }
    if (header.manufacturer != 0x0a || header.version != 5) {
        printf("Not a 256 color PCX file\n"); exit(0); }
    if (fseek(fp,-769L,SEEK_END)) {
        printf("Error seeking to palette\n"); exit(0); }
    if (fgetc(fp) != 0x0c || fread(palette, 1, 768, fp) != 768) {
        printf("Error reading palette\n"); exit(0); }
    if ((fp2 = fopen(pbmfile,"wb")) == NULL) {
        printf("Error opening %s for output\n",pbmfile); exit(0); }
    if ((fp3 = fopen(palfile,"wb")) == NULL) {
        printf("Error opening %s for output\n",palfile); exit(0); }

    fseek(fp, 128L, SEEK_SET);
    width = (header.xmax - header.xmin + 1 + 3) & 0xFFFC;
    depth = header.ymax - header.ymin + 1;
    if ((long)width*(long)depth+2 > (unsigned)0xFFFF) {
        printf("Resulting image is greater than 64k\n"); exit(0); }
    bytes = header.bytes_per_line;
    if ((pbm = (char *)malloc(2+width*depth)) == NULL) {
        printf("Error allocating memory\n"); exit(0); }

    x_set_mode(X_MODE_320x240, 320);

    Unpack_PCX_File();
    x_get_pbm(0, 0, width/4, depth, 0, pbm);
    fwrite(pbm, sizeof(char), 2+width*depth, fp2);
    free(pbm);
    fwrite(palette, sizeof(char), 768, fp3);

    fclose(fp); fclose(fp2); fclose(fp3);

    if (getch() == 0) getch();        /* a pause */
    x_text_mode();
    printf("width: %i, height: %i\n", width, depth);
    return(0);
}
/**/
