ideal
p386
locals
jumps
model huge
stack 100h


segment     Code
            assume cs:Code, ds:Code
;
include     "palette.inc"
include     "scale1.inc"
include     "zoom.inc"
include     "doorpic.dmp"
CurPalette  db 256 dup (0,0,0)
CurIndex    dd 0
DoorSize    dw 0
;
proc        Start
            ;**** change to graphics mode ****
            mov ax,0013h
            int 10h

            ;**** convert the TGA palette to normal format ****
            mov ax,ImageSegment
            mov ds,ax
            mov si,offset ImageData+18
            call Fix_TGA_palette

            ;**** set the palette to all black ****
            mov ax,cs
            mov ds,ax
            mov si,offset CurPalette
            mov cx,256
            xor al,al
            SetPalette

            ;**** display the house at normal size (w/o masking) ****
            mov ax,ImageSegment
            mov ds,ax
            mov si,offset ImageData+18+768
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200/4)
            cld
            rep movsd

            ;**** paste a door on top of it ****
            push cs (offset DoorImage+4)
            push [word cs:DoorImage+2] [word cs:DoorImage+0]
            push [word cs:DoorImage+2] [word cs:DoorImage+0]
            push 135 151
            call Scale
            add sp,16

            ;**** fade the palette in ****
            mov ax,cs                       ;\
            mov ds,ax                       ; > DS:SI ==> source palette
            mov si,offset CurPalette        ;/
            mov ax,ImageSegment             ;\
            mov es,ax                       ; > ES:DI ==> target palette
            mov di,offset ImageData+18      ;/
            call fade_in

;
            ;**** animate the door opening ****
            mov [word cs:ScreenPtr+0],offset WorkBuffer
            mov [word cs:ScreenPtr+2],WorkSegment
            mov ax,[word cs:DoorImage+0]
            mov [cs:DoorSize],ax
@@OpenDoor: ;copy the background to our working buffer
            mov ax,FirePlaceSegment
            mov ds,ax
            mov si,offset FirePlace+18+768
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            mov cx,(320*200/4)
            cld
            rep movsd

            ;display the house at normal size (w/ masking)
            mov ax,ImageSegment
            mov ds,ax
            mov si,offset ImageData+18+768
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            mov cx,320*200
            cld
@@Mask1:    lodsb
            or al,al
            jz @@Mask3
            stosb
@@Mask2:    dec cx
            jnz @@Mask1
            jmp @@Mask4
@@Mask3:    inc di
            jmp @@Mask2
@@Mask4:
            
            ;paste a door on top of it
            push cs (offset DoorImage+4)
            push [word cs:DoorImage+2] [word cs:DoorImage+0]
            push [word cs:DoorImage+2] [cs:DoorSize]
            push 135 151
            call Scale
            add sp,16

            ;display our hidden buffer
            mov ax,WorkSegment
            mov ds,ax
            mov si,offset WorkBuffer
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200/4)
            cld
            rep movsd

            WaitForRetrace
            WaitForRetrace

            dec [cs:DoorSize]
            jnz @@OpenDoor
            
;
            ;**** explode the image ****
            mov [word cs:CurIndex+0],offset ZoomTable
            mov [word cs:CurIndex+2],cs
            mov [word cs:ScreenPtr+0],offset WorkBuffer
            mov [word cs:ScreenPtr+2],WorkSegment

@@ScaleIt:  ;copy the background to our working buffer
            mov ax,FirePlaceSegment
            mov ds,ax
            mov si,offset FirePlace+18+768
            mov ax,WorkSegment
            mov es,ax
            mov di,offset WorkBuffer
            mov cx,(320*200/4)
            cld
            rep movsd

            ;zoom the house and mask it over the background
            lds si,[dword cs:CurIndex]
            cmp [word ds:si],-1
            jz @@ScaleDone
            push ImageSegment (offset ImageData+18+768)
            push 200 320
            lodsw   ;house height
            push ax
            lodsw   ;house width
            push ax
            lodsw   ;house y
            push ax
            lodsw   ;house x
            push ax
            mov [word cs:CurIndex+0],si
            call Scale
            add sp,16

            ;display our hidden buffer
            mov ax,WorkSegment
            mov ds,ax
            mov si,offset WorkBuffer
            mov ax,0A000h
            mov es,ax
            xor di,di
            mov cx,(320*200/4)
            cld
            rep movsd

            WaitForRetrace

            jmp @@ScaleIt
@@ScaleDone:
;
            ;**** flash the palette ***
            call flash_palette

            ;*** return to text mode ***
            ;mov ax,0003h
            ;int 10h

            ;**** terminate program ****
            mov ax,4C00h
            int 21h
endp        Start
;
macro       Increase value
            local @@Label
            add value,2
            cmp value,63
            jbe @@Label
            mov value,63
@@Label:    exitm
endm        Increase
;
;flashes the palette to all white
PROC        flash_palette
            mov bx,10
@@NextLoop:     WaitForRetrace                ;wait for a vertical retrace
                mov cx,PALETTE_NUMBER
@@NextColor:        mov dx,3C8h                   ;\
                    mov al,cl                     ; \ send out color number
                    dec al                        ; /
                    out dx,al                     ;/
                    mov dx,3C9h                   ;DX = DAC_DATA
                    mov al,bl                     ;\
                    out dx,al                     ; \ update red/green/blue
                    out dx,al                     ; /
                    out dx,al                     ;/
                dec cx                        ;\ loop until all colors
                jnz @@NextColor               ;/ are done
            add bx,5
            cmp bx,63
            jbe @@NextLoop
            ret                           ;return
ENDP        flash_palette
; 
ends        Code

segment     ImageSegment
include     "housetga.dmp"
ends        ImageSegment

segment     FirePlaceSegment
include     "firetga.dmp"
ends        FirePlaceSegment

segment     WorkSegment
label       WorkBuffer byte
ends        WorkSegment

            end     Start
