;this is the 'cheating' version that really only averages the bottom
;few rows, and then simply decreases the intensity of the higher flames.
;in theory, it should have a high frame rate
.286
ideal
locals
jumps
model huge
stack 100h

LoopDemo = 0        ;set to 1 to loop text, or 0 to quit upon reaching end
XOffset = 95
YOffset = 53
Scr_Width = 320
Scr_Height = 200
Flame_Width = 140
Flame_Height = 95

macro       CenterString padlength,stringtext
            stringlength sizestr <stringtext>
            errif (stringlength-2) gt (padlength) "String too long"
            padwidth = ((padlength)-(stringlength-2))/2
            if (padwidth) ge 1
                db (padwidth) dup (' ')
            endif
            db stringtext
            padwidth = (padlength-((stringlength-2)+padwidth))
            if (padwidth) ge 1
                db (padwidth) dup (' ')
            endif
endm

segment Code
        assume cs:Code
;
include         "block.dmp"
FlameBuffer     db  (Flame_Height+2)*Flame_Width dup (0)
Seed            dw  'Yo'
                                ;1234567890123456789012345678901234567890
label           Message_Text byte
                CenterString 40,"Wasn't that a rad transition?  I don't"
                CenterString 40,"know if it will go too slowly on slower"
                CenterString 40,"systems as the only system I have that"
                CenterString 40,"has a VGA is a 486DX-50."
                CenterString 40,"- - - - -"
                CenterString 40,"Well, I'm sure all you folks recognize"
                CenterString 40,"this effect!  The only thing I really"
                CenterString 40,"did was to come up with the idea of"
                CenterString 40,"putting a masked image on top."
                CenterString 40,"(Notice the socks overlap the fire)"
                CenterString 40,"- - - - -"
                CenterString 40,"This part was actually the first one"
                CenterString 40,"that I coded for this demo, so the"
                CenterString 40,"coding for it is a little worse than"
                CenterString 40,"the others because that was essentially"
                CenterString 40,"the first time I had written video and"
                CenterString 40,"font routines in assembly for a while."
                CenterString 40,"- - - - -"
                CenterString 40,"Well, I'm running out of things to say"
                CenterString 40,"so let's proceed to the next part..."
                CenterString 40,"- - - - -"
                db  0
Message_Ptr     dw  ?,?
Message_Column  dw  0
Message_Pos     dw  (Scr_Height-16)*Scr_Width,0A000h
;
proc    Start
        cld

        ;switch over to graphics mode
        mov ax,0013h
        int 10h

        ;load in the font to display text with
        mov [word cs:Message_Ptr+0],offset Message_Text
        mov [word cs:Message_Ptr+2],cs
        mov [cs:Message_Column],0

        ;load in a pretty picture to look at
        call LoadTGA
        call DisplayAllBuffers

@@MainLoop:
        call CalculateFire

        call DisplayNewBuffers

        mov dh,255
        lds si,[dword cs:Message_Ptr]
        mov cx,[cs:Message_Column]
        les di,[dword cs:Message_Pos]
        call DisplayColOfText
        inc [cs:Message_Column]
        cmp [cs:Message_Column],Scr_Width
        jnz @@NoNewText
        mov [cs:Message_Column],0
        lds si,[dword cs:Message_Ptr]
        add si,(Scr_Width/8)
        cmp [byte ds:si],0
        jnz @@GotNewText
        if LoopDemo eq 0
            jmp @@Quit
        else
            mov si,offset Message_Text
        endif
@@GotNewText:
        mov [word cs:Message_Ptr+0],si
        mov [word cs:Message_Ptr+2],ds
@@NoNewText:

        ;wait for a retrace to complete (for timing)
        mov dx,3dah
@@ras1: in al,dx
        test al,8
        jnz @@ras1
@@ras2: in al,dx
        test al,8
        jz @@ras2

        ;get stdio.  If something's been pressed, quit
        mov ah,6
        mov dl,0FFh
        int 21h
        jz @@MainLoop

@@Quit: ;change back to text mode
        ;mov ax,0003h
        ;int 10h

        ;quit to DOS
        mov ax,4C00h
        int 21h
endp    Start
;
;Calculate the fire stuff
proc    CalculateFire
        ;average each pixel with its neighbors and decrement it one
        ;while moving it up a row
        cld
        mov ax,cs
        mov ds,ax
        mov es,ax
        mov si,offset FlameBuffer+(Flame_Width*2)
        mov di,offset FlameBuffer
        mov dx,(Flame_Height+2)/2
@@NewRow:   mov cx,Flame_Width/2
@@NewCol:       cmp dx,5
                jbe @@Normal
@@Cheat:        mov al,[byte (si+0)]                    ;ourself
                sub al,2
                jns @@StoreIt
                xor al,al
                jmp @@StoreIt
@@Normal:       xor ax,ax
                xor bx,bx
                mov al,[byte (si-2)]                    ;left neighbor
                mov bl,[byte (si+0)]                    ;ourself
                add ax,bx
                mov bl,[byte (si+2)]                    ;right neighbor
                add ax,bx
                mov bl,[byte (si+Flame_Width)]          ;lower neighbor
                add ax,bx
                sub ax,6                        ;decrease value
                sar ax,2
                jge @@StoreIt
                xor ax,ax
@@StoreIt:      mov [byte es:di+0],al
                mov [byte es:di+1],al
                mov [byte es:di+0+Flame_Width],al
                mov [byte es:di+1+Flame_Width],al
                add di,2
                add si,2
            dec cx
            jnz @@NewCol
        add di,Flame_Width
        add si,Flame_Width
        dec dx
        jnz @@NewRow

        ;randomize the bottom two rows
        mov si,offset FlameBuffer+(Flame_Width*Flame_Height)
        mov cx,Flame_Width/2
        mov bl,127
        mov ax,[cs:seed]
@@Randomize:imul ax,8905h
            inc ax
            test ax,ax
            js @@NotNew
            imul ax,8905h
            inc ax
            mov bl,al
            and bl,7fh
@@NotNew:   mov [cs:si],bl
            mov [cs:si+Flame_Width],bl
        add si,2
        dec cx
        jnz @@Randomize
        mov [cs:seed],ax

        ret
endp    CalculateFire
;
;display the *entire* fireplace backdrop, masking the flame buffer (slow)
proc    DisplayAllBuffers
        mov ax,FirePlaceSegment             ;\
        mov ds,ax                           ; > DS:SI ==> fireplace backdrop
        mov si,offset FirePlace+18+768      ;/
        mov ax,0A000h                       ;\
        mov es,ax                           ; > ES:DI ==> screen buffer
        xor di,di                           ;/
        mov cx,Scr_Width*YOffset+XOffset
        rep movsb
        ;------------------------------------
        mov bx,offset FlameBuffer           ;CS:BX ==> fire buffer
        mov dx,Flame_Height
@@MergeFlameStart:
        mov cx,Flame_Width
@@MergeFlame:
        lodsb
        or al,al
        jnz @@CopyIt
        mov al,[byte cs:bx]
@@CopyIt:
        stosb
        inc bx
        dec cx
        jnz @@MergeFlame

        mov cx,(Scr_Width-Flame_Width)
        rep movsb

        dec dx
        jnz @@MergeFlameStart
        ;------------------------------------
        mov cx,(Scr_Height-Yoffset-Flame_Height)*Scr_Width+(Scr_Width-XOffset-Flame_Width)
        rep movsb

        ret
endp    DisplayAllBuffers
;
;display only the parts of the backdrop masking the flame buffer (faster)
proc    DisplayNewBuffers
        mov ax,FirePlaceSegment             ;\
        mov ds,ax                           ; > DS:SI ==> fireplace backdrop
        mov si,offset FirePlace+18+768      ;/
        mov ax,0A000h                       ;\
        mov es,ax                           ; > ES:DI ==> screen buffer
        xor di,di                           ;/
        mov cx,Scr_Width*YOffset+XOffset
        add si,cx
        add di,cx
        ;------------------------------------
        mov bx,offset FlameBuffer           ;CS:BX ==> fire buffer
        mov dx,Flame_Height
@@MergeFlameStart:
        mov cx,Flame_Width
@@MergeFlame:
        lodsb
        or al,al
        jnz @@CopyIt
        mov al,[byte cs:bx]
@@CopyIt:
        stosb
        inc bx
        dec cx
        jnz @@MergeFlame

        mov cx,(Scr_Width-Flame_Width)
        add di,cx
        add si,cx

        dec dx
        jnz @@MergeFlameStart

        ret
endp    DisplayNewBuffers
;
;load a TGA and display it
proc    LoadTGA
        push ds

        mov ax,FirePlaceSegment
        mov ds,ax
        mov es,ax
        mov si,offset FirePlace+18
        mov di,offset FirePlace+18
        mov cx,256
        cld
@@FixPal:
        lodsb           ;\
        shr al,2        ; > load in Blue component
        mov ah,al       ;/
        lodsb           ;\
        shr al,2        ; > load in Green component
        mov bh,al       ;/
        lodsb           ;\ load in Red component
        shr al,2        ;/
        stosb           ;write out Red
        mov al,bh       ;\ write out Green
        stosb           ;/
        mov al,ah       ;\ write out Blue
        stosb           ;/
        dec cx
        jnz @@FixPal

        mov ax,1012h
        mov bx,0
        mov cx,256
        mov dx,offset FirePlace+18
        int 10h

        pop ds
        ret
endp    LoadTGA
;
;       DH = color to print in (0 to 255)
;       DS:SI ==> message to print
;       CX = column number to display (0 to 319)
;       ES:DI ==> offset to start display
proc    DisplayColOfText
        mov bx,cx               ;\
        shr bx,3                ; > current letter being drawn
        add si,bx               ;/
        add di,cx               ;ES:DI ==> correct position of this column
        and cx,7                ;\
        neg cx                  ; > CX = number of places to shift
        add cx,7                ;/
        mov bl,[byte ds:si]         ;\
        xor bh,bh                   ; \ BX ==> font data for this letter
        shl bx,4                    ; /
        add bx,offset Font_buffer   ;/
        mov dl,16                   ;DL = number of rows to print
@@DisplayChar:
        mov al,[byte ds:bx]
        shr al,cl
        and al,1
        jz @@Nothing
@@Something:
        mov [byte es:di],dh
        jmp @@Next
@@Nothing:
        mov [byte es:di],0
@@Next:
        add di,Scr_Width
        inc bx
        dec dl
        jnz @@DisplayChar

        ret
endp    DisplayColOfText
;
ends    Code

segment FirePlaceSegment
include "firetga.dmp"
ends    FirePlaceSegment

        end     Start
