; From csg669@wing.rug.nl
; UMB86.SYS : UMB manager v1.00

code    segment

	assume  cs:code

; Defines

XMSversion      equ     0300h
Revision        equ     0100h

oldXMM          equ     0000h
UMBs            equ     0004h

; Errors

NOTIMPLEMENTED  equ     080h

UMBSIZETOOBIG   equ     0B0h
NOUMBS          equ     0B1h
INVUMBHANDLE    equ     0B2h

; Driver header

	dd    -1
	dw    0A000h
	dw    strategy
intvec  dw    interrupt
	db    'UMB86XX0'

reqhdrptr dd    ?

strategy proc   far

  mov   word ptr cs:reqhdrptr[0],bx
  mov   word ptr cs:reqhdrptr[2],es
  ret

strategy endp

res_int proc far

  push  bx ds
  lds   bx,cs:reqhdrptr
  cmp   byte ptr ds:bx[2],10h
  mov   word ptr ds:bx[3],0100h
  jbe   ri
  mov   word ptr ds:bx[3],9003h
ri:
  pop   ds bx
  retf

res_int endp

oldINT2Fh       dd      ?

newINT2Fh  proc

  sti
  cmp   ah,43h
  jne   short nextint

  test  al,al
  jne   short nextfunc
  mov   al,80h
  iret

nextfunc:
  cmp   al,10h
  jne   short nextint
  push  cs      
  mov   bx,offset emptyXMM
  pop   es
  iret

nextint:
  cli
  jmp   cs:oldINT2Fh

newINT2Fh  endp

emptyXMM   proc far

  jmp   short XMM_entry
  nop
  nop
  nop

XMM_entry:

  pushf
  test  ah,ah
  je    get_XMS_version

  xor   ax,ax
  mov   bl,NOTIMPLEMENTED
  popf
  ret

get_XMS_version:
  mov   ax,XMSversion
  mov   bx,Revision
  xor   dx,dx
  popf
  ret

emptyXMM   endp

interrupt proc  far

  push  ax bx cx dx si di ds es
  pushf

  lds   bx,cs:reqhdrptr
  mov   al,ds:bx[2]

  test  al,al
  jnz   nextRequest
  call  init
  jmp   short returnOK

nextRequest:
  cmp   al,16
  jle   returnOK

  mov   ax,9003h
  jmp   short EOI

returnOK:
  mov   ax,0100h

EOI:
  lds   bx,cs:reqhdrptr
  mov   word ptr ds:bx[3],ax

  popf
  pop   es ds di si dx cx bx ax
  ret

interrupt endp

; Global vars

XMSdriver       dd      ?

init    proc

  cbw
  mov   byte ptr ds:bx[13],al
  mov   word ptr ds:bx[14],ax
  mov   word ptr ds:bx[16],cs

  mov   ah,43h
  int   2Fh
  cmp   al,80h
  je    XMM_present

  push  bx ds
  mov   ax,352Fh
  int   21h
  mov   word ptr cs:oldINT2Fh[0],bx
  mov   word ptr cs:oldINT2Fh[2],es

  mov   ah,25h
  push  cs
  mov   dx,offset newINT2Fh
  pop   ds
  int   21h

  pop   ds bx
  mov   word ptr ds:bx[14],offset interrupt
  mov   word ptr cs:intvec,offset res_int
  
XMM_present:  
  
  lds   si,ds:bx[18]
  
  mov   ax,4310h
  int   2Fh
  mov   word ptr cs:XMSdriver[0],bx
  mov   word ptr cs:XMSdriver[2],es
  
  mov   ah,al
  mov   dx,0FFFFh
  call  cs:XMSdriver
  cmp   bl,NOTIMPLEMENTED
  je    findSlash
  mov   dx,offset UMBah

UMBerror:
  push  dx
  mov   ah,9
  push  cs
  mov   dx,offset UMBe1
  pop   ds
  int   21h
  pop   dx
  int   21h
  mov   dx,offset UMBe2
  int   21h
  ret

findSlash:
  lodsb
  cmp   al,'/'
  je    foundSlash
  test  al,al
  je    noParam
  cmp   al,13
  jne   findSlash

noParam:
  mov   dx,offset UMBnp
  jmp   UMBerror

invalidParam:
  mov   dx,offset UMBip
  jmp   UMBerror

foundSlash:
  lodsw
  or    ax,'  '
  cmp   ax,'mu'
  jne   invalidParam
  lodsw
  or    ax,'  '
  cmp   ax,'=b'
  jne   invalidParam

  call  getParam
  jc    invalidParam

  mov   di,UMBs
  mov   es,cx
  jmp   short storeParam

nextParam:
  call  getParam
  jc    invalidParam
storeParam:
  cmp   al,','
  mov   ax,cx
  stosw
  mov   ax,bx
  stosw
  je    nextParam
  xor   ax,ax
  stosw
  
  lds   bx,cs:XMSdriver
nextXMM:
  mov   ax,ds:[bx]
  cmp   al,0EBh
  je    NearJmp
  cmp   al,0EAh
  jne   XMMchainMessedUp
FarJmp:
  les   bx,ds:bx[1]
  jmp   nextXMM
NearJmp:
  cmp   word ptr ds:bx[2],9090h
  jne   XMMchainMessedUp
  cmp   byte ptr ds:bx[4],90h
  je    XMMchainOK

XMMchainMessedUp:
  mov   dx,offset XMMcmu
  jmp   UMBerror

XMMchainOK:
  push  bx
  xchg  ah,al
  cbw
  add   ax,2
  add   bx,ax
  mov   word ptr es:oldXMM[0],bx
  mov   word ptr es:oldXMM[2],ds
  pop   bx

  cli
  mov   byte ptr ds:bx[0],0EAh
  mov   word ptr ds:bx[1],di
  mov   word ptr ds:bx[3],es
  sti

  push  cs
  mov   si,offset UMB
  pop   ds
  mov   cx,UMBsize
  rep   movsb
  add   di,0Fh
  shr   di,1
  shr   di,1
  shr   di,1
  shr   di,1
  add   es:UMBs[0],di
  sub   es:UMBs[2],di
  ret
  
init    endp

getParam proc

  call  getAddress
  cmp   bx,0A000h
  jb    returnInvalid
  cmp   al,'-'
  jne   returnInvalid
  mov   cx,bx
  call  getAddress
  sub   bx,cx
  ret

returnInvalid:
  stc
  ret

getParam endp

getAddress proc
  
  xor   bx,bx

nextChar:
  lodsb
  cmp   al,'0'
  jb    lastChar
  cmp   al,'9'
  jbe   digitOK
  or    al,' '
  cmp   al,'a'
  jb    lastChar
  cmp   al,'f'
  ja    lastChar
  add   al,9
digitOK:
  and   al,0Fh
  shl   bx,1
  shl   bx,1
  shl   bx,1
  shl   bx,1
  or    bl,al
  jmp   nextChar

lastChar:
  ret

getAddress endp

; Relocatable UMB manager

UMB     proc far

  jmp   short UMB_entry
  nop
  nop
  nop

UMB_entry:
  pushf
  cmp   ah,10h
  je    short allocateUMB
  cmp   ah,11h
  je    short freeUMB
  popf
  jmp   dword ptr cs:oldXMM

allocateUMB:
  xor   ax,ax
  push  cx si di
  xor   cx,cx
  mov   si,UMBs - 4

nextUMB:
  add   si,4
  cmp   word ptr cs:si[0],0
  je    lastUMB
  jg    nextUMB
  mov   di,word ptr cs:si[2]
  cmp   di,dx
  jnb   foundUMB
  cmp   di,cx
  jb    nextUMB
  mov   cx,di
  jmp   nextUMB

freeUMB:
  xor   ax,ax
  push  cx si di
  mov   cx,dx
  mov   si,UMBs
  and   ch,7Fh

nextUMB2:
  cmp   word ptr cs:si[0],0
  je    lastUMB2
  cmp   word ptr cs:si[0],cx
  jne   nextUMB2
  inc   ax
  or    byte ptr cs:si[1],80h
  jmp   short return

lastUMB:
  test  cx,cx
  jz    noUMB

  mov   bl,UMBSIZETOOBIG
  mov   dx,cx
  jmp   short return

lastUMB2:
  mov   bl,INVUMBHANDLE
  jmp   short return

foundUMB:
  inc   ax
  mov   bx,cs:si[0]
  and   byte ptr cs:si[1],7Fh
  mov   dx,di
  jmp   short return

noUMB:
  mov   bl,NOUMBS

return:
  pop   di si cx
  popf
  ret

UMB     endp

UMBsize equ $ - UMB

UMBe1   db 'UMB86: $'
UMBe2   db '!',7,13,10,'$'

UMBah   db 'UMBs already managed$'
UMBnp   db 'No parameter$'
UMBip   db 'Invalid parameter$'
XMMcmu  db 'XMM chain messed up$'

code    ends
	end
