        MODEL tiny
        IDEAL
        p286

;
; Made by: Krynos (a.k.a Robert Pouliot, krynos@llc.org)
;
; This program try to show how plasma work, and to make it work on 286 or
; better and let it stay small...
; I know it could be faster and smaller, but you should be able to understand
; it...
;
; You can distribute, modify, etc. this program as long as you distribute
; the source code with it, and you credit me somewhere (in source or program)
; and if you do some modifications, say it!
;
; It take 5.88 sec to draw on my poor 386SX-16 with slow VGA card..
; And is 511 bytes...
	

CODESEG

MACRO	MakePal

	mov di,OFFSET palette
	mov cx,(193*3+1)/2
	xor ax,ax
	rep stosw		; All zero at the palette

	mov di,OFFSET palette+3
	mov cx,64
	push cx
	mov ax,63*256

MPLP1:	
	stosw
	sub ax,0FFh
	inc di
	loop MPLP1
	
	mov ax,63
	pop cx	
	
MPLP2:	stosb
	inc di
	xchg ah,al
	stosb
	xchg ah,al
	add ax,0FFh
	loop MPLP2

	mov cx,192*3/2
	inc di
	mov si,OFFSET palette+3
	rep movsw
	
ENDM	MakePal


	ORG 100h

MAXY	EQU 199

start:  mov al,13h
	int 10h		; MCGA mode (320x200x256)

	MakePal		; create Palette...

	call SetVGApalette
	
	push 0A000h	; Set video segment
	pop ds
	
	call rand	;
	mov [0],ah	; putpixel(0, 0, rand() % 192) in more direct...
	call rand
	mov [319],ah
	call rand
	mov [MAXY*320+319],ah	
	call rand
	mov [MAXY*320],ah

        call subDivide C, 0, 0, 319, MAXY

	push cs	
	pop ds
@@LP1:
        mov ah,86h
        mov dx,3000h
        xor cx,cx
        int 15h

	call rotatePalette	; rotatePalette

        mov ah,1
        int 16h
        jz @@LP1
        xor ax,ax
	int 16h		; remove key from buffer

	mov ax,3
	int 10h		; Text mode...
	ret		; Exit program

PROC	subDivide
ARG	x1:WORD,y1:WORD,x2:WORD,y2:WORD

        push bp
        mov bp,sp
        pusha
	mov dx,[x1]	; DX=X1
	mov cx,[x2]	; CX=X2
	
	mov ax,cx
	sub ax,dx
	cmp ax,2
        jae @@Cnt2      ; If (x2-x1)=>2 start action...
			;   No need to test (y2-y1)=>2 because it never be
			;   runned (x is greater)
        popa
        pop bp
        ret
@@Cnt2:
	mov bx,[y1]	; BX=Y1
        mov ax,[y2]     ; AX=Y2
	mov si,dx
	add si,cx
	shr si,1	; SI=average(X1, X2)

        mov di,ax
	add di,bx	; DI=average(Y1, Y2)
	shr di,1
	
	; adjust...
        call adjust C, dx, bx, si, bx, cx, bx ; Adjust(X1, Y1, SI, Y1, X2, Y1)
        push ax
	push dx
	push di
	push dx
	push bx
	push dx
	call adjust	; Adjust(X1, Y1, X1, DI, X1, Y2)
	add sp,10	; Play with stack to save 1 push and some clocks...
	push cx
	push di
	push cx
	push bx
	push cx
	call adjust	; Adjust(X2, Y1, X2, DI, X2, Y2)
	add sp,8	; Play again with stack...
        push ax
	push si
        push ax
	push dx
	call adjust	; Adjust(X1, Y2, SI, Y2, X2, Y2)
	add sp,12
        push di
        imul di,320
        add di,si
        cmp [BYTE di],0
	jnz @@Cnt1	; Zero?
			; Yes, not used...
			; Else skip...
	push si		; Save SI for later...
        mov si,bx       ; SI=BX
        xor ax,ax
        ; Following code:
        ; ax=getpixel(X1,Y1)+getpixel(X2,Y1)+getpixel(X1,Y2)+getpixel(X2,Y2)
        imul di,[y2],320
        add di,dx
        mov al,[di]
        mov bx,ax
        sub di,dx
        add di,cx
        mov al,[di]
        add bx,ax
        imul di,si,320
        add di,dx
        mov al,[di]
        add bx,ax
        sub di,dx
        add di,cx
        mov al,[di]
	add ax,bx
        ; Now calculate average of the 4 corners...
	shr ax,2	; ax=bx/4... Average of corners...
	mov bx,si	; BX=SI, normal value (Y1)
	pop si		; Restore SI...
        pop di
        push di
        imul di,320
        add di,si
        mov [di],al
                        ; is average of color of 4 corners...
@@Cnt1:
        pop di
        push di
	push si
	push bx
	push dx
	call subDivide	; recurse
			; subDivide(X1, Y1, SI, DI)
			; 1/4 of itself until condition on top
			; doesn't work
	add sp,6
	push cx
	push bx
	push si
	call subDivide	; SubDivide(SI, Y1, X2, DI)
	add sp,8
	push [y2]
	push cx
	push di
	push si
	call subDivide	; SubDivide(SI, DI, X2, Y2)
	add sp,6
	push si
	push di
	push dx
	call subDivide	; SubDivide(X1, DI, SI, Y2)
	add sp,8
	popa
        pop bp
	ret		; End one recursion...

ENDP    subDivide

PROC	adjust
ARG	xa:WORD, ya:WORD, x:WORD, y:WORD, xb:WORD, yb:WORD

        push bp
        mov bp,sp
        pusha
        imul bx,[y],320
        add bx,[x]
        cmp [BYTE bx],0
        jnz @@AFin0       ; If not zero end...
	mov bx,[xa]
        sub bx,[xb]       ; BX=Abs(XA-XB)
        jns @@NS1
	neg bx
@@NS1:
	mov si,[ya]
	sub si,[yb]
        jns @@NS2         ; SI=Abs(YA-YB)
	neg si
@@NS2:
	add si,bx	; SI+=BX
			; SI=delta(X)+delta(Y)
			; Used later...
        xor ax,ax
        imul di,[ya],320        ; bx=GetPixel(XA,YA)
        add di,[xa]
        mov al,[di]
        mov bx,ax
        imul di,[yb],320        ; bx+=GetPixel(XB,YB)
        add di,[xb]
        mov al,[di]
	add bx,ax
	shr bx,1	; BX/=2 Average

	in al,40h	; Random 0-255...
	sub ah,ah
			; AX=SI*(rand(0-255))/128+BX-SI <-- modify this
        mul si          ; formula to change the plasma...
        shr ax,7
	sub ax,si
	add ax,bx
	or ax,ax
	jg Cnt1
        mov al,1       ; AX must be between 1 and 192
	jmp @@Fin2
Cnt1:
	cmp ax,193
        jb @@Fin2
	mov al,192
@@Fin2: imul bx,[y],320
        add bx,[x]
        mov [bx],al
@@AFin0:
	popa
        pop bp
	ret

ENDP    adjust

PROC	rotatePalette
	; Take palette part(1-192) and rotate it one pos forward
	; Use paltmp to not make some colors unchanged...

	pusha

	mov si,OFFSET palette+3
        lodsw
        mov bl,[si]

        mov di,OFFSET palette+3
        mov si,OFFSET palette+6
        mov cx,191*3/2
	rep movsw
        movsb
        stosw
        mov [di],bl

	popa		; No ret, so will continue...
			; (save one call and 4 bytes)
ENDP	rotatePalette

PROC    SetVGApalette

	mov si,OFFSET palette
	mov cx,193*3

        mov dx,3DAh
@@LP2:
        in al,dx
        test al,8
        jnz @@LP2
@@LP3:
        in al,dx
        test al,8
        jz @@LP3

        xor ax,ax
	mov dx,3C8h
	out dx,al	; Set starting color
	inc dx		; port 3C9h
	rep outsb	; set color palette

	ret

ENDP    SetVGApalette

; Return in AH... 1-191
PROC	rand

	in al,40h	; PIT counter divisor (pseudo-random result)
	mov ah,al
        and ah,7Fh
	in al,40h	; idem
        and al,3Fh      ; To avoid overflow (65535/192>255)
        add al,ah
        inc ax
	ret
	
ENDP	rand

DATASEG

palette	db 193*3 DUP (?)
	
END start


