;***********************************************************************
;* DISPLAY_DATE.ASM    DISPLAY_DATE                             2JUN95 *
;*                                                                     *
;* This program displays the current date to the screen. It is         *
;* intended to be used by those needing an introduction to Assembly    *
;* programming.                                                        *
;*                 -Gary Middleton [(601)226-3888 data after 6:00P.M.] *
;***********************************************************************

.MODEL SMALL  ;.EXE, segment for data and another for code-stack

.STACK        ;Default to 1K stack size ( starts at end of code segment)

.DATA         ;Start of the Data Segment (DGROUP)
;List with number of the month followed by name and a 24h to terminate
MONTH_NAMES   DB    1,'January $',2,'February $',3,'March $',4,'April $'
              DB    5,'May $',6,'June $',7,'July $',8,'August $'
              DB    9,'September $',0Ah,'October $',0Bh,'November $'
              DB    0Ch,'December $'

.CODE         ;Start of the Code Segment
;----------------------------------------------------------------------;
;     This procedure displays the current date on the screen           ;
;     in a Month Day,Year (June 1, 1995) format.                       ;
;----------------------------------------------------------------------;
DISPLAY_DATEPROC;This is the beginning of the main procedure

;Set up your Data Segment register to point to the data segment location
   MOV   AX,DGROUP     ;Get data segment location into AX
   MOV   DS,AX         ; then move it to the Data Segment register

;Get the current date using MSDOS services - CX=Year, DH=Month, DL=Day
   MOV   AH,2Ah        ;DOS-Get current date function
   INT   21h           ; now...

;Compare the hex number for the month (DH) to the numbers preceding each
; month's name in the MONTH_NAME data.  When a match is found, display
; the string following it until you reach a 24h ($).
   LEA   SI,MONTH_NAMES ;Point the Source Index to the list of months
MATCH_NUMBER_TO_NAME:
   LODSB               ;Load byte at SI into AL (and increment SI)
   CMP   DH,AL         ;Compare byte loaded to DH (month's number)
   JZ    DISPLAY_MONTH_NAME   ;Same? We found the name for that month
   JMP   MATCH_NUMBER_TO_NAME ; otherwise go back and keep trying...

;Display the month's name string now pointed to by SI
DISPLAY_MONTH_NAME:
   MOV   AH,09h        ;Set for MSDOS function 09h- Display String
                       ; You can use BIOS INT10h-0Ah, I'm lazy though
                       ; and don't want to go though all the trouble
                       ; of writing one character then moving the
                       ; cursor to the next X-Y using BIOS INT10h-02H
                       ; then writing the next character, etc...
   PUSH  DX            ;Push the month\day (DH\DL) info onto the
                       ; stack to save it. Need to use DX here...
   MOV   DX,SI         ;Point DS:DX to the offset of the name string
   INT   21h           ;MSDOS call- Display string at DS:DX till 24h
   POP   DX            ;Pop the month\day info back into DX

;Now convert the day's number (DL) from hex to ASCII then display it
   MOV   AL,DL         ;Get day's hex number into AL for converting
   MOV   AH,00         ;Zero out the upper byte- AX now equals DL
   CALL  HEX_TO_BCD    ;Convert the hex number in AX to decimal
   ;AX is now in BCD (decimal type) format- ie:old AX=0015h, now AX=0021
   ; Now display the individual nibbles of AL, the '2' then the '1'
   ; after converting them to ASCII

;Check to see if day's number is 01 thru 09. If so don't display the '0'
   CMP   AL,10         ;Is the number of the day ten or greater
   JB    DONT_DISPLAY_THE_ZERO ;No, then don't display a zero infront
                               ; Without this you'd get May 01,1995
                               ; instead of May 1,1995      ^
   CALL  DISPLAY_AL_TO_THE_SCREEN ;If AL>=10 then display AL as normal
   JMP   DISPLAY_COMMA            ;and continue with the comma and year

;Skip over the portion of 'DISPLAY_AL_TO_THE_SCREEN' that displays the
; first digit of the AL, and just display the second digit
DONT_DISPLAY_THE_ZERO:
   CALL   DISPLAY_SECOND_NIBBLE_OF_AL ;Skip the part for first nibble

;Put a comma between the day and the year
DISPLAY_COMMA:
   MOV   DL,','        ;Set DL to the ASCII equivilent of a comma
   ;AH still set for DOS function 02h by 'DISPLAY_AL_TO_THE_SCREEN'
   INT   21h           ; and use DOS function 21h-02h to display DL

;Now to convert year from hex (CX=07CBh) to BCD (AX=1995) and display it
   MOV   AX,CX         ;Get the hex number for the year into AX
   CALL  HEX_TO_BCD    ;And convert AX to BCD
   ;AX is now in the BCD (decimal type) format ie:AX=1995
   PUSH  AX            ;Push the year onto the stack to save it
   XCHG  AH,AL         ;Swap AH with AL- old AX=1995, now AX=9519
   CALL  DISPLAY_AL_TO_THE_SCREEN ; Have to display the '19' first
   POP   AX            ;Pop the year back into AX (AX=1995 again)
   CALL  DISPLAY_AL_TO_THE_SCREEN ; Now display the '95'

;That's it! Let's get outta here and return control to DOS...
   MOV   AH,4Ch        ;DOS function- Terminate Process with Code
   MOV   AL,00h        ;Return code set to zero- normal termination
   INT   21h           ;MSDOS call- Exiting to DOS...
DISPLAY_DATEENDP;End of the main procedure


;---Subroutine 'DISPLAY_AL_TO_THE_SCREEN'-------------------------------
; This routine separates the two digits of AL and converts them one at a
; time to ASCII then, displays them:
;                 (example) AL=21 inputted number
;                           ||
;                           |+- AL=01 then add 30h so AL=31h ASCII '1'
;                           |
;                           +-- AL=20 then AL=02 and add 30h for AL=32h
DISPLAY_AL_TO_THE_SCREEN:
   PUSH  AX            ;Save the original number
   SHR   AL,1          ;Shift the bits in AL four places to the right
   SHR   AL,1          ; old AL=21, now AL=02-the lower nibble was
   SHR   AL,1          ; was shifted right off into bit heaven
   SHR   AL,1          ; We could've used (MOV CL,4 then SHR AL,CL)
   ADD   AL,30h        ;Converting a single decimal digit into
                       ; it's ASCII equivilent just add 30h to it
                       ; AL now equals 32h- ASCII code for '2'
   MOV   AH,02         ;DOS function- Character Output (display DL)
   MOV   DL,AL         ;Move the ASCII character into DL
   INT   21h           ;DOS call-Display character in DL to screen
;That's it for the first digit of AL
   POP   AX            ;Get the original number back
                       ; ie:AL=21
   AND   AL,00001111b  ;Clear out the upper nibble
                       ;   AL=00110001b   ( AND truth table)
                       ; AND  00001111b   ( 1 and 1 = 1    )
                       ;      ||||||||    ( 1 and 0 = 0    )
                       ;      00000001b   ( 0 and 0 = 0    )
                       ; After ANDing with 00001111b (0Fh), AL=01
DISPLAY_SECOND_NIBBLE_OF_AL:
   ADD   AL,30h        ;Convert this last number to ASCII (AL=31h)
   MOV   DL,AL         ;Get ASCII byte ready for call
   MOV   AH,02         ;DOS function- Character Output (display DL)
   INT   21h           ;Display AL to screen (AH still function 02h)
   RET                 ;Return to the calling procedure

;--Subroutine 'HEX_TO_BCD'----------------------------------------------
; Converts and incomming hex number in AX to BCD (binary coded decimal).
; A hex number, say the day DL=15h, turns into 21(BCD) for May 21,1995.
; Likewise, the year CX=07CBh is converted into 1995(BCD)           ^^
HEX_TO_BCD:
   PUSH  DX            ;Save DX before using it here
   PUSH  CX            ; and CX
   XOR   BX,BX         ;Zero out the Base Register
DIVIDE_BY_10_TO_CONVERT:
   XOR   DX,DX         ;Same as MOV AH,00 but more efficient
                       ;Zero out the high word of DX:AX before DIV
   MOV   CX,10         ;Set divisor to 10 for decimal
   ;AX already holds the quotient
   DIV   CX            ;Divide DX:AX by CX = AX with remainder DX
   PUSH  DX            ;Save the remainder. This is what's going on;
                       ; DX=07CBh (or 1995 in decimal)
                       ; DX:AX / CX = AX remainder DX
                       ; 1995 / 10 = 199 r 5 save the 5 (stack=5xxx)
                       ; 199 / 10 = 19 r 9 save the 9 (stack=95xx)
                       ; 19 / 10 = 1 r 9 save the 9 (stack=995x)
                       ; 1 / 10 = 0 r 1 save the 1 (stack=1995)
                       ; 0 When AX=0 then we're done
   INC   BX            ;Count up each time a remainder is pushed
                       ; onto the stack
   CMP   AX,00         ;Are we done yet? (could've used OR AX,AX)
   JNZ   DIVIDE_BY_10_TO_CONVERT ;No, then divide AX by 10 again

;Done. The stack now holds the individual digits and BX tells us how
; many digits were pushed onto the stack.
   MOV   CX,BX         ;Move the digit count into Counter Register
   XOR   AX,AX         ;Zero out AX (AX=0000)
LOAD_DIGITS_INTO_AX:
   POP   DX            ;Pop the top digit off the stack and into DX
                       ; 1st loop- (old stack=1995 - new stack=995x)
                       ;  DX=top byte of stack^
                       ; 2nd loop- (old stack=995x - new stack=95xx)
                       ; 3rd loop- (old stack=95xx - new stack=5xxx)
                       ; 4th loop- (old stack=5xxx - new stack-xxxx)
   ;The following shift section doesn't do anything useful the first
   ; loop, but makes room at the right of AX for the rest of the digits
   ; during the following loops.
   SHL   AX,1          ;Shift the bits in AX left
   SHL   AX,1          ; a total of four times (one nibble)
   SHL   AX,1          ; to make room for the next digit
   SHL   AX,1          ; to be added to the right side of AX
   ADD   AX,DX         ;Add the digit to AX
                       ; 1st loop- AX=0001
                       ; 2nd loop- AX=0019
                       ; 3rd loop- AX=0199
                       ; 4th loop- AX-1995 DONE!
   LOOP  LOAD_DIGITS_INTO_AX ;Go back and get the next digit off the
                             ; stack until CX=0 (all digits are loaded)
;AX now is the decimal equivilent of the number inputted before the call
   ;Exit this routine and return to the calling procedure
   POP   CX            ;Restore the Counter Register
   POP   DX            ; and the month\day info in DH\DL
   RET

;End of the Code Segment...
   END   DISPLAY_DATE  ;Marks the end of the source code

