 ;**********************************************************; 
 ;*   CMDLINE.ASM -- Command line parser by Tenie Remmel   *; 
 ;*  This is totally public domain and may be used freely  *; 
 ;**********************************************************; 
 
 Ideal 
 Model Tiny 
 P186 
 CodeSeg 
 Org 100h 
 
 Proc        Prog 
 
             mov di,600h 
             call ParseArgs 
             mov si,di 
             jcxz done 
 
 ShowLoop:   lodsw 
             xchg ax,si 
             call PutAsciiZ 
             xchg ax,si 
             mov al,0Dh 
             int 29h 
             mov al,0Ah 
             int 29h 
             loop ShowLoop 
 done:       ret 
 
 EndP        Prog 
 
 Proc        ParseArgs 
             ;Supply ES:DI = 256-byte buffer, DS = PSP 
             ;Returns CX = number of arguments 
             ;the buffer will contain a list of 
             ;near offsets to AsciiZ strings 
             ;(and the strings themselves) 
             
             push es                ;Save registers 
             pusha 
 
             mov bx,di              ;BX = buffer 
             mov cl,[80h]           ;CX = length of command line 
             xor ch,ch              ;which is stored at 80h 
             
             push cx                ;Save CX 
             mov si,81h             ;SI = command line 
             add di,80h             ;DI = second half of buffer 
             push di                ;Save DI 
             rep movsb              ;Move command line out of DTA 
             xor al,al              ;Replace the CR at the end 
             stosb                  ;with a null 
             pop di cx              ;Restore DI, length in CX 
             inc cx                 ;Make length include last null 
             xor dx,dx              ;Zero argument counter 
             mov al,' '             ;AL = space 
 
 pa_argloop: repe scasb             ;Search for a non-space 
             dec di                 ;Point to first non-space 
             inc cx 
             cmp [byte es:di],0     ;Is it a null? 
             je pa_done             ;If so, quit 
             mov [es:bx],di         ;Store offset in list 
             add bx,2               ;Next word at [BX] 
             inc dx                 ;Increment arg counter 
             repne scasb            ;Search for a space 
             mov [byte es:di-1],0   ;Replace it by a null 
             jmp pa_argloop 
 
 pa_done:    mov es,dx              ;Tricky -- put count in ES 
             popa                   ;Restore general registers 
             mov cx,es              ;Count in CX 
             pop es                 ;Restore ES 
             ret                    ;Return 
 
 EndP        ParseArgs 

 Proc        PutAsciiZ 
             ;Supply DS:SI = AsciiZ string 
 
             pusha                  ;Save registers 
 
 paz_loop:   lodsb                  ;Load byte 
             test al,al             ;Is it a null?

             jz paz_done            ;If so, quit 
             int 29h                ;Display char 
             jmp paz_loop           ;Loop back 
 
 paz_done:   popa                   ;Restore registers 
             ret                    ;Return 
 
 EndP        PutAsciiZ 
 
 End Prog 

