; Andrew Kennedy                                         1:106/2000
          
; chkdisk.asm   Check for presence of disk in drive                             
                      
;               Avoids having to use an int 24 handler  
;               Works with both floppy and ram drives.
;                 
cseg segment
assume cs:cseg
org 100h                          ; COM format

start:             
             mov          bx,offset buffer
             mov          dx,63         ; logical sector number
             mov          al,1          ; drive b:
             mov          cx,1          ; no. of sectors to read
             int          25h
             pop          bp            ; clean up the stack
             jnc          disk_present  ; carry flag set if problem with drive
no_disk:
             mov          al,1          ; errorlevel 1
             mov          dx,offset not_there
             jmp          exit
disk_present:
             mov          al,1          ; drive b:
             int          26h           ; write the sector back
             pop          bp            ; clean up the stack
             cmp          ah,3          ; check for write-protected disk
             jne          writeable     ; exit if it is

             mov          al,2          ; errorlevel 2
             mov          dx,offset write_protect
             jmp          exit
writeable:
             mov          al,0          ; errorlevel 0, disk ready.
             mov          dx,offset there
exit:
             mov          ah,9          ; Message and errorlevel pre-set
             int          21h           ;  on entry.
             mov          ah,4Ch
             int          21h

not_there     db           'Disk not present.$'
there         db           'Disk present.$'
write_protect db           'Disk is write-protected.$'
buffer        db           ?   ; set up a dynamic buffer

cseg         ends
end          start
