; Program to draw Mandelbrot fractal in 1024x768 256 color mode
; by Robert Piontek

main:	mov	ax,04f01	; AX= Get VESA information.
	mov	cx,0105		; CX= video mode.
	mov	di,offset vesa_data	; DI= VESA buffer.
	int	010		; Get VESA information.
	cmp	al,04f		; Is VESA present?
	jne	exit		; If not exit.
	test	b[di],1		; Is video mode supported?
	jz	exit		; If not exit.
	mov	ax,04f02	; AX= Set VESA mode.
	mov	bx,cx		; BX= video mode.
	int	010		; Set VESA mode.
	mov	ax,[di+6]	; AX= window size.
	cwd			; DX= 0.
	div	w[di+4]		; AX= window size/window granularity.
	mov	w[di],ax	; Store into vesa_data.
	mov	ax,w[di+8]
	mov	es,ax		; Set ES to window segment.
	xor	bx,bx		; Bank_number, window_offset = 0.
	mov	si,-768		; y= -768
	push	bx		; Store bank_number.
lp1:	mov	bp,-1024	; x= -1024.
lp2:	push	bx		; Store window_offset.
	xor	bx,bx
	xor	di,di
lp3:	push	bx
	lea	ax,[bx+di]
	sub	bx,di
	imul	bx
	mov	bl,ah
	mov	bh,dl
	lea	bx,[bx+si+200]	; BX= ((bx+di)(bx-di))/256 + 200
	pop	ax
	imul	di
	shrd	ax,dx,7
	xchg	ax,di
	lea	di,[bp+di+512]	; DI= (bx*di)/128 + 512
	cmp	bh,4
	jg	draw		; If BX >1024 then goto draw.
	inc	cl		; Increment color.
	jne	lp3		; If color <> 0 then continue loop.
draw:	pop	bx		; Get window_offset.
	es xchg	[bx],cl		; Plot color and set color to 0.
	inc	bx		; Increment window_offset.
	jne	x_add		; If <> 0 then don't switch page.
swpage:	pop	dx		; Get bank number.
	add	dx,w[vesa_data]	; Add to bank_offset.
	push	dx		; Store bank number.
	call	vesa_data d[12]	; Switch banks
x_add:	inc	bp		; Increment x.
	jne	lp2		; If x <> 0 then continue loop2
y_add:	inc	si		; Increment y.
	jne	lp1		; If y <> 0 then continue loop1
done:	pop	dx		; Restore stack to normal.
	xchg	ax,si
	int	016		; Wait for keypress.
	mov	ax,3
	int	010		; Restore text screen.
exit:	ret			; Terminate program.

vesa_data:	; Vesa Buffer
