; From Chad Wallace - demo TSR to swap | with ;

code_seg        segment
BEGSEG  EQU     $
        assume  cs:code_seg, ds:code_seg, es:code_seg, ss:code_seg
        org     100h

begin:
        jmp     init

flag    db      0               ; Flag for functions we check

int16:
        pushf
        mov     flag, 0

        cmp     ah, 00h         ; 0h, 1h, 10h & 11h--get key functions
        je      our_func
        cmp     ah, 01h
        je      our_func
        cmp     ah, 010h
        je      our_func
        cmp     ah, 011h
        jne     call_isr

our_func:
        mov     flag, 1

call_isr:
        popf
        pushf
        db      09ah            ; Far Call
int16off        dw      0       ; To old INT 16 handler
int16seg        dw      0

        cmp     flag, 1         ; Check for our functions
        jne     exit_int16      ; If not, exit
        cmp     ax, 2b7ch       ; Check for '|' key
        jne     exit_int16      ; If not, exit

        mov     ax, 273bh       ; If so, replace with ';'

exit_int16:
        iret

RESSIZ  EQU     (($ - BEGSEG) / 16) + 1 ; Number of resident paragraphs

init:
        mov     ah, 49h         ; Free environment block
        mov     bx, 2ch
        mov     es, [bx]
        int     21h

        mov     ax, 3516h       ; Get interrupt 16 vector
        int     21h
        mov     int16off, bx    ; Store address by offset
        mov     int16seg, es    ; and segment from BX and ES

        mov     ax, 2516h       ; Set interrupt 16 vector
        mov     dx, offset int16
        int     21h

        mov     ax, 3100h       ; Terminate and stay resident
        mov     dx, RESSIZ      ; Number of paragraphs to keep
        int     21h

code_seg        ends

        end     begin
