; Richard Pavlicek <pavlicek@gate.net>
;
;Below is my routine, which displays (in decimal) the 32-bit number in
;bx:ax.  For a 16-bit number, simply set bx to zero.

;--- Display number | bx high word, ax low word
DNUMP:	mov	cx,10		;divisor and flag
	push	cx		;put flag on stack

;- divide & store digit loop
DNUM1:	xchg	ax,bx		;make ax high word, bx low word
	sub	dx,dx		;extend high word
	div	cx		;dx = remainder, ax high quotient
	xchg	ax,bx		;save high quotient, get low word
	div	cx		;dx = digit (0-9), ax low quotient
	push	dx		;save digit (remainder) on stack
	mov	dx,bx		;copy so not destroyed below
	or	dx,ax		;is full quotient zero?
	jnz	DNUM1		;no, continue

	pop	dx		;get most significant digit

;- display loop
DNUM2:	or	dl,30h		;convert to ASCII digit
	mov	ah,02h		;DOS display character function
	int	21h		;display it
	pop	dx		;get next digit or flag
	cmp	dx,cx		;is it a digit (less than 10)?
	jc	DNUM2		;yes, continue display
	retn			;no, flag met (stack normal)

