;-------------------------------------------------------------------
;KILLDEL.ASM
;
;Sample installable command based on CMDSKEL.ASM. Demonstrates how to
;over-ride an internal Dos command. Also shows how one handler can cover
;more than one command. Disables the 'DEL' and 'ERASE' commands by
;telling Dos we will handle it.
;
;Code released to the Public Domain, Darryl Luff 1995.
;
;-------------------------------------------------------------------
;
MODEL TINY
IDEAL
LOCALS
JUMPS
STACK 512

CODESEG
    EXTRN   muxFunc:Byte, muxSig:Word
    PUBLIC  cmd_Install, cmd_Check, cmd_Exec, cmd_Mux, cmd_Setup, cmd_Shutdown

INCLUDE "INSTCMD.INC"       ;function code declarations etc.
INCLUDE "UTILS.INC"         ;some useful macros etc. Not required.

InstallingMsg  db  'Installing', CR, LF, '$'
PROC cmd_Install NEAR
;Return carry set if can't install
    Write InstallingMsg
    clc
    ret
ENDP

;Buffers holding command text for compares.
delTxt      db  3, 'DEL'
eraseTxt    db  5, 'ERASE'

PROC cmd_Check NEAR
    push cs
    pop es

    ;check for 'DEL'
    push si                 ;save si for the 2nd check
    mov di, offset delTxt

    mov cl, [si]
    inc cl
    xor ch, ch              ;cx contains length of command including
                            ;the length byte itself
    cld
    repe cmpsb
    pop si                  ;restore si
    cmp cx, 0               ;was it 'DEL'?
    je IsUs                 ;yes.

    ;no, check for 'ERASE'
    mov di, offset eraseTxt
    mov cl, [si]
    inc cl
    xor ch, ch
    repe cmpsb
    cmp cx, 0
    jne NotUs

    IsUs:
    clc
    ret

    Notus:
    stc
    ret
ENDP

NoDelMsg    db  'Sorry, but I can''t POSSIBLY let you do that!!!'
            db  BELL, CR, LF, '$'

PROC cmd_Exec NEAR
    mov [byte ptr si], 0    ;clear command to show it's done
    push cs
    pop ds
    Write NoDelMsg

    ret
ENDP

PROC cmd_Mux NEAR
;Call:      al = mux function code requested.
;Return:    al = return code. muxFAIL, muxOK or application specific.
    mov al, muxFAIL
    ret
ENDP

TitleMsg    db  CR, LF
            db  'KillDel v0.01', CR, LF
            db  '-------------', CR, LF, '$'

PROC cmd_Setup NEAR
    push cs
    pop ds
    Write TitleMsg

    ;setup mux function and signature word.
    mov [cs:muxFunc], 'K'
    mov [cs:muxSig], 'KD'
    ret
ENDP

PROC cmd_Shutdown NEAR
;Return carry set if can't de-install, carry clear if OK.
    clc
    ret
ENDP

ENDS
END
