VERSION 2.00
Begin Form NotePad 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Recording Custom Control Demo"
   ClientHeight    =   6855
   ClientLeft      =   510
   ClientTop       =   1950
   ClientWidth     =   10260
   Height          =   7545
   Left            =   450
   LinkTopic       =   "Form1"
   ScaleHeight     =   6855
   ScaleWidth      =   10260
   Top             =   1320
   Width           =   10380
   Begin CheckBox ChkCancel 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Allow cancel of playback"
      Height          =   255
      Left            =   7440
      TabIndex        =   11
      Top             =   3720
      Width           =   2655
   End
   Begin CheckBox ChkFast 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Fast Playback"
      Height          =   255
      Left            =   7440
      TabIndex        =   10
      Top             =   3240
      Width           =   2415
   End
   Begin Recorder Recorder1 
      AllowCancel     =   0   'False
      Enabled         =   -1  'True
      Left            =   1320
      MessageType     =   1  'All messages
      PlaybackFileName=   ""
      PlaybackSpeed   =   0  'Normal
      RecordFileName  =   ""
      Top             =   6000
   End
   Begin CommandButton Command6 
      Caption         =   "Playback"
      Height          =   375
      Left            =   7680
      TabIndex        =   9
      Top             =   5520
      Width           =   1815
   End
   Begin CommandButton Command5 
      Caption         =   "Stop Recording"
      Enabled         =   0   'False
      Height          =   375
      Left            =   7680
      TabIndex        =   8
      Top             =   5040
      Width           =   1815
   End
   Begin CommandButton Command4 
      Caption         =   "Start Recording"
      Height          =   375
      Left            =   7680
      TabIndex        =   7
      Top             =   4560
      Width           =   1815
   End
   Begin Frame Frame2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Relative to"
      Height          =   1335
      Left            =   7440
      TabIndex        =   4
      Top             =   1680
      Width           =   2415
      Begin OptionButton OptScreen 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Screen"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   960
         Width           =   1455
      End
      Begin OptionButton OptForm 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Main Form Window"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   480
         Width           =   1935
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Record To/Playback from"
      Height          =   1335
      Left            =   7440
      TabIndex        =   1
      Top             =   120
      Width           =   2415
      Begin OptionButton OptMemory 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Memory"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   360
         Width           =   1455
      End
      Begin OptionButton OptFile 
         BackColor       =   &H00C0C0C0&
         Caption         =   "File"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   840
         Width           =   1455
      End
   End
   Begin CommonDialog CMDialog1 
      CancelError     =   -1  'True
      Left            =   120
      Top             =   6000
   End
   Begin TextBox Document 
      Height          =   5895
      HideSelection   =   0   'False
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   0
      Width           =   7335
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFNew 
         Caption         =   "&New"
      End
      Begin Menu mnuFOpen 
         Caption         =   "&Open..."
      End
      Begin Menu mnuFSave 
         Caption         =   "&Save"
      End
      Begin Menu mnuFSaveAs 
         Caption         =   "Save &As..."
      End
      Begin Menu mnuFSep 
         Caption         =   "-"
      End
      Begin Menu mnuFExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuEdit 
      Caption         =   "&Edit"
      Begin Menu mnuECut 
         Caption         =   "Cu&t"
         Shortcut        =   ^X
      End
      Begin Menu mnuECopy 
         Caption         =   "&Copy"
         Shortcut        =   ^C
      End
      Begin Menu mnuEPaste 
         Caption         =   "&Paste"
         Shortcut        =   ^V
      End
      Begin Menu mnuEDelete 
         Caption         =   "De&lete"
         Shortcut        =   {DEL}
      End
      Begin Menu mnuESep1 
         Caption         =   "-"
      End
      Begin Menu mnuESelectAll 
         Caption         =   "Select &All"
      End
      Begin Menu mnuETime 
         Caption         =   "Time/&Date"
      End
   End
   Begin Menu mnuKeys 
      Caption         =   "Record &Keystrokes"
      Begin Menu mnuRecord 
         Caption         =   "Record Keystrokes"
      End
      Begin Menu MnuStop 
         Caption         =   "Stop Recording"
         Visible         =   0   'False
      End
      Begin Menu mnuPlayback 
         Caption         =   "Playback Keystrokes"
      End
   End
   Begin Menu mnuAbout 
      Caption         =   "&About"
   End
End

Sub ChkCancel_Click ()
   Recorder1.AllowCancel = ChkCancel.Value
End Sub

Sub ChkFast_Click ()
    Recorder1.PlaybackSpeed = ChkFast.Value
End Sub

Sub Command4_Click ()
  Dim SaveFileName As String
  If (OptFile.Value) Then
     SaveFileName = GetFileName(2)
     If SaveFileName <> "" Then
	Recorder1.RecordFileName = SaveFileName
     Else
	Exit Sub
     End If
  End If
  Recorder1.Record = True
  Command4.Enabled = False
  Command5.Enabled = True
End Sub

Sub Command5_Click ()
  Recorder1.Record = False
  Command4.Enabled = True
  Command5.Enabled = False
End Sub

Sub Command6_Click ()
  On Error GoTo recover
  Dim OpenFileName As String
  If (OptFile.Value) Then
     OpenFileName = GetFileName(1)
     If OpenFileName <> "" Then
	Recorder1.PlaybackFileName = OpenFileName
     Else
	Exit Sub
     End If
  End If
  Me.Caption = Me.Caption & " - Press Esc to cancel playback"
  Recorder1.Playback = True
  Exit Sub
recover:
  Select Case Err
      Case 20001 To 20005
	  MsgBox Error, 48, "Error"
      Case 20006:
	  MsgBox "There are no recorded message to play back", 48, "Error"
  End Select
  Me.Caption = "Recording Custom Control Demo"
  Resume Next
End Sub

Sub EditCopyProc ()
    ClipBoard.SetText Document.SelText
End Sub

Sub EditCutProc ()
    ClipBoard.SetText Document.SelText
    Document.SelText = ""
End Sub

Sub EditPasteProc ()
    Document.SelText = ClipBoard.GetText()
End Sub

Sub FileNew ()
    Document.Text = ""
    Document.SetFocus
End Sub

Sub FOpenProc ()
    Dim RetVal
    On Error Resume Next
    Dim OpenFileName As String
    CMDialog1.Filename = "*.txt"
    CMDialog1.Action = 1
    If Err <> 32755 Then 'user pressed cancel
	OpenFileName = CMDialog1.Filename
	OpenFile (OpenFileName)
    End If
End Sub

Sub Form_Load ()
  OptMemory = True
  OptScreen = True
  Document.Text = "This is a demo of the recording control"
End Sub

Sub Form_Resize ()
    If windowstate <> 1 And ScaleHeight <> 0 Then
	Document.Visible = False
	Document.Height = ScaleHeight
	Document.Width = ScaleWidth * .75
	Command4.Left = Document.Width + 100
	Command5.Left = Document.Width + 100
	Command6.Left = Document.Width + 100
	Frame1.Left = Document.Width + 100
	Frame2.Left = Document.Width + 100
	ChkFast.Left = Document.Width + 100
	ChkCancel.Left = Document.Width + 100
	Document.Visible = True
    End If
End Sub

Function GetFileName (Action As Integer)
    On Error Resume Next
    CMDialog1.Filename = "record1.dat"
    CMDialog1.Action = Action
    If Err <> 32755 Then      'User cancelled dialog
	GetFileName = CMDialog1.Filename
    Else
	GetFileName = ""
    End If
End Function

Sub mnuAbout_Click ()
   MsgBox "Recorder Custom Control Demo", 64, "Recorder Custom Control Demo"
End Sub

Sub mnuECopy_Click ()
    EditCopyProc
End Sub

Sub mnuECut_Click ()
    EditCutProc
End Sub

Sub mnuEDelete_Click ()
  ' If cursor is not at the end of the notepad.
  If Document.SelStart <> Len(Document.Text) Then
    ' If nothing is selected, extend selection by one.
    If Document.SelLength = 0 Then
      Document.SelLength = 1
      ' If cursor is on a blank line, extend selection by two.
      If Asc(Document.SelText) = 13 Then
	Document.SelLength = 2
      End If
    End If
    ' Delete selected text.
    Document.SelText = ""
  End If
End Sub

Sub mnuEPaste_Click ()
    EditPasteProc
End Sub

Sub mnuESelectAll_Click ()
    Document.SelStart = 0
    Document.SelLength = Len(Document.Text)
End Sub

Sub mnuETime_Click ()
    Dim TimeStr As String, DateStr As String
    
    Document.SelText = Now
End Sub

Sub mnuFExit_Click ()
    Unload Me
    End
End Sub

Sub mnuFNew_Click ()
    FileNew
End Sub

Sub mnuFOpen_Click ()
    FOpenProc
End Sub

Sub mnuFSave_Click ()
    SaveFileAs "File1.Txt"
End Sub

Sub mnuFSaveAs_Click ()
    Dim SaveFileName As String
    SaveFileName = GetFileName(2)
    If SaveFileName <> "" Then
       SaveFileAs (SaveFileName)
    End If
End Sub

Sub mnuPlayback_Click ()
    Recorder1.PlaybackFileName = ""
    Recorder1.Playback = True
End Sub

Sub mnuRecord_Click ()
' The following code illustrates how to use
' the control to implement a keystroke/macro
' recorder.
    Recorder1.MessageType = 0
    Recorder1.RecordFileName = ""
    Recorder1.Record = True
    mnuRecord.Visible = False
    mnuStop.Visible = True
    mnuPlayback.Enabled = False
End Sub

Sub mnuStop_Click ()
    Recorder1.MessageType = 1
    Recorder1.Record = False
    mnuRecord.Visible = True
    mnuStop.Visible = False
    mnuPlayback.Enabled = True
End Sub

Sub OpenFile (Filename)
    Dim NL, TextIn, GetLine
    Dim fIndex As Integer

    NL = Chr$(13) + Chr$(10)
    
    On Error Resume Next
    ' open the selected file
    Open Filename For Input As #1
    If Err Then
	MsgBox "Can't open file: " + Filename
	Exit Sub
    End If
    ' change mousepointer to an hourglass
    screen.MousePointer = 11
    
    ' change form's caption and display new text
    Document.Tag = fIndex
    Document.Text = Input$(LOF(1), 1)
    Close #1
    ' reset mouse pointer
    screen.MousePointer = 0
End Sub

Sub OptForm_Click ()
    If (OptForm.Value) Then
    ' Set the recorder to record relative to the
    ' position of the form window
       Recorder1.RecordPlaybackRelativeTo = Me.hWnd
    End If
End Sub

Sub OptMemory_Click ()
    Recorder1.RecordFileName = ""
    Recorder1.PlaybackFileName = ""
End Sub

Sub OptScreen_Click ()
  If (OptScreen.Value) Then
     Recorder1.RecordPlaybackRelativeTo = 0
  End If
End Sub

Sub Recorder1_Finished (UserCancel As Integer)
    Me.Caption = "Recording Custom Control Demo"
    If (UserCancel) Then
       MsgBox "Playback cancelled by user"
    End If
End Sub

Sub SaveFileAs (Filename)
On Error Resume Next
    Dim Contents As String

    ' open the file
    Open Filename For Output As #1
    ' put contents of the notepad into a variable
    Contents = Document.Text
    ' display hourglass
    screen.MousePointer = 11
    ' write variable contents to saved file
    Print #1, Contents
    Close #1
    ' reset the mousepointer
    screen.MousePointer = 0
    ' set the Notepad's caption

    If Err Then
	MsgBox Error, 48, App.Title
    End If
End Sub

