/* Tale Unified Input Handler Application Header
 * Copyright (C) 1994 Tale Software
 * All rights reserved.
 */

/* UNIINP.H already included? */
#ifndef UNIINP_H
#define UNIINP_H

/* define origin data types as understood by tale software */
#ifndef TALE_DATA_TYPES
 #define TALE_DATA_TYPES
 typedef unsigned char ubyte;	   /* unsigned byte */
 typedef signed char byte;	   /* signed byte */
 typedef unsigned int uword;	   /* unsigned word */
 typedef signed int word;	   /* signed word */
 typedef unsigned long int udword; /* unsigned double word */
#endif

/* readstick() returns a pointer to this structure */
typedef struct { uword joy0xpos,joy0ypos; 
		 uword joy1xpos,joy1ypos;
	       } joypos;

/* these procedures are currently available */
/* keyboard functions */
byte getkeyboard(void);
byte freekeyboard(void);
ubyte lastkey(void);
byte keystatus(ubyte keycode);
byte keyboardled(ubyte ledstatus);
byte keyboardtyp(ubyte kbddelay,ubyte kbdtypem);
ubyte sysled(void);

/* joystick functions */
joypos far *readstick(ubyte stick);
ubyte readjbutton(void);

#endif /* UNIINP_H */
