UNIT StackOBJ ;




{**********************************************************************
 *                                                                    *
 *  PROGRAM :  StackOBJ                PC FILE NAME :  STACKOBJ.PAS   *
 *  ----------------------------------------------------------------  *
 *  LIBRARY MODULES USED :  DOS CRT                                   *
 *  BaseType :  TP6.0 TPU SOURCE: BASETYPE.PAS  BINARY:  BASETYPE.TPU *
 *  ----------------------------------------------------------------  *
 *  PURPOSE :  The purpose of this UNIT is to provide a Stack Object  *
 *             with basic functionality.                              *
 *  ----------------------------------------------------------------  *
 *  AUTHOR   :  Thomas E. Jenkins, Jr.                                *
 *              PROGRAMMER, UNIVERSITY OF SOUTH CAROLINA, USA         *
 *  BITNET   :  C0361@UNIVSCVM.BITNET                                 *
 *  INTERNET :  C0361@univscvm.csd.scarolina.EDU                      *
 *              tomj@csdserver3.csd.scarolina.EDU                     *
 *  ----------------------------------------------------------------  *
 *  DISCAIMER :  This program has been tested to the best of my       *
 *               abilities.  The author claims no responsibility      *
 *               for the performance or side effects this program     *
 *               may yield.                                           *
 *  ----------------------------------------------------------------  *
 *  DISTIBUTION :  This program is given freely to the PD realms.     *
 *                 It may freely be copied and distributed.  Any      *
 *                 one wishing to use some or whole parts of this     *
 *                 program for commercial use please contact the      *
 *                 author first.                                      *
 *                                                                    *
 **********************************************************************}




                                  INTERFACE






             {


                 Here is a basic view of the Stack object tree:

                 TObject                    [ to allow use with streams   ]
                    |
                    |
                    \___ TBaseOBJ           [ basic functions of stack &  ]
                             |              [ elements                    ]
                             |
                             \___ TElementOBJ    [ basic functionality of ]
                             /         |         [ any element            ]
                             |         |
                             |         \___ TStrOBJ [ string specific     ]
                             |         /            [ functions & storage ]
                             |         |
                             |         |
                             |         \___ TIntOBJ [ integer specific    ]
                             |         /            [ functions & storage ]
                             |         |
                             |         |
                             |         \___ TRealOBJ [ real specific      ]
                             |                       [ functions & storage]
                             |
                             \___ TStackOBJ      [ stack specific         ]
                                                 [ functions & storage    ]

             }


USES
       BaseTypes ;                  {  For the base TYPE TBaseOBJ  }
                                    {  and TElementOBJ             }




TYPE

       PStackOBJ                       = ^TStackOBJ ;
       TStackOBJ                       = OBJECT ( TBaseOBJ )

         stack                                   : PElementOBJ ;

         CONSTRUCTOR Init ;

         PROCEDURE   Push (     item             : PElementOBJ ) ;
           VIRTUAL ;

         FUNCTION    Pop                         : PElementOBJ ;
           VIRTUAL ;

         FUNCTION    Empty                       : BOOLEAN ;
           VIRTUAL ;

         DESTRUCTOR  Done ;
           VIRTUAL ;

         END ;  {  TStackOBJ  }




                                IMPLEMENTATION




 CONSTRUCTOR TStackOBJ.Init ;

   BEGIN  {  TStackOBJ.Init  }

     stack := NIL ;

     END ;  {  TStackOBJ.Init  }




 PROCEDURE   TStackOBJ.Push (     item           : PElementOBJ ) ;

  BEGIN  {  TStackOBJ.Push  }

    item^.last := stack ;

    stack := item ;

    END ;  {  TStackOBJ.Push  }




 FUNCTION    TStackOBJ.Pop                       : PElementOBJ ;

  BEGIN  {  TStackOBJ.Pop  }

    Pop := stack ;

    IF ( Empty )
     THEN
        Exit ;

    stack := stack^.last ;

    END ;  {  TStackOBJ.Pop  }




 FUNCTION    TStackOBJ.Empty                     : BOOLEAN ;

  BEGIN  {  TStackOBJ.Empty  }

    Empty := ( stack = NIL ) ;

    END ;  {  TStackOBJ.Empty  }




 DESTRUCTOR  TStackOBJ.Done ;

   BEGIN  {  TStackOBJ.Done  }

     WHILE ( stack <> NIL )
      DO
       BEGIN

         Dispose ( Pop , Done ) ;

         END ;  {  WHILE  }

     END ;  {  TStackOBJ.Done  }




END .