{*****************************************************}
{                                                     }
{   TSelectComboBox 1.0 for Delphi 2 by Duong Luu     }
{   E-mail: dluu@wt.net                               }
{   http://web.wt.net/~dluu/index.html                }
{                                                     }
{*****************************************************}
{                                                     }
{   It's a freeware, but keep author name with all    }
{   files. Enjoy!                                     }
{                                                     }
{*****************************************************}
unit SelCombo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

const
  Horizontal_ScrollBar = 20;

type

  TSelectComboBox = class(TComboBox)
  private
    FDDForm : TForm;
    FListBox : TListBox;
    FPopup: TPopupMenu;
    FSelectAll: TMenuItem;
    FDeSelectAll: TMenuItem;
    FHorzScrollBar : boolean;    
    procedure OwnerDrawCheck ( Index: integer );
    procedure OwnerDrawRect ( Index: integer );
    procedure Toggle( Index : integer );
    function IfChecked( Index: integer ) : boolean;    
  protected
    procedure DropDown; override;
  public
    constructor Create ( AOwner : TComponent ); override;
    destructor Destroy; override;
    procedure ClosePopUp( Sender : TObject );
    procedure ListBoxDrawItem( Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState );
    procedure ListBoxMouseDown( Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer );
    function SelectedList : TStringList;
    function NonSelectedList : TStringList;
    function SelectedString : string;
    procedure SelectAll( Sender: TObject );
    procedure DeSelectAll( Sender: TObject );
    procedure Checked( Index: integer );
    procedure UnChecked( Index: integer );
    function IsChecked ( Index: integer ) : boolean;
    procedure CheckAll;
    procedure UnCheckAll;        
  published
    property HorzScrollBar : boolean read FHorzScrollBar write FHorzScrollBar default false;
  end;

procedure Register;

implementation

constructor TSelectComboBox.Create ( AOwner : TComponent );
begin
  inherited Create( AOwner );
  // Creat PopUp List
  FDDForm := TForm.Create( self );

  // Create ListBox
  FListBox := TListBox.Create( FDDForm );
  FListBox.Parent := FDDForm;
  FListBox.Align := alClient;
  FListBox.Style := lbOwnerDrawFixed;
  FListBox.OnDrawItem := ListBoxDrawItem;
  FListBox.OnMouseDown := ListBoxMouseDown;

  // Create PopUp
  FPopUp := TPopupMenu.Create( FListBox );
  FSelectAll := TMenuItem.Create( FPopUp );
  FSelectAll.Caption := '&Select All';
  FDeSelectAll := TMenuItem.Create( FPopUp );
  FDeSelectAll.Caption := '&DeSelect All';
  FPopUp.Items.Insert( 0, FSelectAll );
  FPopUp.Items.Insert( 1, FDeSelectAll );
  FSelectAll.OnClick := SelectAll;
  FDeSelectAll.OnClick := DeSelectAll;
  FListBox.PopupMenu := FPopUp;
end;

destructor TSelectComboBox.Destroy;
begin
  FSelectAll.Free;
  FDeSelectAll.Free;
  FPopup.Free;
  FListBox.Free;
  FDDForm.Free;
  inherited Destroy;
end;

procedure TSelectComboBox.DropDown;
var
  ScreenPoint : TPoint;
  nDropDown : integer;
begin
  Inherited;
  if ( DropDownCount <= Items.Count ) then
    nDropDown := DropDownCount
  else
    nDropDown := Items.Count;

  // Assign Form coordinate and show
  ScreenPoint := Parent.ClientToScreen( Point( self.Left, self.Top+self.Height ) );
  FListBox.Font := self.Font;
  FListBox.Color := self.Color;  
  FListBox.ItemHeight := self.ItemHeight;
  FListBox.Items.Assign( Items );

  with FDDForm do
    begin
      Font := self.Font;
      Left  := ScreenPoint.X;
      Top   := ScreenPoint.Y;
      Width := self.Width;
      Height := ( nDropDown * self.ItemHeight ) + 5;
      if FHorzScrollBar then
        Height := Height + Horizontal_ScrollBar;
      Color := clAqua;
      BorderStyle := bsNone;
      OnDeactivate := ClosePopUp;
    end;
  if FHorzScrollBar then
    SendMessage(FListbox.Handle, LB_SetHorizontalExtent, 1000, Longint(0));
  FDDForm.Show;
end;

procedure TSelectComboBox.ClosePopUp( Sender : TObject );
begin
  Items.Assign( FListBox.Items );
  Text := SelectedString;
  (Sender as TForm).Close;
end;

procedure TSelectComboBox.OwnerDrawCheck ( Index: integer );
var
  Rect : TRect;
  FontHeight : integer;
begin
  FontHeight := FListBox.ItemHeight - 1;
  Rect := FListBox.ItemRect( Index );
  with FListBox.Canvas, Rect do
    begin
      MoveTo( Left+1, Top+1 );
      LineTo( Left+FontHeight , Top+FontHeight );
      MoveTo( Left+1, Top+FontHeight-1 );
      LineTo( Left+FontHeight , Top );
    end;
end;

procedure TSelectComboBox.OwnerDrawRect ( Index: integer );
var
  Rect : TRect;
  FontHeight : integer;
begin
  FontHeight := FListBox.ItemHeight - 1;
  Rect := FListBox.ItemRect( Index );
  with FListBox.Canvas, Rect do
    begin
      FillRect( Rect );
      Rectangle( Left+1, Top+1, Left+FontHeight, Top+FontHeight);
      TextOut( Left+FontHeight+3, Top, FListBox.Items[Index] );
    end;
end;

procedure TSelectComboBox.Toggle( Index : integer );
begin
  with FListBox do
    begin
      if ( Items.objects[ Index ] = pointer(1) ) then
        Items.objects[ Index ] := pointer(0)
      else
        Items.objects[ Index ] := pointer(1);
      Refresh;
    end;
end;

procedure TSelectComboBox.ListBoxDrawItem( Control: TWinControl; Index: Integer;
       Rect: TRect; State: TOwnerDrawState );
begin
  if IfChecked( Index ) then
    begin
      OwnerDrawRect( Index );
      OwnerDrawCheck( Index );
    end
  else
    OwnerDrawRect( Index );
end;

procedure TSelectComboBox.ListBoxMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
begin
  if (Sender As TListBox).ItemIndex = -1 then
    exit;
  Toggle( (Sender As TListBox).ItemIndex );
end;

function TSelectComboBox.SelectedList : TStringList;
var
  nCount, i : integer;
begin
  result := TStringList.Create;
  nCount := Items.Count-1;
  for i := 0 to nCount do
    if Items.Objects[ i ] = pointer(1) then
      result.Add( Items[ i ] );
end;

function TSelectComboBox.NonSelectedList : TStringList;
var
  nCount, i : integer;
begin
  result := TStringList.Create;
  nCount := Items.Count-1;
  for i := 0 to nCount do
    if Items.Objects[ i ] = pointer(0) then
      result.Add( Items[ i ] );
end;

function TSelectComboBox.SelectedString : string;
var
  i : integer;
begin
  result := '';
  with FListBox do
    for i := 0 to Items.Count-1 do
      if Items.Objects[ i ] = pointer(1) then
        result := result + Trim(Items[ i ]) + ',';
  if ( result <> '' ) then
    result := copy( result, 0, Length(result)-1 );
end;

//procedure TSelectComboBox.SelectAll( Sender: TObject );
procedure TSelectComboBox.SelectAll;
var
  i : integer;
begin
  with FListBox do
    begin
      for i := 0 to Items.Count-1 do
        Items.objects[ i ] := pointer(1);
      refresh;
    end;
end;

procedure TSelectComboBox.DeSelectAll( Sender: TObject );
var
  i : integer;
begin
  with FListBox do
    begin
      for i := 0 to Items.Count-1 do
        Items.objects[ i ] := pointer(0);
      refresh;
    end;
end;

function TSelectComboBox.IsChecked( Index: integer ) : boolean;
begin
  result := Items.Objects[ Index ] = pointer(1);
end;

function TSelectComboBox.IfChecked( Index: integer ) : boolean;
begin
  with FListBox do
    begin
      if Items.Objects[ Index ] = pointer(1) then
        result := True
      else
        result := False;
    end;
end;

procedure TSelectComboBox.Checked ( index : integer );
begin
  if ( index >= 0 ) and ( index <= Items.Count ) then
    Items.Objects[ index ] := Pointer(1);
end;

procedure TSelectComboBox.UnChecked ( index : integer );
begin
  if ( index >= 0 ) and ( index <= Items.Count ) then
    Items.Objects[ index ] := Pointer(0);
end;

procedure TSelectComboBox.CheckAll;
var
  i: integer;
begin
  for i := 0 to Items.Count-1 do
    Items.Objects[ i ] := Pointer(1);
end;

procedure TSelectComboBox.UnCheckAll;
var
  i: integer;
begin
  for i := 0 to Items.Count-1 do
    Items.Objects[ i ] := Pointer(0);
end;

procedure Register;
begin
  RegisterComponents('DLUU', [TSelectComboBox]);
end;

end.
