program object_inherit;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ Program to illustrate object inheritance, showing that descendant  }
{ object types inherit the data fields and the methods of their      }
{ ancestor type, but that instances of these object types do not     }
{ automatically inherit the values in these data fields of an        }
{ ancestor instance. This is only to be expected, as there may be    }
{ many instances and the program has no way of determining which     }
{ instance is appropriate. The programmer can, of course, write the  }
{ necessary code to transfer values as required and this is greatly  }
{ facilitated by the use of the 'dot' notation, as shown below.      }
{                                                                    }
{ INHERIT.PAS        R Shaw        23.9.91                           }
{____________________________________________________________________}

Uses  Crt;

Type

TAncestor = object
   a,b,c  : integer;
   constructor init(aa,bb,cc : integer);
   end;

TDescendant = object(TAncestor)
   d : integer;
   constructor init(ad,bd,cd,dd : integer);
   end;

TNewDescendant = object(TAncestor)
   d : integer;
   constructor init(dd : integer);
   procedure Inherit(Anc : TAncestor);
   end;

TNewAncestor = object(TDescendant)
   procedure Inherit(ADesc : TDescendant);
   end;


constructor TAncestor.Init(aa,bb,cc : integer);
begin
   a := aa;
   b := bb;
   c := cc;
end;

constructor TDescendant.Init(ad,bd,cd,dd : integer);
begin
   a := ad;
   b := bd;
   c := cd;
   d := dd;
end;

constructor TNewDescendant.Init(dd : integer);
begin
   d := dd;
end;

procedure TNewDescendant.Inherit(Anc : TAncestor);
begin
   a := Anc.a;
   b := Anc.b;
   c := Anc.c;
end;

procedure TNewAncestor.Inherit(ADesc : TDescendant);
begin
   a := ADesc.a;
   b := ADesc.b;
   c := ADesc.c;
end;

{Main}

Var
   Ancestor : TAncestor;
   NewAncestor : TNewAncestor;
   ADescendant : TDescendant;
   NewDescendant : TNewDescendant;

begin
   ClrScr;
   Ancestor.Init(1,2,3);
   ADescendant.Init(6,7,8,9);
   NewDescendant.Inherit(Ancestor);
   NewDescendant.Init(4);
   NewAncestor.Inherit(ADescendant);
   Writeln('Ancestor.a = ',Ancestor.a,'...b = ',Ancestor.b,'...c = ',Ancestor.c);
   writeln;
   writeln('ADescendant.a = ',ADescendant.a,'...b = ',ADescendant.b,'...c = '
           ,ADescendant.c,'...d = ',ADescendant.d);
   writeln;
   writeln('ADescendant has data fields of Ancestor but its own initialized values');
   writeln('and also a new field d and value');
   writeln('             --------------- ');
   writeln;
   writeln('NewDescendant.a = ',NewDescendant.a,'...b = ',NewDescendant.b,
            '...c = ',NewDescendant.c,'...d = ',NewDescendant.d);
   writeln;
   writeln('NewDescendant has same fields a,b,c and values as Ancestor');
   writeln('but new field and value d in addition');
   writeln('             --------------- ');
   writeln;
   writeln('NewAncestor.a = ',NewAncestor.a,'...b = ',NewAncestor.b,
            '...c = ',NewAncestor.c);
   writeln;
   writeln('NewAncestor has same fields as Ancestor but values changed ');
   writeln('to those of NewDescendant');
   writeln('             --------------- ');
   writeln;
   Ancestor := NewAncestor;
   writeln('Ancestor.a = ',Ancestor.a,'...b = ',Ancestor.b,'...c = ',Ancestor.c);
   writeln;
   writeln('Ancestor field values are now changed to those of NewAncestor');
   repeat until keypressed;
end.

