program FigureDemo;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ Original Copyright (c) 1989 by Borland Interational, Inc.            }
{ From P-47 of the Object-Oriented Programming Guide, version 5.5      }
{ Extending FIGURES.PAS with type Arc.                                 }
{ Types FullLine  and Rectangle added by R. Shaw  3.4.90  & 9.2.91     }
{    FIGDEMO.PAS  ->  FIGDEMO.EXE                                      }
{______________________________________________________________________}

uses Crt, DOS, Graph, Figures, GraphPRN;

type
  Arc = object (Circle)
    StartAngle, EndAngle : Integer;
    constructor Init(InitX, InitY : Integer;
                     InitRadius : Integer;
                     InitStartAngle, InitEndAngle : Integer);
    procedure Show; virtual;
    procedure Hide; virtual;
  end;

  FullLine = object(Point)
    XLength, YLength  : integer;
    constructor Init(InitX, InitY  : integer;
                     InitXLength, InitYLength : integer);
    procedure Show; virtual;
    procedure Hide; virtual;
  end;

  Rectangle = object(FullLine)
    constructor Init(InitX, InitY  : integer;
                     InitXLength, InitYLength : integer);
    procedure Show; virtual;
    procedure Hide; virtual;
  end;

var
  GraphDriver : Integer;
  GraphMode   : Integer;
  ErrorCode   : Integer;
  AnArc       : Arc;
  ACircle     : Circle;
  AFullLine   : FullLine;
  ARectangle  : Rectangle;
  APoint      : Point;
  Reply       : char;
  KeepColor   : word;
  x1,x2       : integer;

{--------------------------------------------------------}
{ Arc's method declarations:                             }
{--------------------------------------------------------}

constructor Arc.Init(InitX,InitY : Integer;
                     InitRadius : Integer;
                     InitStartAngle, InitEndAngle : Integer);
begin
  Circle.Init(InitX, InitY, InitRadius);
  StartAngle := InitStartAngle;
  EndAngle   := InitEndAngle;
end;

procedure Arc.Show;
begin
  Visible := True;
  Graph.Arc(X, Y, StartAngle, EndAngle, Radius);
end;

procedure Arc.Hide;
var
  TempColor : Word;
begin
  TempColor := Graph.GetColor;
  Graph.SetColor(GetBkColor);
  Visible := False;
  { Draw the arc in the background color to hide it }
  Graph.Arc(X, Y, StartAngle, EndAngle, Radius);
  SetColor(TempColor);
end;

{-------------------------------------------------------}
{  FullLine's method implementation                     }
{-------------------------------------------------------}

   constructor FullLine.Init(InitX, InitY : Integer;
                             InitXLength, InitYLength : Integer);

   begin
      Point.Init(InitX, InitY);
      XLength := InitXLength;
      YLength := InitYLength;
   end;

   procedure FullLine.Show;
   begin
      Visible := True;
      Graph.Line(X,Y,X + XLength,Y + YLength);
   end;

   procedure FullLine.Hide;
   var
      HoldColor : word;
   begin
      HoldColor := Graph.GetColor;
      Graph.SetColor(GetBkColor);
      Visible := false;
      Graph.Line(X,Y,X + XLength,Y + YLength);
      Graph.SetColor(HoldColor);
   end;

{-------------------------------------------------------}
{  Rectangle's method implementation                    }
{-------------------------------------------------------}

   constructor Rectangle.Init(InitX, InitY : Integer;
                             InitXLength, InitYLength : Integer);

   begin
      Point.Init(InitX, InitY);
      XLength := InitXLength;
      YLength := InitYLength;
   end;

   procedure Rectangle.Show;
   begin
      Visible := True;
      Graph.Rectangle(X,Y,X + XLength ,Y + YLength);
   end;

   procedure Rectangle.Hide;
   var
      HoldColor : word;
   begin
      HoldColor := Graph.GetColor;
      Graph.SetColor(GetBkColor);
      Visible := false;
      Graph.Rectangle(X,Y,X + XLength ,Y + YLength);
      Graph.SetColor(HoldColor);
   end;

{--------------------------------------------------------}
{ Main program:                                          }
{--------------------------------------------------------}

begin
  GraphDriver := Detect; { Let the BGI determine what board
                           you're using }
  DetectGraph(GraphDriver, GraphMode);
  InitGraph(GraphDriver, GraphMode,'');
  if GraphResult <> GrOK then
    begin
      WriteLn('>>Halted on graphics error:',
              GraphErrorMsg(GraphDriver));
      Halt(1)
    end;

{ All descendents of type Point contain virtual methods and    }
{ *must* be initialized before use through a constructor call. }

  ACircle.Init(151, 82,      { Initialize X,Y at 151,82 }
               50);          { Initialize radius of 50 pixels }
  AnArc.Init(151, 82,        { Initialize X,Y at 151,82 }
             25, 0, 90);     { Initialize radius of 25 pixels }
                             { Start angle: 0; End angle: 90 }

  AFullLine.Init(100,100,200,200);
  ARectangle.Init(200,200,100,100);
  APoint.Init(600,300);

{ Replace ARectangle with AFullLine or AnArc or ACircle to drag
  a full line or an arc or a circle instead of a full line }
{ Press Enter to stop dragging and end the program.   }

repeat
  ClearDevice;
  OutTextXY(0,0,' Use arrow keys to move figure. Press the ENTER key to show each new figure,');
  OutTextXY(0,20,' Rectangle, Full line, Circle, Arc, Point and to continue  ');
  ARectangle.Drag(5);       { Parameter is # of pixels to drag by }
  AFullLine.Drag(5);
  ACircle.Drag(5);
  AnArc.Drag(5);
  APoint.Drag(5);
  OutTextXY(50,410,'Repeat from the rectangle (y/n)? ');
  Reply := readkey;
  OutTextXY(320,410,Reply);
until Reply <> 'y';
  x1 := 480;
  Repeat
    OutTextXY(50,430,'Hide any figure? Use initial letter else N for next      ');
    Reply := UpCase(readkey);
    OutTextXY(x1,430,reply);
    x1 := x1 + 20;
    Case Reply of
      'A' : AnArc.Hide;
      'C' : ACircle.Hide;
      'F' : AFullLine.Hide;
      'P' : APoint.Hide;
      'R' : ARectangle.Hide;
     end;
  Until Reply ='N';
  x2 := 450;
  Repeat

    OutTextXY(50,450,'Show any figure? Use initial letter, Q to quit  ');
    Reply := UpCase(readkey);
    OutTextXY(x2,450,reply);
    x2 := x2 + 20;
    Case Reply of
      'A' : AnArc.Show;
      'C' : ACircle.Show;
      'F' : AFullLine.Show;
      'P' : APoint.Show;
      'R' : ARectangle.Show;
    end;
  Until Reply = 'Q';
  OutTextXY(50,470,'Is hardcopy required (y/n)? ');
  Reply := UpCase(readkey);
  OutTextXY(270,470,Reply);
  if Reply = 'Y' then HardCopy(4);
  CloseGraph;
  RestoreCRTMode;
end.



