{
        Object-Oriented Archive-viewer: ZIP-part
}

Unit      OOAVZip;

Interface

Uses      Dos,OOAV;


Type      ZFHeader=Record
                     Signature                         :longint;
                     Version,GPBFlag,Compress,Date,Time:word;
                     CRC32,CSize,USize                 :longint;
                     FNameLen,ExtraField               :word;
                   end;


type      PZipArchive=^TZipArchive;
          TZipArchive=object(TGeneralArchive)
                        constructor Init;
                        procedure FindFirst(var sr:SearchRec);virtual;
                        procedure FindNext(var sr:SearchRec);virtual;
                      private
                        Hdr:ZFHeader;
                        procedure GetHeader(var sr:SearchRec);
                      end;

implementation


Const     SIG = $04034B50;                  { Signature }


constructor TZipArchive.Init;
begin
  FillChar(Hdr,sizeof(Hdr),0);
end;


procedure TZipArchive.GetHeader(var sr:SearchRec);
var       b:byte;
          bc:word;
begin
  fillchar(sr,sizeof(sr),0);
  if eof(_FArchive) then
    exit;
  BlockRead(_FArchive,Hdr,SizeOf(Hdr),bc);
  if bc<>Sizeof(Hdr) then
    exit;
{ Why checking for Hdr.FNamelen=0?
  Because the comments inserted in a ZIP-file are at the last field }
  if Hdr.FNameLen=0 then
    exit;
  sr.Name:='';
  Repeat
    BlockRead(_FArchive,b,1);
    If b<>0 Then
      sr.Name:=sr.Name+Chr(b);
  Until (length(sr.Name)=Hdr.FNameLen) or (b=0);
  if b=0 then
    exit;
  Seek(_FArchive,FilePos(_FArchive)+Hdr.CSize+Hdr.ExtraField);
  sr.Size:=Hdr.USize;
  sr.Time:=Hdr.Date+Hdr.Time*longint(256*256);
end;


Procedure TZipArchive.FindFirst(var sr:SearchRec);
begin
  GetHeader(sr);
end;


Procedure TZipArchive.FindNext(var sr:SearchRec);
begin
  GetHeader(sr);
end;


end.